package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::Application`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:00:58.648Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationV2")
public class CfnApplicationV2 extends software.amazon.awscdk.core.CfnResource {
    protected CfnApplicationV2(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::KinesisAnalyticsV2::Application`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplicationV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRuntimeEnvironment() {
        return this.jsiiGet("runtimeEnvironment", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.RuntimeEnvironment`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeEnvironment(final java.lang.String value) {
        this.jsiiSet("runtimeEnvironment", java.util.Objects.requireNonNull(value, "runtimeEnvironment is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getServiceExecutionRole() {
        return this.jsiiGet("serviceExecutionRole", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ServiceExecutionRole`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceExecutionRole(final java.lang.String value) {
        this.jsiiSet("serviceExecutionRole", java.util.Objects.requireNonNull(value, "serviceExecutionRole is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.Object getApplicationConfiguration() {
        return this.jsiiGet("applicationConfiguration", java.lang.Object.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("applicationConfiguration", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty value) {
        this.jsiiSet("applicationConfiguration", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getApplicationDescription() {
        return this.jsiiGet("applicationDescription", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationDescription(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("applicationDescription", value);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("applicationName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationCodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCodeContent();
        /**
         * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontenttype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getCodeContentType();

        /**
         * @return a {@link Builder} of {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationCodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _codeContent;
            private java.lang.String _codeContentType;

            /**
             * Sets the value of CodeContent
             * @param value `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCodeContent(final software.amazon.awscdk.core.IResolvable value) {
                this._codeContent = java.util.Objects.requireNonNull(value, "codeContent is required");
                return this;
            }
            /**
             * Sets the value of CodeContent
             * @param value `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCodeContent(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CodeContentProperty value) {
                this._codeContent = java.util.Objects.requireNonNull(value, "codeContent is required");
                return this;
            }
            /**
             * Sets the value of CodeContentType
             * @param value `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContentType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCodeContentType(final java.lang.String value) {
                this._codeContentType = java.util.Objects.requireNonNull(value, "codeContentType is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationCodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ApplicationCodeConfigurationProperty build() {
                return new ApplicationCodeConfigurationProperty() {
                    private final java.lang.Object $codeContent = java.util.Objects.requireNonNull(_codeContent, "codeContent is required");
                    private final java.lang.String $codeContentType = java.util.Objects.requireNonNull(_codeContentType, "codeContentType is required");

                    @Override
                    public java.lang.Object getCodeContent() {
                        return this.$codeContent;
                    }

                    @Override
                    public java.lang.String getCodeContentType() {
                        return this.$codeContentType;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("codeContent", om.valueToTree(this.getCodeContent()));
                        obj.set("codeContentType", om.valueToTree(this.getCodeContentType()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationCodeConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContent`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontent
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getCodeContent() {
                return this.jsiiGet("codeContent", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.ApplicationCodeConfigurationProperty.CodeContentType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationcodeconfiguration.html#cfn-kinesisanalyticsv2-application-applicationcodeconfiguration-codecontenttype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getCodeContentType() {
                return this.jsiiGet("codeContentType", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationcodeconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getApplicationCodeConfiguration();
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationsnapshotconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getApplicationSnapshotConfiguration();
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-environmentproperties
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getEnvironmentProperties();
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-flinkapplicationconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getFlinkApplicationConfiguration();
        /**
         * `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-sqlapplicationconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getSqlApplicationConfiguration();

        /**
         * @return a {@link Builder} of {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _applicationCodeConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _applicationSnapshotConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _environmentProperties;
            @javax.annotation.Nullable
            private java.lang.Object _flinkApplicationConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _sqlApplicationConfiguration;

            /**
             * Sets the value of ApplicationCodeConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withApplicationCodeConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._applicationCodeConfiguration = value;
                return this;
            }
            /**
             * Sets the value of ApplicationCodeConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withApplicationCodeConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationCodeConfigurationProperty value) {
                this._applicationCodeConfiguration = value;
                return this;
            }
            /**
             * Sets the value of ApplicationSnapshotConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withApplicationSnapshotConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._applicationSnapshotConfiguration = value;
                return this;
            }
            /**
             * Sets the value of ApplicationSnapshotConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withApplicationSnapshotConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationSnapshotConfigurationProperty value) {
                this._applicationSnapshotConfiguration = value;
                return this;
            }
            /**
             * Sets the value of EnvironmentProperties
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEnvironmentProperties(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._environmentProperties = value;
                return this;
            }
            /**
             * Sets the value of EnvironmentProperties
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withEnvironmentProperties(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.EnvironmentPropertiesProperty value) {
                this._environmentProperties = value;
                return this;
            }
            /**
             * Sets the value of FlinkApplicationConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFlinkApplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._flinkApplicationConfiguration = value;
                return this;
            }
            /**
             * Sets the value of FlinkApplicationConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFlinkApplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.FlinkApplicationConfigurationProperty value) {
                this._flinkApplicationConfiguration = value;
                return this;
            }
            /**
             * Sets the value of SqlApplicationConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSqlApplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._sqlApplicationConfiguration = value;
                return this;
            }
            /**
             * Sets the value of SqlApplicationConfiguration
             * @param value `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSqlApplicationConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.SqlApplicationConfigurationProperty value) {
                this._sqlApplicationConfiguration = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ApplicationConfigurationProperty build() {
                return new ApplicationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $applicationCodeConfiguration = _applicationCodeConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $applicationSnapshotConfiguration = _applicationSnapshotConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $environmentProperties = _environmentProperties;
                    @javax.annotation.Nullable
                    private final java.lang.Object $flinkApplicationConfiguration = _flinkApplicationConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sqlApplicationConfiguration = _sqlApplicationConfiguration;

                    @Override
                    public java.lang.Object getApplicationCodeConfiguration() {
                        return this.$applicationCodeConfiguration;
                    }

                    @Override
                    public java.lang.Object getApplicationSnapshotConfiguration() {
                        return this.$applicationSnapshotConfiguration;
                    }

                    @Override
                    public java.lang.Object getEnvironmentProperties() {
                        return this.$environmentProperties;
                    }

                    @Override
                    public java.lang.Object getFlinkApplicationConfiguration() {
                        return this.$flinkApplicationConfiguration;
                    }

                    @Override
                    public java.lang.Object getSqlApplicationConfiguration() {
                        return this.$sqlApplicationConfiguration;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getApplicationCodeConfiguration() != null) {
                            obj.set("applicationCodeConfiguration", om.valueToTree(this.getApplicationCodeConfiguration()));
                        }
                        if (this.getApplicationSnapshotConfiguration() != null) {
                            obj.set("applicationSnapshotConfiguration", om.valueToTree(this.getApplicationSnapshotConfiguration()));
                        }
                        if (this.getEnvironmentProperties() != null) {
                            obj.set("environmentProperties", om.valueToTree(this.getEnvironmentProperties()));
                        }
                        if (this.getFlinkApplicationConfiguration() != null) {
                            obj.set("flinkApplicationConfiguration", om.valueToTree(this.getFlinkApplicationConfiguration()));
                        }
                        if (this.getSqlApplicationConfiguration() != null) {
                            obj.set("sqlApplicationConfiguration", om.valueToTree(this.getSqlApplicationConfiguration()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationCodeConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationcodeconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getApplicationCodeConfiguration() {
                return this.jsiiGet("applicationCodeConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.ApplicationConfigurationProperty.ApplicationSnapshotConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-applicationsnapshotconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getApplicationSnapshotConfiguration() {
                return this.jsiiGet("applicationSnapshotConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.ApplicationConfigurationProperty.EnvironmentProperties`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-environmentproperties
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getEnvironmentProperties() {
                return this.jsiiGet("environmentProperties", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.ApplicationConfigurationProperty.FlinkApplicationConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-flinkapplicationconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getFlinkApplicationConfiguration() {
                return this.jsiiGet("flinkApplicationConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.ApplicationConfigurationProperty.SqlApplicationConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationconfiguration.html#cfn-kinesisanalyticsv2-application-applicationconfiguration-sqlapplicationconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getSqlApplicationConfiguration() {
                return this.jsiiGet("sqlApplicationConfiguration", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationSnapshotConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html#cfn-kinesisanalyticsv2-application-applicationsnapshotconfiguration-snapshotsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getSnapshotsEnabled();

        /**
         * @return a {@link Builder} of {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ApplicationSnapshotConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _snapshotsEnabled;

            /**
             * Sets the value of SnapshotsEnabled
             * @param value `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSnapshotsEnabled(final java.lang.Boolean value) {
                this._snapshotsEnabled = java.util.Objects.requireNonNull(value, "snapshotsEnabled is required");
                return this;
            }
            /**
             * Sets the value of SnapshotsEnabled
             * @param value `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSnapshotsEnabled(final software.amazon.awscdk.core.IResolvable value) {
                this._snapshotsEnabled = java.util.Objects.requireNonNull(value, "snapshotsEnabled is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationSnapshotConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ApplicationSnapshotConfigurationProperty build() {
                return new ApplicationSnapshotConfigurationProperty() {
                    private final java.lang.Object $snapshotsEnabled = java.util.Objects.requireNonNull(_snapshotsEnabled, "snapshotsEnabled is required");

                    @Override
                    public java.lang.Object getSnapshotsEnabled() {
                        return this.$snapshotsEnabled;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("snapshotsEnabled", om.valueToTree(this.getSnapshotsEnabled()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationSnapshotConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.ApplicationSnapshotConfigurationProperty.SnapshotsEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-applicationsnapshotconfiguration.html#cfn-kinesisanalyticsv2-application-applicationsnapshotconfiguration-snapshotsenabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getSnapshotsEnabled() {
                return this.jsiiGet("snapshotsEnabled", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordcolumndelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordColumnDelimiter();
        /**
         * `CfnApplicationV2.CSVMappingParametersProperty.RecordRowDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordrowdelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordColumnDelimiter;
            private java.lang.String _recordRowDelimiter;

            /**
             * Sets the value of RecordColumnDelimiter
             * @param value `CfnApplicationV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumnDelimiter(final java.lang.String value) {
                this._recordColumnDelimiter = java.util.Objects.requireNonNull(value, "recordColumnDelimiter is required");
                return this;
            }
            /**
             * Sets the value of RecordRowDelimiter
             * @param value `CfnApplicationV2.CSVMappingParametersProperty.RecordRowDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordRowDelimiter(final java.lang.String value) {
                this._recordRowDelimiter = java.util.Objects.requireNonNull(value, "recordRowDelimiter is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CSVMappingParametersProperty build() {
                return new CSVMappingParametersProperty() {
                    private final java.lang.String $recordColumnDelimiter = java.util.Objects.requireNonNull(_recordColumnDelimiter, "recordColumnDelimiter is required");
                    private final java.lang.String $recordRowDelimiter = java.util.Objects.requireNonNull(_recordRowDelimiter, "recordRowDelimiter is required");

                    @Override
                    public java.lang.String getRecordColumnDelimiter() {
                        return this.$recordColumnDelimiter;
                    }

                    @Override
                    public java.lang.String getRecordRowDelimiter() {
                        return this.$recordRowDelimiter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                        obj.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CSVMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordcolumndelimiter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordColumnDelimiter() {
                return this.jsiiGet("recordColumnDelimiter", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.CSVMappingParametersProperty.RecordRowDelimiter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-csvmappingparameters.html#cfn-kinesisanalyticsv2-application-csvmappingparameters-recordrowdelimiter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordRowDelimiter() {
                return this.jsiiGet("recordRowDelimiter", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CheckpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.ConfigurationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-configurationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getConfigurationType();
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCheckpointingEnabled();
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointInterval`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointinterval
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getCheckpointInterval();
        /**
         * `CfnApplicationV2.CheckpointConfigurationProperty.MinPauseBetweenCheckpoints`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-minpausebetweencheckpoints
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getMinPauseBetweenCheckpoints();

        /**
         * @return a {@link Builder} of {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CheckpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _configurationType;
            @javax.annotation.Nullable
            private java.lang.Object _checkpointingEnabled;
            @javax.annotation.Nullable
            private java.lang.Number _checkpointInterval;
            @javax.annotation.Nullable
            private java.lang.Number _minPauseBetweenCheckpoints;

            /**
             * Sets the value of ConfigurationType
             * @param value `CfnApplicationV2.CheckpointConfigurationProperty.ConfigurationType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withConfigurationType(final java.lang.String value) {
                this._configurationType = java.util.Objects.requireNonNull(value, "configurationType is required");
                return this;
            }
            /**
             * Sets the value of CheckpointingEnabled
             * @param value `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCheckpointingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._checkpointingEnabled = value;
                return this;
            }
            /**
             * Sets the value of CheckpointingEnabled
             * @param value `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCheckpointingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._checkpointingEnabled = value;
                return this;
            }
            /**
             * Sets the value of CheckpointInterval
             * @param value `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointInterval`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCheckpointInterval(@javax.annotation.Nullable final java.lang.Number value) {
                this._checkpointInterval = value;
                return this;
            }
            /**
             * Sets the value of MinPauseBetweenCheckpoints
             * @param value `CfnApplicationV2.CheckpointConfigurationProperty.MinPauseBetweenCheckpoints`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMinPauseBetweenCheckpoints(@javax.annotation.Nullable final java.lang.Number value) {
                this._minPauseBetweenCheckpoints = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CheckpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CheckpointConfigurationProperty build() {
                return new CheckpointConfigurationProperty() {
                    private final java.lang.String $configurationType = java.util.Objects.requireNonNull(_configurationType, "configurationType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $checkpointingEnabled = _checkpointingEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.Number $checkpointInterval = _checkpointInterval;
                    @javax.annotation.Nullable
                    private final java.lang.Number $minPauseBetweenCheckpoints = _minPauseBetweenCheckpoints;

                    @Override
                    public java.lang.String getConfigurationType() {
                        return this.$configurationType;
                    }

                    @Override
                    public java.lang.Object getCheckpointingEnabled() {
                        return this.$checkpointingEnabled;
                    }

                    @Override
                    public java.lang.Number getCheckpointInterval() {
                        return this.$checkpointInterval;
                    }

                    @Override
                    public java.lang.Number getMinPauseBetweenCheckpoints() {
                        return this.$minPauseBetweenCheckpoints;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("configurationType", om.valueToTree(this.getConfigurationType()));
                        if (this.getCheckpointingEnabled() != null) {
                            obj.set("checkpointingEnabled", om.valueToTree(this.getCheckpointingEnabled()));
                        }
                        if (this.getCheckpointInterval() != null) {
                            obj.set("checkpointInterval", om.valueToTree(this.getCheckpointInterval()));
                        }
                        if (this.getMinPauseBetweenCheckpoints() != null) {
                            obj.set("minPauseBetweenCheckpoints", om.valueToTree(this.getMinPauseBetweenCheckpoints()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.CheckpointConfigurationProperty.ConfigurationType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-configurationtype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getConfigurationType() {
                return this.jsiiGet("configurationType", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointingEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointingenabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getCheckpointingEnabled() {
                return this.jsiiGet("checkpointingEnabled", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.CheckpointConfigurationProperty.CheckpointInterval`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-checkpointinterval
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getCheckpointInterval() {
                return this.jsiiGet("checkpointInterval", java.lang.Number.class);
            }

            /**
             * `CfnApplicationV2.CheckpointConfigurationProperty.MinPauseBetweenCheckpoints`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-checkpointconfiguration.html#cfn-kinesisanalyticsv2-application-checkpointconfiguration-minpausebetweencheckpoints
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getMinPauseBetweenCheckpoints() {
                return this.jsiiGet("minPauseBetweenCheckpoints", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeContentProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-s3contentlocation
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getS3ContentLocation();
        /**
         * `CfnApplicationV2.CodeContentProperty.TextContent`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-textcontent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTextContent();
        /**
         * `CfnApplicationV2.CodeContentProperty.ZipFileContent`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-zipfilecontent
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getZipFileContent();

        /**
         * @return a {@link Builder} of {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CodeContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _s3ContentLocation;
            @javax.annotation.Nullable
            private java.lang.String _textContent;
            @javax.annotation.Nullable
            private java.lang.String _zipFileContent;

            /**
             * Sets the value of S3ContentLocation
             * @param value `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withS3ContentLocation(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._s3ContentLocation = value;
                return this;
            }
            /**
             * Sets the value of S3ContentLocation
             * @param value `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withS3ContentLocation(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.S3ContentLocationProperty value) {
                this._s3ContentLocation = value;
                return this;
            }
            /**
             * Sets the value of TextContent
             * @param value `CfnApplicationV2.CodeContentProperty.TextContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTextContent(@javax.annotation.Nullable final java.lang.String value) {
                this._textContent = value;
                return this;
            }
            /**
             * Sets the value of ZipFileContent
             * @param value `CfnApplicationV2.CodeContentProperty.ZipFileContent`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withZipFileContent(@javax.annotation.Nullable final java.lang.String value) {
                this._zipFileContent = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CodeContentProperty build() {
                return new CodeContentProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $s3ContentLocation = _s3ContentLocation;
                    @javax.annotation.Nullable
                    private final java.lang.String $textContent = _textContent;
                    @javax.annotation.Nullable
                    private final java.lang.String $zipFileContent = _zipFileContent;

                    @Override
                    public java.lang.Object getS3ContentLocation() {
                        return this.$s3ContentLocation;
                    }

                    @Override
                    public java.lang.String getTextContent() {
                        return this.$textContent;
                    }

                    @Override
                    public java.lang.String getZipFileContent() {
                        return this.$zipFileContent;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getS3ContentLocation() != null) {
                            obj.set("s3ContentLocation", om.valueToTree(this.getS3ContentLocation()));
                        }
                        if (this.getTextContent() != null) {
                            obj.set("textContent", om.valueToTree(this.getTextContent()));
                        }
                        if (this.getZipFileContent() != null) {
                            obj.set("zipFileContent", om.valueToTree(this.getZipFileContent()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CodeContentProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.CodeContentProperty.S3ContentLocation`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-s3contentlocation
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getS3ContentLocation() {
                return this.jsiiGet("s3ContentLocation", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.CodeContentProperty.TextContent`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-textcontent
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getTextContent() {
                return this.jsiiGet("textContent", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.CodeContentProperty.ZipFileContent`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-codecontent.html#cfn-kinesisanalyticsv2-application-codecontent-zipfilecontent
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getZipFileContent() {
                return this.jsiiGet("zipFileContent", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentPropertiesProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html#cfn-kinesisanalyticsv2-application-environmentproperties-propertygroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getPropertyGroups();

        /**
         * @return a {@link Builder} of {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link EnvironmentPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _propertyGroups;

            /**
             * Sets the value of PropertyGroups
             * @param value `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPropertyGroups(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._propertyGroups = value;
                return this;
            }
            /**
             * Sets the value of PropertyGroups
             * @param value `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPropertyGroups(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._propertyGroups = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public EnvironmentPropertiesProperty build() {
                return new EnvironmentPropertiesProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $propertyGroups = _propertyGroups;

                    @Override
                    public java.lang.Object getPropertyGroups() {
                        return this.$propertyGroups;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getPropertyGroups() != null) {
                            obj.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.EnvironmentPropertiesProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.EnvironmentPropertiesProperty.PropertyGroups`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-environmentproperties.html#cfn-kinesisanalyticsv2-application-environmentproperties-propertygroups
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getPropertyGroups() {
                return this.jsiiGet("propertyGroups", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlinkApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-checkpointconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCheckpointConfiguration();
        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-monitoringconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getMonitoringConfiguration();
        /**
         * `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-parallelismconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getParallelismConfiguration();

        /**
         * @return a {@link Builder} of {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FlinkApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _checkpointConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _monitoringConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _parallelismConfiguration;

            /**
             * Sets the value of CheckpointConfiguration
             * @param value `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCheckpointConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._checkpointConfiguration = value;
                return this;
            }
            /**
             * Sets the value of CheckpointConfiguration
             * @param value `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCheckpointConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty value) {
                this._checkpointConfiguration = value;
                return this;
            }
            /**
             * Sets the value of MonitoringConfiguration
             * @param value `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMonitoringConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._monitoringConfiguration = value;
                return this;
            }
            /**
             * Sets the value of MonitoringConfiguration
             * @param value `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMonitoringConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MonitoringConfigurationProperty value) {
                this._monitoringConfiguration = value;
                return this;
            }
            /**
             * Sets the value of ParallelismConfiguration
             * @param value `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withParallelismConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._parallelismConfiguration = value;
                return this;
            }
            /**
             * Sets the value of ParallelismConfiguration
             * @param value `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withParallelismConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ParallelismConfigurationProperty value) {
                this._parallelismConfiguration = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlinkApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public FlinkApplicationConfigurationProperty build() {
                return new FlinkApplicationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $checkpointConfiguration = _checkpointConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $monitoringConfiguration = _monitoringConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $parallelismConfiguration = _parallelismConfiguration;

                    @Override
                    public java.lang.Object getCheckpointConfiguration() {
                        return this.$checkpointConfiguration;
                    }

                    @Override
                    public java.lang.Object getMonitoringConfiguration() {
                        return this.$monitoringConfiguration;
                    }

                    @Override
                    public java.lang.Object getParallelismConfiguration() {
                        return this.$parallelismConfiguration;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCheckpointConfiguration() != null) {
                            obj.set("checkpointConfiguration", om.valueToTree(this.getCheckpointConfiguration()));
                        }
                        if (this.getMonitoringConfiguration() != null) {
                            obj.set("monitoringConfiguration", om.valueToTree(this.getMonitoringConfiguration()));
                        }
                        if (this.getParallelismConfiguration() != null) {
                            obj.set("parallelismConfiguration", om.valueToTree(this.getParallelismConfiguration()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.FlinkApplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.FlinkApplicationConfigurationProperty.CheckpointConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-checkpointconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getCheckpointConfiguration() {
                return this.jsiiGet("checkpointConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.FlinkApplicationConfigurationProperty.MonitoringConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-monitoringconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getMonitoringConfiguration() {
                return this.jsiiGet("monitoringConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.FlinkApplicationConfigurationProperty.ParallelismConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-flinkapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-flinkapplicationconfiguration-parallelismconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getParallelismConfiguration() {
                return this.jsiiGet("parallelismConfiguration", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputLambdaProcessorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.InputLambdaProcessorProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html#cfn-kinesisanalyticsv2-application-inputlambdaprocessor-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param value `CfnApplicationV2.InputLambdaProcessorProperty.ResourceARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputLambdaProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputLambdaProcessorProperty build() {
                return new InputLambdaProcessorProperty() {
                    private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputLambdaProcessorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.InputLambdaProcessorProperty.ResourceARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputlambdaprocessor.html#cfn-kinesisanalyticsv2-application-inputlambdaprocessor-resourcearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputParallelismProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.InputParallelismProperty.Count`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html#cfn-kinesisanalyticsv2-application-inputparallelism-count
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getCount();

        /**
         * @return a {@link Builder} of {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Number _count;

            /**
             * Sets the value of Count
             * @param value `CfnApplicationV2.InputParallelismProperty.Count`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._count = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputParallelismProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputParallelismProperty build() {
                return new InputParallelismProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Number $count = _count;

                    @Override
                    public java.lang.Number getCount() {
                        return this.$count;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCount() != null) {
                            obj.set("count", om.valueToTree(this.getCount()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputParallelismProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.InputParallelismProperty.Count`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputparallelism.html#cfn-kinesisanalyticsv2-application-inputparallelism-count
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getCount() {
                return this.jsiiGet("count", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html#cfn-kinesisanalyticsv2-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputLambdaProcessor();

        /**
         * @return a {@link Builder} of {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _inputLambdaProcessor;

            /**
             * Sets the value of InputLambdaProcessor
             * @param value `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputLambdaProcessor = value;
                return this;
            }
            /**
             * Sets the value of InputLambdaProcessor
             * @param value `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputLambdaProcessorProperty value) {
                this._inputLambdaProcessor = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputProcessingConfigurationProperty build() {
                return new InputProcessingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputLambdaProcessor = _inputLambdaProcessor;

                    @Override
                    public java.lang.Object getInputLambdaProcessor() {
                        return this.$inputLambdaProcessor;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getInputLambdaProcessor() != null) {
                            obj.set("inputLambdaProcessor", om.valueToTree(this.getInputLambdaProcessor()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputProcessingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputprocessingconfiguration.html#cfn-kinesisanalyticsv2-application-inputprocessingconfiguration-inputlambdaprocessor
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputLambdaProcessor() {
                return this.jsiiGet("inputLambdaProcessor", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.InputProperty.InputSchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputSchema();
        /**
         * `CfnApplicationV2.InputProperty.NamePrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-nameprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getNamePrefix();
        /**
         * `CfnApplicationV2.InputProperty.InputParallelism`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputparallelism
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputParallelism();
        /**
         * `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputprocessingconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputProcessingConfiguration();
        /**
         * `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisfirehoseinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getKinesisFirehoseInput();
        /**
         * `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisstreamsinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getKinesisStreamsInput();

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _inputSchema;
            private java.lang.String _namePrefix;
            @javax.annotation.Nullable
            private java.lang.Object _inputParallelism;
            @javax.annotation.Nullable
            private java.lang.Object _inputProcessingConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisFirehoseInput;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisStreamsInput;

            /**
             * Sets the value of InputSchema
             * @param value `CfnApplicationV2.InputProperty.InputSchema`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputSchema(final software.amazon.awscdk.core.IResolvable value) {
                this._inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                return this;
            }
            /**
             * Sets the value of InputSchema
             * @param value `CfnApplicationV2.InputProperty.InputSchema`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputSchemaProperty value) {
                this._inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                return this;
            }
            /**
             * Sets the value of NamePrefix
             * @param value `CfnApplicationV2.InputProperty.NamePrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNamePrefix(final java.lang.String value) {
                this._namePrefix = java.util.Objects.requireNonNull(value, "namePrefix is required");
                return this;
            }
            /**
             * Sets the value of InputParallelism
             * @param value `CfnApplicationV2.InputProperty.InputParallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputParallelism = value;
                return this;
            }
            /**
             * Sets the value of InputParallelism
             * @param value `CfnApplicationV2.InputProperty.InputParallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputParallelismProperty value) {
                this._inputParallelism = value;
                return this;
            }
            /**
             * Sets the value of InputProcessingConfiguration
             * @param value `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputProcessingConfiguration = value;
                return this;
            }
            /**
             * Sets the value of InputProcessingConfiguration
             * @param value `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputProcessingConfigurationProperty value) {
                this._inputProcessingConfiguration = value;
                return this;
            }
            /**
             * Sets the value of KinesisFirehoseInput
             * @param value `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kinesisFirehoseInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisFirehoseInput
             * @param value `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.KinesisFirehoseInputProperty value) {
                this._kinesisFirehoseInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamsInput
             * @param value `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kinesisStreamsInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamsInput
             * @param value `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.KinesisStreamsInputProperty value) {
                this._kinesisStreamsInput = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputProperty build() {
                return new InputProperty() {
                    private final java.lang.Object $inputSchema = java.util.Objects.requireNonNull(_inputSchema, "inputSchema is required");
                    private final java.lang.String $namePrefix = java.util.Objects.requireNonNull(_namePrefix, "namePrefix is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputParallelism = _inputParallelism;
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputProcessingConfiguration = _inputProcessingConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisFirehoseInput = _kinesisFirehoseInput;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisStreamsInput = _kinesisStreamsInput;

                    @Override
                    public java.lang.Object getInputSchema() {
                        return this.$inputSchema;
                    }

                    @Override
                    public java.lang.String getNamePrefix() {
                        return this.$namePrefix;
                    }

                    @Override
                    public java.lang.Object getInputParallelism() {
                        return this.$inputParallelism;
                    }

                    @Override
                    public java.lang.Object getInputProcessingConfiguration() {
                        return this.$inputProcessingConfiguration;
                    }

                    @Override
                    public java.lang.Object getKinesisFirehoseInput() {
                        return this.$kinesisFirehoseInput;
                    }

                    @Override
                    public java.lang.Object getKinesisStreamsInput() {
                        return this.$kinesisStreamsInput;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("inputSchema", om.valueToTree(this.getInputSchema()));
                        obj.set("namePrefix", om.valueToTree(this.getNamePrefix()));
                        if (this.getInputParallelism() != null) {
                            obj.set("inputParallelism", om.valueToTree(this.getInputParallelism()));
                        }
                        if (this.getInputProcessingConfiguration() != null) {
                            obj.set("inputProcessingConfiguration", om.valueToTree(this.getInputProcessingConfiguration()));
                        }
                        if (this.getKinesisFirehoseInput() != null) {
                            obj.set("kinesisFirehoseInput", om.valueToTree(this.getKinesisFirehoseInput()));
                        }
                        if (this.getKinesisStreamsInput() != null) {
                            obj.set("kinesisStreamsInput", om.valueToTree(this.getKinesisStreamsInput()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.InputProperty.InputSchema`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputschema
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getInputSchema() {
                return this.jsiiGet("inputSchema", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.InputProperty.NamePrefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-nameprefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getNamePrefix() {
                return this.jsiiGet("namePrefix", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.InputProperty.InputParallelism`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputparallelism
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputParallelism() {
                return this.jsiiGet("inputParallelism", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.InputProperty.InputProcessingConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-inputprocessingconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputProcessingConfiguration() {
                return this.jsiiGet("inputProcessingConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.InputProperty.KinesisFirehoseInput`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisfirehoseinput
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getKinesisFirehoseInput() {
                return this.jsiiGet("kinesisFirehoseInput", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.InputProperty.KinesisStreamsInput`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-input.html#cfn-kinesisanalyticsv2-application-input-kinesisstreamsinput
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getKinesisStreamsInput() {
                return this.jsiiGet("kinesisStreamsInput", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputSchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordColumns`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordcolumns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRecordColumns();
        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordFormat`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordformat
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRecordFormat();
        /**
         * `CfnApplicationV2.InputSchemaProperty.RecordEncoding`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordencoding
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordEncoding();

        /**
         * @return a {@link Builder} of {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _recordColumns;
            private java.lang.Object _recordFormat;
            @javax.annotation.Nullable
            private java.lang.String _recordEncoding;

            /**
             * Sets the value of RecordColumns
             * @param value `CfnApplicationV2.InputSchemaProperty.RecordColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumns(final software.amazon.awscdk.core.IResolvable value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordColumns
             * @param value `CfnApplicationV2.InputSchemaProperty.RecordColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumns(final java.util.List<java.lang.Object> value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value `CfnApplicationV2.InputSchemaProperty.RecordFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormat(final software.amazon.awscdk.core.IResolvable value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value `CfnApplicationV2.InputSchemaProperty.RecordFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.RecordFormatProperty value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordEncoding
             * @param value `CfnApplicationV2.InputSchemaProperty.RecordEncoding`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordEncoding(@javax.annotation.Nullable final java.lang.String value) {
                this._recordEncoding = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputSchemaProperty build() {
                return new InputSchemaProperty() {
                    private final java.lang.Object $recordColumns = java.util.Objects.requireNonNull(_recordColumns, "recordColumns is required");
                    private final java.lang.Object $recordFormat = java.util.Objects.requireNonNull(_recordFormat, "recordFormat is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $recordEncoding = _recordEncoding;

                    @Override
                    public java.lang.Object getRecordColumns() {
                        return this.$recordColumns;
                    }

                    @Override
                    public java.lang.Object getRecordFormat() {
                        return this.$recordFormat;
                    }

                    @Override
                    public java.lang.String getRecordEncoding() {
                        return this.$recordEncoding;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                        obj.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                        if (this.getRecordEncoding() != null) {
                            obj.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.InputSchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.InputSchemaProperty.RecordColumns`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordcolumns
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRecordColumns() {
                return this.jsiiGet("recordColumns", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.InputSchemaProperty.RecordFormat`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordformat
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRecordFormat() {
                return this.jsiiGet("recordFormat", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.InputSchemaProperty.RecordEncoding`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-inputschema.html#cfn-kinesisanalyticsv2-application-inputschema-recordencoding
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getRecordEncoding() {
                return this.jsiiGet("recordEncoding", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.JSONMappingParametersProperty.RecordRowPath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html#cfn-kinesisanalyticsv2-application-jsonmappingparameters-recordrowpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordRowPath;

            /**
             * Sets the value of RecordRowPath
             * @param value `CfnApplicationV2.JSONMappingParametersProperty.RecordRowPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordRowPath(final java.lang.String value) {
                this._recordRowPath = java.util.Objects.requireNonNull(value, "recordRowPath is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public JSONMappingParametersProperty build() {
                return new JSONMappingParametersProperty() {
                    private final java.lang.String $recordRowPath = java.util.Objects.requireNonNull(_recordRowPath, "recordRowPath is required");

                    @Override
                    public java.lang.String getRecordRowPath() {
                        return this.$recordRowPath;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.JSONMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.JSONMappingParametersProperty.RecordRowPath`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-jsonmappingparameters.html#cfn-kinesisanalyticsv2-application-jsonmappingparameters-recordrowpath
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordRowPath() {
                return this.jsiiGet("recordRowPath", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseInputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.KinesisFirehoseInputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html#cfn-kinesisanalyticsv2-application-kinesisfirehoseinput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param value `CfnApplicationV2.KinesisFirehoseInputProperty.ResourceARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public KinesisFirehoseInputProperty build() {
                return new KinesisFirehoseInputProperty() {
                    private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.KinesisFirehoseInputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.KinesisFirehoseInputProperty.ResourceARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisfirehoseinput.html#cfn-kinesisanalyticsv2-application-kinesisfirehoseinput-resourcearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamsInputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.KinesisStreamsInputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html#cfn-kinesisanalyticsv2-application-kinesisstreamsinput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _resourceArn;

            /**
             * Sets the value of ResourceArn
             * @param value `CfnApplicationV2.KinesisStreamsInputProperty.ResourceARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public KinesisStreamsInputProperty build() {
                return new KinesisStreamsInputProperty() {
                    private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.KinesisStreamsInputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.KinesisStreamsInputProperty.ResourceARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-kinesisstreamsinput.html#cfn-kinesisanalyticsv2-application-kinesisstreamsinput-resourcearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-csvmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCsvMappingParameters();
        /**
         * `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-jsonmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getJsonMappingParameters();

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _csvMappingParameters;
            @javax.annotation.Nullable
            private java.lang.Object _jsonMappingParameters;

            /**
             * Sets the value of CsvMappingParameters
             * @param value `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of CsvMappingParameters
             * @param value `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CSVMappingParametersProperty value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._jsonMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.JSONMappingParametersProperty value) {
                this._jsonMappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public MappingParametersProperty build() {
                return new MappingParametersProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $csvMappingParameters = _csvMappingParameters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $jsonMappingParameters = _jsonMappingParameters;

                    @Override
                    public java.lang.Object getCsvMappingParameters() {
                        return this.$csvMappingParameters;
                    }

                    @Override
                    public java.lang.Object getJsonMappingParameters() {
                        return this.$jsonMappingParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCsvMappingParameters() != null) {
                            obj.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                        }
                        if (this.getJsonMappingParameters() != null) {
                            obj.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.MappingParametersProperty.CSVMappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-csvmappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getCsvMappingParameters() {
                return this.jsiiGet("csvMappingParameters", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.MappingParametersProperty.JSONMappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-mappingparameters.html#cfn-kinesisanalyticsv2-application-mappingparameters-jsonmappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getJsonMappingParameters() {
                return this.jsiiGet("jsonMappingParameters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.ConfigurationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-configurationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getConfigurationType();
        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.LogLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-loglevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getLogLevel();
        /**
         * `CfnApplicationV2.MonitoringConfigurationProperty.MetricsLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-metricslevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getMetricsLevel();

        /**
         * @return a {@link Builder} of {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _configurationType;
            @javax.annotation.Nullable
            private java.lang.String _logLevel;
            @javax.annotation.Nullable
            private java.lang.String _metricsLevel;

            /**
             * Sets the value of ConfigurationType
             * @param value `CfnApplicationV2.MonitoringConfigurationProperty.ConfigurationType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withConfigurationType(final java.lang.String value) {
                this._configurationType = java.util.Objects.requireNonNull(value, "configurationType is required");
                return this;
            }
            /**
             * Sets the value of LogLevel
             * @param value `CfnApplicationV2.MonitoringConfigurationProperty.LogLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withLogLevel(@javax.annotation.Nullable final java.lang.String value) {
                this._logLevel = value;
                return this;
            }
            /**
             * Sets the value of MetricsLevel
             * @param value `CfnApplicationV2.MonitoringConfigurationProperty.MetricsLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMetricsLevel(@javax.annotation.Nullable final java.lang.String value) {
                this._metricsLevel = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public MonitoringConfigurationProperty build() {
                return new MonitoringConfigurationProperty() {
                    private final java.lang.String $configurationType = java.util.Objects.requireNonNull(_configurationType, "configurationType is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $logLevel = _logLevel;
                    @javax.annotation.Nullable
                    private final java.lang.String $metricsLevel = _metricsLevel;

                    @Override
                    public java.lang.String getConfigurationType() {
                        return this.$configurationType;
                    }

                    @Override
                    public java.lang.String getLogLevel() {
                        return this.$logLevel;
                    }

                    @Override
                    public java.lang.String getMetricsLevel() {
                        return this.$metricsLevel;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("configurationType", om.valueToTree(this.getConfigurationType()));
                        if (this.getLogLevel() != null) {
                            obj.set("logLevel", om.valueToTree(this.getLogLevel()));
                        }
                        if (this.getMetricsLevel() != null) {
                            obj.set("metricsLevel", om.valueToTree(this.getMetricsLevel()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MonitoringConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.MonitoringConfigurationProperty.ConfigurationType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-configurationtype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getConfigurationType() {
                return this.jsiiGet("configurationType", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.MonitoringConfigurationProperty.LogLevel`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-loglevel
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getLogLevel() {
                return this.jsiiGet("logLevel", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.MonitoringConfigurationProperty.MetricsLevel`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-monitoringconfiguration.html#cfn-kinesisanalyticsv2-application-monitoringconfiguration-metricslevel
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getMetricsLevel() {
                return this.jsiiGet("metricsLevel", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParallelismConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.ConfigurationType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-configurationtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getConfigurationType();
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-autoscalingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getAutoScalingEnabled();
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.Parallelism`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelism
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getParallelism();
        /**
         * `CfnApplicationV2.ParallelismConfigurationProperty.ParallelismPerKPU`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelismperkpu
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getParallelismPerKpu();

        /**
         * @return a {@link Builder} of {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ParallelismConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _configurationType;
            @javax.annotation.Nullable
            private java.lang.Object _autoScalingEnabled;
            @javax.annotation.Nullable
            private java.lang.Number _parallelism;
            @javax.annotation.Nullable
            private java.lang.Number _parallelismPerKpu;

            /**
             * Sets the value of ConfigurationType
             * @param value `CfnApplicationV2.ParallelismConfigurationProperty.ConfigurationType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withConfigurationType(final java.lang.String value) {
                this._configurationType = java.util.Objects.requireNonNull(value, "configurationType is required");
                return this;
            }
            /**
             * Sets the value of AutoScalingEnabled
             * @param value `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAutoScalingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this._autoScalingEnabled = value;
                return this;
            }
            /**
             * Sets the value of AutoScalingEnabled
             * @param value `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withAutoScalingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._autoScalingEnabled = value;
                return this;
            }
            /**
             * Sets the value of Parallelism
             * @param value `CfnApplicationV2.ParallelismConfigurationProperty.Parallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withParallelism(@javax.annotation.Nullable final java.lang.Number value) {
                this._parallelism = value;
                return this;
            }
            /**
             * Sets the value of ParallelismPerKpu
             * @param value `CfnApplicationV2.ParallelismConfigurationProperty.ParallelismPerKPU`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withParallelismPerKpu(@javax.annotation.Nullable final java.lang.Number value) {
                this._parallelismPerKpu = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParallelismConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ParallelismConfigurationProperty build() {
                return new ParallelismConfigurationProperty() {
                    private final java.lang.String $configurationType = java.util.Objects.requireNonNull(_configurationType, "configurationType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $autoScalingEnabled = _autoScalingEnabled;
                    @javax.annotation.Nullable
                    private final java.lang.Number $parallelism = _parallelism;
                    @javax.annotation.Nullable
                    private final java.lang.Number $parallelismPerKpu = _parallelismPerKpu;

                    @Override
                    public java.lang.String getConfigurationType() {
                        return this.$configurationType;
                    }

                    @Override
                    public java.lang.Object getAutoScalingEnabled() {
                        return this.$autoScalingEnabled;
                    }

                    @Override
                    public java.lang.Number getParallelism() {
                        return this.$parallelism;
                    }

                    @Override
                    public java.lang.Number getParallelismPerKpu() {
                        return this.$parallelismPerKpu;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("configurationType", om.valueToTree(this.getConfigurationType()));
                        if (this.getAutoScalingEnabled() != null) {
                            obj.set("autoScalingEnabled", om.valueToTree(this.getAutoScalingEnabled()));
                        }
                        if (this.getParallelism() != null) {
                            obj.set("parallelism", om.valueToTree(this.getParallelism()));
                        }
                        if (this.getParallelismPerKpu() != null) {
                            obj.set("parallelismPerKpu", om.valueToTree(this.getParallelismPerKpu()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ParallelismConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.ParallelismConfigurationProperty.ConfigurationType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-configurationtype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getConfigurationType() {
                return this.jsiiGet("configurationType", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.ParallelismConfigurationProperty.AutoScalingEnabled`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-autoscalingenabled
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getAutoScalingEnabled() {
                return this.jsiiGet("autoScalingEnabled", java.lang.Object.class);
            }

            /**
             * `CfnApplicationV2.ParallelismConfigurationProperty.Parallelism`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelism
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getParallelism() {
                return this.jsiiGet("parallelism", java.lang.Number.class);
            }

            /**
             * `CfnApplicationV2.ParallelismConfigurationProperty.ParallelismPerKPU`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-parallelismconfiguration.html#cfn-kinesisanalyticsv2-application-parallelismconfiguration-parallelismperkpu
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getParallelismPerKpu() {
                return this.jsiiGet("parallelismPerKpu", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyGroupProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.PropertyGroupProperty.PropertyGroupId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertygroupid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getPropertyGroupId();
        /**
         * `CfnApplicationV2.PropertyGroupProperty.PropertyMap`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertymap
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getPropertyMap();

        /**
         * @return a {@link Builder} of {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _propertyGroupId;
            @javax.annotation.Nullable
            private java.lang.Object _propertyMap;

            /**
             * Sets the value of PropertyGroupId
             * @param value `CfnApplicationV2.PropertyGroupProperty.PropertyGroupId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPropertyGroupId(@javax.annotation.Nullable final java.lang.String value) {
                this._propertyGroupId = value;
                return this;
            }
            /**
             * Sets the value of PropertyMap
             * @param value `CfnApplicationV2.PropertyGroupProperty.PropertyMap`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withPropertyMap(@javax.annotation.Nullable final java.lang.Object value) {
                this._propertyMap = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public PropertyGroupProperty build() {
                return new PropertyGroupProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $propertyGroupId = _propertyGroupId;
                    @javax.annotation.Nullable
                    private final java.lang.Object $propertyMap = _propertyMap;

                    @Override
                    public java.lang.String getPropertyGroupId() {
                        return this.$propertyGroupId;
                    }

                    @Override
                    public java.lang.Object getPropertyMap() {
                        return this.$propertyMap;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getPropertyGroupId() != null) {
                            obj.set("propertyGroupId", om.valueToTree(this.getPropertyGroupId()));
                        }
                        if (this.getPropertyMap() != null) {
                            obj.set("propertyMap", om.valueToTree(this.getPropertyMap()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.PropertyGroupProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.PropertyGroupProperty.PropertyGroupId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertygroupid
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getPropertyGroupId() {
                return this.jsiiGet("propertyGroupId", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.PropertyGroupProperty.PropertyMap`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-propertygroup.html#cfn-kinesisanalyticsv2-application-propertygroup-propertymap
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getPropertyMap() {
                return this.jsiiGet("propertyMap", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.RecordColumnProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getName();
        /**
         * `CfnApplicationV2.RecordColumnProperty.SqlType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-sqltype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSqlType();
        /**
         * `CfnApplicationV2.RecordColumnProperty.Mapping`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-mapping
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getMapping();

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _sqlType;
            @javax.annotation.Nullable
            private java.lang.String _mapping;

            /**
             * Sets the value of Name
             * @param value `CfnApplicationV2.RecordColumnProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of SqlType
             * @param value `CfnApplicationV2.RecordColumnProperty.SqlType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSqlType(final java.lang.String value) {
                this._sqlType = java.util.Objects.requireNonNull(value, "sqlType is required");
                return this;
            }
            /**
             * Sets the value of Mapping
             * @param value `CfnApplicationV2.RecordColumnProperty.Mapping`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMapping(@javax.annotation.Nullable final java.lang.String value) {
                this._mapping = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RecordColumnProperty build() {
                return new RecordColumnProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private final java.lang.String $sqlType = java.util.Objects.requireNonNull(_sqlType, "sqlType is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $mapping = _mapping;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public java.lang.String getSqlType() {
                        return this.$sqlType;
                    }

                    @Override
                    public java.lang.String getMapping() {
                        return this.$mapping;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        obj.set("sqlType", om.valueToTree(this.getSqlType()));
                        if (this.getMapping() != null) {
                            obj.set("mapping", om.valueToTree(this.getMapping()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.RecordColumnProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.RecordColumnProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-name
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.RecordColumnProperty.SqlType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-sqltype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getSqlType() {
                return this.jsiiGet("sqlType", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.RecordColumnProperty.Mapping`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordcolumn.html#cfn-kinesisanalyticsv2-application-recordcolumn-mapping
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getMapping() {
                return this.jsiiGet("mapping", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.RecordFormatProperty.RecordFormatType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-recordformattype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordFormatType();
        /**
         * `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-mappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getMappingParameters();

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordFormatType;
            @javax.annotation.Nullable
            private java.lang.Object _mappingParameters;

            /**
             * Sets the value of RecordFormatType
             * @param value `CfnApplicationV2.RecordFormatProperty.RecordFormatType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormatType(final java.lang.String value) {
                this._recordFormatType = java.util.Objects.requireNonNull(value, "recordFormatType is required");
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._mappingParameters = value;
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.MappingParametersProperty value) {
                this._mappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RecordFormatProperty build() {
                return new RecordFormatProperty() {
                    private final java.lang.String $recordFormatType = java.util.Objects.requireNonNull(_recordFormatType, "recordFormatType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $mappingParameters = _mappingParameters;

                    @Override
                    public java.lang.String getRecordFormatType() {
                        return this.$recordFormatType;
                    }

                    @Override
                    public java.lang.Object getMappingParameters() {
                        return this.$mappingParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                        if (this.getMappingParameters() != null) {
                            obj.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.RecordFormatProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.RecordFormatProperty.RecordFormatType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-recordformattype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordFormatType() {
                return this.jsiiGet("recordFormatType", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.RecordFormatProperty.MappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-recordformat.html#cfn-kinesisanalyticsv2-application-recordformat-mappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getMappingParameters() {
                return this.jsiiGet("mappingParameters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ContentLocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.S3ContentLocationProperty.BucketARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-bucketarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getBucketArn();
        /**
         * `CfnApplicationV2.S3ContentLocationProperty.FileKey`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-filekey
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getFileKey();
        /**
         * `CfnApplicationV2.S3ContentLocationProperty.ObjectVersion`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-objectversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getObjectVersion();

        /**
         * @return a {@link Builder} of {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3ContentLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _bucketArn;
            @javax.annotation.Nullable
            private java.lang.String _fileKey;
            @javax.annotation.Nullable
            private java.lang.String _objectVersion;

            /**
             * Sets the value of BucketArn
             * @param value `CfnApplicationV2.S3ContentLocationProperty.BucketARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBucketArn(@javax.annotation.Nullable final java.lang.String value) {
                this._bucketArn = value;
                return this;
            }
            /**
             * Sets the value of FileKey
             * @param value `CfnApplicationV2.S3ContentLocationProperty.FileKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFileKey(@javax.annotation.Nullable final java.lang.String value) {
                this._fileKey = value;
                return this;
            }
            /**
             * Sets the value of ObjectVersion
             * @param value `CfnApplicationV2.S3ContentLocationProperty.ObjectVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withObjectVersion(@javax.annotation.Nullable final java.lang.String value) {
                this._objectVersion = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ContentLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public S3ContentLocationProperty build() {
                return new S3ContentLocationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $bucketArn = _bucketArn;
                    @javax.annotation.Nullable
                    private final java.lang.String $fileKey = _fileKey;
                    @javax.annotation.Nullable
                    private final java.lang.String $objectVersion = _objectVersion;

                    @Override
                    public java.lang.String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public java.lang.String getFileKey() {
                        return this.$fileKey;
                    }

                    @Override
                    public java.lang.String getObjectVersion() {
                        return this.$objectVersion;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getBucketArn() != null) {
                            obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                        }
                        if (this.getFileKey() != null) {
                            obj.set("fileKey", om.valueToTree(this.getFileKey()));
                        }
                        if (this.getObjectVersion() != null) {
                            obj.set("objectVersion", om.valueToTree(this.getObjectVersion()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.S3ContentLocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.S3ContentLocationProperty.BucketARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-bucketarn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.S3ContentLocationProperty.FileKey`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-filekey
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getFileKey() {
                return this.jsiiGet("fileKey", java.lang.String.class);
            }

            /**
             * `CfnApplicationV2.S3ContentLocationProperty.ObjectVersion`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-s3contentlocation.html#cfn-kinesisanalyticsv2-application-s3contentlocation-objectversion
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getObjectVersion() {
                return this.jsiiGet("objectVersion", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqlApplicationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-sqlapplicationconfiguration-inputs
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputs();

        /**
         * @return a {@link Builder} of {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link SqlApplicationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _inputs;

            /**
             * Sets the value of Inputs
             * @param value `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputs(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputs = value;
                return this;
            }
            /**
             * Sets the value of Inputs
             * @param value `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputs(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._inputs = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqlApplicationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public SqlApplicationConfigurationProperty build() {
                return new SqlApplicationConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputs = _inputs;

                    @Override
                    public java.lang.Object getInputs() {
                        return this.$inputs;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getInputs() != null) {
                            obj.set("inputs", om.valueToTree(this.getInputs()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.SqlApplicationConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationV2.SqlApplicationConfigurationProperty.Inputs`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-application-sqlapplicationconfiguration.html#cfn-kinesisanalyticsv2-application-sqlapplicationconfiguration-inputs
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputs() {
                return this.jsiiGet("inputs", java.lang.Object.class);
            }
        }
    }
}
