package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T13:00:58.644Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplicationReferenceDataSourceV2")
public class CfnApplicationReferenceDataSourceV2 extends software.amazon.awscdk.core.CfnResource {
    protected CfnApplicationReferenceDataSourceV2(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplicationReferenceDataSourceV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object getReferenceDataSource() {
        return this.jsiiGet("referenceDataSource", java.lang.Object.class);
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReferenceDataSource(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("referenceDataSource", java.util.Objects.requireNonNull(value, "referenceDataSource is required"));
    }

    /**
     * `AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource.ReferenceDataSource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-applicationreferencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReferenceDataSource(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty value) {
        this.jsiiSet("referenceDataSource", java.util.Objects.requireNonNull(value, "referenceDataSource is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordColumnDelimiter();
        /**
         * `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordRowDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordColumnDelimiter;
            private java.lang.String _recordRowDelimiter;

            /**
             * Sets the value of RecordColumnDelimiter
             * @param value `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumnDelimiter(final java.lang.String value) {
                this._recordColumnDelimiter = java.util.Objects.requireNonNull(value, "recordColumnDelimiter is required");
                return this;
            }
            /**
             * Sets the value of RecordRowDelimiter
             * @param value `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordRowDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordRowDelimiter(final java.lang.String value) {
                this._recordRowDelimiter = java.util.Objects.requireNonNull(value, "recordRowDelimiter is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CSVMappingParametersProperty build() {
                return new CSVMappingParametersProperty() {
                    private final java.lang.String $recordColumnDelimiter = java.util.Objects.requireNonNull(_recordColumnDelimiter, "recordColumnDelimiter is required");
                    private final java.lang.String $recordRowDelimiter = java.util.Objects.requireNonNull(_recordRowDelimiter, "recordRowDelimiter is required");

                    @Override
                    public java.lang.String getRecordColumnDelimiter() {
                        return this.$recordColumnDelimiter;
                    }

                    @Override
                    public java.lang.String getRecordRowDelimiter() {
                        return this.$recordRowDelimiter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                        obj.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordColumnDelimiter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordColumnDelimiter() {
                return this.jsiiGet("recordColumnDelimiter", java.lang.String.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty.RecordRowDelimiter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordRowDelimiter() {
                return this.jsiiGet("recordRowDelimiter", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty.RecordRowPath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters-recordrowpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordRowPath;

            /**
             * Sets the value of RecordRowPath
             * @param value `CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty.RecordRowPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordRowPath(final java.lang.String value) {
                this._recordRowPath = java.util.Objects.requireNonNull(value, "recordRowPath is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public JSONMappingParametersProperty build() {
                return new JSONMappingParametersProperty() {
                    private final java.lang.String $recordRowPath = java.util.Objects.requireNonNull(_recordRowPath, "recordRowPath is required");

                    @Override
                    public java.lang.String getRecordRowPath() {
                        return this.$recordRowPath;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty.RecordRowPath`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-jsonmappingparameters-recordrowpath
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordRowPath() {
                return this.jsiiGet("recordRowPath", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.CSVMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters-csvmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCsvMappingParameters();
        /**
         * `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.JSONMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters-jsonmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getJsonMappingParameters();

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _csvMappingParameters;
            @javax.annotation.Nullable
            private java.lang.Object _jsonMappingParameters;

            /**
             * Sets the value of CsvMappingParameters
             * @param value `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of CsvMappingParameters
             * @param value `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.CSVMappingParametersProperty value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._jsonMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.JSONMappingParametersProperty value) {
                this._jsonMappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public MappingParametersProperty build() {
                return new MappingParametersProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $csvMappingParameters = _csvMappingParameters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $jsonMappingParameters = _jsonMappingParameters;

                    @Override
                    public java.lang.Object getCsvMappingParameters() {
                        return this.$csvMappingParameters;
                    }

                    @Override
                    public java.lang.Object getJsonMappingParameters() {
                        return this.$jsonMappingParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCsvMappingParameters() != null) {
                            obj.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                        }
                        if (this.getJsonMappingParameters() != null) {
                            obj.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.MappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.CSVMappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters-csvmappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getCsvMappingParameters() {
                return this.jsiiGet("csvMappingParameters", java.lang.Object.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.MappingParametersProperty.JSONMappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-mappingparameters-jsonmappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getJsonMappingParameters() {
                return this.jsiiGet("jsonMappingParameters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getName();
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.SqlType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-sqltype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSqlType();
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Mapping`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-mapping
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getMapping();

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _sqlType;
            @javax.annotation.Nullable
            private java.lang.String _mapping;

            /**
             * Sets the value of Name
             * @param value `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of SqlType
             * @param value `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.SqlType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSqlType(final java.lang.String value) {
                this._sqlType = java.util.Objects.requireNonNull(value, "sqlType is required");
                return this;
            }
            /**
             * Sets the value of Mapping
             * @param value `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Mapping`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMapping(@javax.annotation.Nullable final java.lang.String value) {
                this._mapping = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RecordColumnProperty build() {
                return new RecordColumnProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private final java.lang.String $sqlType = java.util.Objects.requireNonNull(_sqlType, "sqlType is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $mapping = _mapping;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public java.lang.String getSqlType() {
                        return this.$sqlType;
                    }

                    @Override
                    public java.lang.String getMapping() {
                        return this.$mapping;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        obj.set("sqlType", om.valueToTree(this.getSqlType()));
                        if (this.getMapping() != null) {
                            obj.set("mapping", om.valueToTree(this.getMapping()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.RecordColumnProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-name
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.SqlType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-sqltype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getSqlType() {
                return this.jsiiGet("sqlType", java.lang.String.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.RecordColumnProperty.Mapping`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordcolumn-mapping
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getMapping() {
                return this.jsiiGet("mapping", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.RecordFormatType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordformat-recordformattype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordFormatType();
        /**
         * `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.MappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordformat-mappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getMappingParameters();

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordFormatType;
            @javax.annotation.Nullable
            private java.lang.Object _mappingParameters;

            /**
             * Sets the value of RecordFormatType
             * @param value `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.RecordFormatType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormatType(final java.lang.String value) {
                this._recordFormatType = java.util.Objects.requireNonNull(value, "recordFormatType is required");
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._mappingParameters = value;
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.MappingParametersProperty value) {
                this._mappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RecordFormatProperty build() {
                return new RecordFormatProperty() {
                    private final java.lang.String $recordFormatType = java.util.Objects.requireNonNull(_recordFormatType, "recordFormatType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $mappingParameters = _mappingParameters;

                    @Override
                    public java.lang.String getRecordFormatType() {
                        return this.$recordFormatType;
                    }

                    @Override
                    public java.lang.Object getMappingParameters() {
                        return this.$mappingParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                        if (this.getMappingParameters() != null) {
                            obj.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.RecordFormatProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.RecordFormatType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordformat-recordformattype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordFormatType() {
                return this.jsiiGet("recordFormatType", java.lang.String.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.RecordFormatProperty.MappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-recordformat.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-recordformat-mappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getMappingParameters() {
                return this.jsiiGet("mappingParameters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferenceDataSourceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.ReferenceSchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-referenceschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getReferenceSchema();
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.S3ReferenceDataSource`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-s3referencedatasource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getS3ReferenceDataSource();
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.TableName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-tablename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _referenceSchema;
            @javax.annotation.Nullable
            private java.lang.Object _s3ReferenceDataSource;
            @javax.annotation.Nullable
            private java.lang.String _tableName;

            /**
             * Sets the value of ReferenceSchema
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.ReferenceSchema`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReferenceSchema(final software.amazon.awscdk.core.IResolvable value) {
                this._referenceSchema = java.util.Objects.requireNonNull(value, "referenceSchema is required");
                return this;
            }
            /**
             * Sets the value of ReferenceSchema
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.ReferenceSchema`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withReferenceSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty value) {
                this._referenceSchema = java.util.Objects.requireNonNull(value, "referenceSchema is required");
                return this;
            }
            /**
             * Sets the value of S3ReferenceDataSource
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.S3ReferenceDataSource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withS3ReferenceDataSource(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._s3ReferenceDataSource = value;
                return this;
            }
            /**
             * Sets the value of S3ReferenceDataSource
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.S3ReferenceDataSource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withS3ReferenceDataSource(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty value) {
                this._s3ReferenceDataSource = value;
                return this;
            }
            /**
             * Sets the value of TableName
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.TableName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withTableName(@javax.annotation.Nullable final java.lang.String value) {
                this._tableName = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferenceDataSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ReferenceDataSourceProperty build() {
                return new ReferenceDataSourceProperty() {
                    private final java.lang.Object $referenceSchema = java.util.Objects.requireNonNull(_referenceSchema, "referenceSchema is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $s3ReferenceDataSource = _s3ReferenceDataSource;
                    @javax.annotation.Nullable
                    private final java.lang.String $tableName = _tableName;

                    @Override
                    public java.lang.Object getReferenceSchema() {
                        return this.$referenceSchema;
                    }

                    @Override
                    public java.lang.Object getS3ReferenceDataSource() {
                        return this.$s3ReferenceDataSource;
                    }

                    @Override
                    public java.lang.String getTableName() {
                        return this.$tableName;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("referenceSchema", om.valueToTree(this.getReferenceSchema()));
                        if (this.getS3ReferenceDataSource() != null) {
                            obj.set("s3ReferenceDataSource", om.valueToTree(this.getS3ReferenceDataSource()));
                        }
                        if (this.getTableName() != null) {
                            obj.set("tableName", om.valueToTree(this.getTableName()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.ReferenceSchema`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-referenceschema
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getReferenceSchema() {
                return this.jsiiGet("referenceSchema", java.lang.Object.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.S3ReferenceDataSource`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-s3referencedatasource
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getS3ReferenceDataSource() {
                return this.jsiiGet("s3ReferenceDataSource", java.lang.Object.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.ReferenceDataSourceProperty.TableName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referencedatasource-tablename
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getTableName() {
                return this.jsiiGet("tableName", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReferenceSchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordColumns`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordcolumns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRecordColumns();
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordFormat`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordformat
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRecordFormat();
        /**
         * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordEncoding`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordencoding
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordEncoding();

        /**
         * @return a {@link Builder} of {@link ReferenceSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ReferenceSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _recordColumns;
            private java.lang.Object _recordFormat;
            @javax.annotation.Nullable
            private java.lang.String _recordEncoding;

            /**
             * Sets the value of RecordColumns
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumns(final software.amazon.awscdk.core.IResolvable value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordColumns
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumns(final java.util.List<java.lang.Object> value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormat(final software.amazon.awscdk.core.IResolvable value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.RecordFormatProperty value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordEncoding
             * @param value `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordEncoding`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordEncoding(@javax.annotation.Nullable final java.lang.String value) {
                this._recordEncoding = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReferenceSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public ReferenceSchemaProperty build() {
                return new ReferenceSchemaProperty() {
                    private final java.lang.Object $recordColumns = java.util.Objects.requireNonNull(_recordColumns, "recordColumns is required");
                    private final java.lang.Object $recordFormat = java.util.Objects.requireNonNull(_recordFormat, "recordFormat is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $recordEncoding = _recordEncoding;

                    @Override
                    public java.lang.Object getRecordColumns() {
                        return this.$recordColumns;
                    }

                    @Override
                    public java.lang.Object getRecordFormat() {
                        return this.$recordFormat;
                    }

                    @Override
                    public java.lang.String getRecordEncoding() {
                        return this.$recordEncoding;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                        obj.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                        if (this.getRecordEncoding() != null) {
                            obj.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordColumns`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordcolumns
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRecordColumns() {
                return this.jsiiGet("recordColumns", java.lang.Object.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordFormat`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordformat
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRecordFormat() {
                return this.jsiiGet("recordFormat", java.lang.Object.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.ReferenceSchemaProperty.RecordEncoding`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-referenceschema-recordencoding
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getRecordEncoding() {
                return this.jsiiGet("recordEncoding", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ReferenceDataSourceProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.BucketARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource-bucketarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getBucketArn();
        /**
         * `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.FileKey`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource-filekey
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getFileKey();

        /**
         * @return a {@link Builder} of {@link S3ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link S3ReferenceDataSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _bucketArn;
            private java.lang.String _fileKey;

            /**
             * Sets the value of BucketArn
             * @param value `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.BucketARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withBucketArn(final java.lang.String value) {
                this._bucketArn = java.util.Objects.requireNonNull(value, "bucketArn is required");
                return this;
            }
            /**
             * Sets the value of FileKey
             * @param value `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.FileKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withFileKey(final java.lang.String value) {
                this._fileKey = java.util.Objects.requireNonNull(value, "fileKey is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ReferenceDataSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public S3ReferenceDataSourceProperty build() {
                return new S3ReferenceDataSourceProperty() {
                    private final java.lang.String $bucketArn = java.util.Objects.requireNonNull(_bucketArn, "bucketArn is required");
                    private final java.lang.String $fileKey = java.util.Objects.requireNonNull(_fileKey, "fileKey is required");

                    @Override
                    public java.lang.String getBucketArn() {
                        return this.$bucketArn;
                    }

                    @Override
                    public java.lang.String getFileKey() {
                        return this.$fileKey;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("bucketArn", om.valueToTree(this.getBucketArn()));
                        obj.set("fileKey", om.valueToTree(this.getFileKey()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.BucketARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource-bucketarn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getBucketArn() {
                return this.jsiiGet("bucketArn", java.lang.String.class);
            }

            /**
             * `CfnApplicationReferenceDataSourceV2.S3ReferenceDataSourceProperty.FileKey`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalyticsv2-applicationreferencedatasource-s3referencedatasource-filekey
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getFileKey() {
                return this.jsiiGet("fileKey", java.lang.String.class);
            }
        }
    }
}
