package software.amazon.awscdk.services.kinesisanalytics;

/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:06:47.308Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesisanalytics.$Module.class, fqn = "@aws-cdk/aws-kinesisanalytics.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.core.CfnResource {
    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisanalytics.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }
    /**
     * Create a new `AWS::KinesisAnalytics::Application`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.kinesisanalytics.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return this.jsiiGet("cfnProperties", java.util.Map.class);
    }

    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object getInputs() {
        return this.jsiiGet("inputs", java.lang.Object.class);
    }

    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputs(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("inputs", java.util.Objects.requireNonNull(value, "inputs is required"));
    }

    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputs(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("inputs", java.util.Objects.requireNonNull(value, "inputs is required"));
    }

    /**
     * `AWS::KinesisAnalytics::Application.ApplicationCode`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getApplicationCode() {
        return this.jsiiGet("applicationCode", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalytics::Application.ApplicationCode`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationCode(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("applicationCode", value);
    }

    /**
     * `AWS::KinesisAnalytics::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getApplicationDescription() {
        return this.jsiiGet("applicationDescription", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalytics::Application.ApplicationDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationDescription(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("applicationDescription", value);
    }

    /**
     * `AWS::KinesisAnalytics::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @javax.annotation.Nullable
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::KinesisAnalytics::Application.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationName(@javax.annotation.Nullable final java.lang.String value) {
        this.jsiiSet("applicationName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CSVMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordColumnDelimiter();
        /**
         * `CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordRowDelimiter();

        /**
         * @return a {@link Builder} of {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CSVMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordColumnDelimiter;
            private java.lang.String _recordRowDelimiter;

            /**
             * Sets the value of RecordColumnDelimiter
             * @param value `CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumnDelimiter(final java.lang.String value) {
                this._recordColumnDelimiter = java.util.Objects.requireNonNull(value, "recordColumnDelimiter is required");
                return this;
            }
            /**
             * Sets the value of RecordRowDelimiter
             * @param value `CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordRowDelimiter(final java.lang.String value) {
                this._recordRowDelimiter = java.util.Objects.requireNonNull(value, "recordRowDelimiter is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CSVMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public CSVMappingParametersProperty build() {
                return new CSVMappingParametersProperty() {
                    private final java.lang.String $recordColumnDelimiter = java.util.Objects.requireNonNull(_recordColumnDelimiter, "recordColumnDelimiter is required");
                    private final java.lang.String $recordRowDelimiter = java.util.Objects.requireNonNull(_recordRowDelimiter, "recordRowDelimiter is required");

                    @Override
                    public java.lang.String getRecordColumnDelimiter() {
                        return this.$recordColumnDelimiter;
                    }

                    @Override
                    public java.lang.String getRecordRowDelimiter() {
                        return this.$recordRowDelimiter;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordColumnDelimiter", om.valueToTree(this.getRecordColumnDelimiter()));
                        obj.set("recordRowDelimiter", om.valueToTree(this.getRecordRowDelimiter()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordColumnDelimiter() {
                return this.jsiiGet("recordColumnDelimiter", java.lang.String.class);
            }

            /**
             * `CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordRowDelimiter() {
                return this.jsiiGet("recordRowDelimiter", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputLambdaProcessorProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.InputLambdaProcessorProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceArn();
        /**
         * `CfnApplication.InputLambdaProcessorProperty.RoleARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputLambdaProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _resourceArn;
            private java.lang.String _roleArn;

            /**
             * Sets the value of ResourceArn
             * @param value `CfnApplication.InputLambdaProcessorProperty.ResourceARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value `CfnApplication.InputLambdaProcessorProperty.RoleARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoleArn(final java.lang.String value) {
                this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputLambdaProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputLambdaProcessorProperty build() {
                return new InputLambdaProcessorProperty() {
                    private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    private final java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                        obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.InputLambdaProcessorProperty.ResourceARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * `CfnApplication.InputLambdaProcessorProperty.RoleARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputParallelismProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.InputParallelismProperty.Count`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Number getCount();

        /**
         * @return a {@link Builder} of {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputParallelismProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Number _count;

            /**
             * Sets the value of Count
             * @param value `CfnApplication.InputParallelismProperty.Count`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCount(@javax.annotation.Nullable final java.lang.Number value) {
                this._count = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputParallelismProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputParallelismProperty build() {
                return new InputParallelismProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Number $count = _count;

                    @Override
                    public java.lang.Number getCount() {
                        return this.$count;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCount() != null) {
                            obj.set("count", om.valueToTree(this.getCount()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.InputParallelismProperty.Count`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Number getCount() {
                return this.jsiiGet("count", java.lang.Number.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputLambdaProcessor();

        /**
         * @return a {@link Builder} of {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _inputLambdaProcessor;

            /**
             * Sets the value of InputLambdaProcessor
             * @param value `CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputLambdaProcessor = value;
                return this;
            }
            /**
             * Sets the value of InputLambdaProcessor
             * @param value `CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputLambdaProcessor(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputLambdaProcessorProperty value) {
                this._inputLambdaProcessor = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputProcessingConfigurationProperty build() {
                return new InputProcessingConfigurationProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputLambdaProcessor = _inputLambdaProcessor;

                    @Override
                    public java.lang.Object getInputLambdaProcessor() {
                        return this.$inputLambdaProcessor;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getInputLambdaProcessor() != null) {
                            obj.set("inputLambdaProcessor", om.valueToTree(this.getInputLambdaProcessor()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputLambdaProcessor() {
                return this.jsiiGet("inputLambdaProcessor", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.InputProperty.InputSchema`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputSchema();
        /**
         * `CfnApplication.InputProperty.NamePrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getNamePrefix();
        /**
         * `CfnApplication.InputProperty.InputParallelism`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputParallelism();
        /**
         * `CfnApplication.InputProperty.InputProcessingConfiguration`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getInputProcessingConfiguration();
        /**
         * `CfnApplication.InputProperty.KinesisFirehoseInput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getKinesisFirehoseInput();
        /**
         * `CfnApplication.InputProperty.KinesisStreamsInput`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getKinesisStreamsInput();

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _inputSchema;
            private java.lang.String _namePrefix;
            @javax.annotation.Nullable
            private java.lang.Object _inputParallelism;
            @javax.annotation.Nullable
            private java.lang.Object _inputProcessingConfiguration;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisFirehoseInput;
            @javax.annotation.Nullable
            private java.lang.Object _kinesisStreamsInput;

            /**
             * Sets the value of InputSchema
             * @param value `CfnApplication.InputProperty.InputSchema`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputSchema(final software.amazon.awscdk.core.IResolvable value) {
                this._inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                return this;
            }
            /**
             * Sets the value of InputSchema
             * @param value `CfnApplication.InputProperty.InputSchema`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputSchema(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty value) {
                this._inputSchema = java.util.Objects.requireNonNull(value, "inputSchema is required");
                return this;
            }
            /**
             * Sets the value of NamePrefix
             * @param value `CfnApplication.InputProperty.NamePrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withNamePrefix(final java.lang.String value) {
                this._namePrefix = java.util.Objects.requireNonNull(value, "namePrefix is required");
                return this;
            }
            /**
             * Sets the value of InputParallelism
             * @param value `CfnApplication.InputProperty.InputParallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputParallelism = value;
                return this;
            }
            /**
             * Sets the value of InputParallelism
             * @param value `CfnApplication.InputProperty.InputParallelism`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputParallelism(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputParallelismProperty value) {
                this._inputParallelism = value;
                return this;
            }
            /**
             * Sets the value of InputProcessingConfiguration
             * @param value `CfnApplication.InputProperty.InputProcessingConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._inputProcessingConfiguration = value;
                return this;
            }
            /**
             * Sets the value of InputProcessingConfiguration
             * @param value `CfnApplication.InputProperty.InputProcessingConfiguration`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withInputProcessingConfiguration(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProcessingConfigurationProperty value) {
                this._inputProcessingConfiguration = value;
                return this;
            }
            /**
             * Sets the value of KinesisFirehoseInput
             * @param value `CfnApplication.InputProperty.KinesisFirehoseInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kinesisFirehoseInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisFirehoseInput
             * @param value `CfnApplication.InputProperty.KinesisFirehoseInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisFirehoseInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty value) {
                this._kinesisFirehoseInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamsInput
             * @param value `CfnApplication.InputProperty.KinesisStreamsInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._kinesisStreamsInput = value;
                return this;
            }
            /**
             * Sets the value of KinesisStreamsInput
             * @param value `CfnApplication.InputProperty.KinesisStreamsInput`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKinesisStreamsInput(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty value) {
                this._kinesisStreamsInput = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputProperty build() {
                return new InputProperty() {
                    private final java.lang.Object $inputSchema = java.util.Objects.requireNonNull(_inputSchema, "inputSchema is required");
                    private final java.lang.String $namePrefix = java.util.Objects.requireNonNull(_namePrefix, "namePrefix is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputParallelism = _inputParallelism;
                    @javax.annotation.Nullable
                    private final java.lang.Object $inputProcessingConfiguration = _inputProcessingConfiguration;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisFirehoseInput = _kinesisFirehoseInput;
                    @javax.annotation.Nullable
                    private final java.lang.Object $kinesisStreamsInput = _kinesisStreamsInput;

                    @Override
                    public java.lang.Object getInputSchema() {
                        return this.$inputSchema;
                    }

                    @Override
                    public java.lang.String getNamePrefix() {
                        return this.$namePrefix;
                    }

                    @Override
                    public java.lang.Object getInputParallelism() {
                        return this.$inputParallelism;
                    }

                    @Override
                    public java.lang.Object getInputProcessingConfiguration() {
                        return this.$inputProcessingConfiguration;
                    }

                    @Override
                    public java.lang.Object getKinesisFirehoseInput() {
                        return this.$kinesisFirehoseInput;
                    }

                    @Override
                    public java.lang.Object getKinesisStreamsInput() {
                        return this.$kinesisStreamsInput;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("inputSchema", om.valueToTree(this.getInputSchema()));
                        obj.set("namePrefix", om.valueToTree(this.getNamePrefix()));
                        if (this.getInputParallelism() != null) {
                            obj.set("inputParallelism", om.valueToTree(this.getInputParallelism()));
                        }
                        if (this.getInputProcessingConfiguration() != null) {
                            obj.set("inputProcessingConfiguration", om.valueToTree(this.getInputProcessingConfiguration()));
                        }
                        if (this.getKinesisFirehoseInput() != null) {
                            obj.set("kinesisFirehoseInput", om.valueToTree(this.getKinesisFirehoseInput()));
                        }
                        if (this.getKinesisStreamsInput() != null) {
                            obj.set("kinesisStreamsInput", om.valueToTree(this.getKinesisStreamsInput()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.InputProperty.InputSchema`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getInputSchema() {
                return this.jsiiGet("inputSchema", java.lang.Object.class);
            }

            /**
             * `CfnApplication.InputProperty.NamePrefix`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getNamePrefix() {
                return this.jsiiGet("namePrefix", java.lang.String.class);
            }

            /**
             * `CfnApplication.InputProperty.InputParallelism`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputParallelism() {
                return this.jsiiGet("inputParallelism", java.lang.Object.class);
            }

            /**
             * `CfnApplication.InputProperty.InputProcessingConfiguration`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getInputProcessingConfiguration() {
                return this.jsiiGet("inputProcessingConfiguration", java.lang.Object.class);
            }

            /**
             * `CfnApplication.InputProperty.KinesisFirehoseInput`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getKinesisFirehoseInput() {
                return this.jsiiGet("kinesisFirehoseInput", java.lang.Object.class);
            }

            /**
             * `CfnApplication.InputProperty.KinesisStreamsInput`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getKinesisStreamsInput() {
                return this.jsiiGet("kinesisStreamsInput", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputSchemaProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.InputSchemaProperty.RecordColumns`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRecordColumns();
        /**
         * `CfnApplication.InputSchemaProperty.RecordFormat`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getRecordFormat();
        /**
         * `CfnApplication.InputSchemaProperty.RecordEncoding`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordEncoding();

        /**
         * @return a {@link Builder} of {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link InputSchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.Object _recordColumns;
            private java.lang.Object _recordFormat;
            @javax.annotation.Nullable
            private java.lang.String _recordEncoding;

            /**
             * Sets the value of RecordColumns
             * @param value `CfnApplication.InputSchemaProperty.RecordColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumns(final software.amazon.awscdk.core.IResolvable value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordColumns
             * @param value `CfnApplication.InputSchemaProperty.RecordColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordColumns(final java.util.List<java.lang.Object> value) {
                this._recordColumns = java.util.Objects.requireNonNull(value, "recordColumns is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value `CfnApplication.InputSchemaProperty.RecordFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormat(final software.amazon.awscdk.core.IResolvable value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordFormat
             * @param value `CfnApplication.InputSchemaProperty.RecordFormat`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormat(final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty value) {
                this._recordFormat = java.util.Objects.requireNonNull(value, "recordFormat is required");
                return this;
            }
            /**
             * Sets the value of RecordEncoding
             * @param value `CfnApplication.InputSchemaProperty.RecordEncoding`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordEncoding(@javax.annotation.Nullable final java.lang.String value) {
                this._recordEncoding = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputSchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public InputSchemaProperty build() {
                return new InputSchemaProperty() {
                    private final java.lang.Object $recordColumns = java.util.Objects.requireNonNull(_recordColumns, "recordColumns is required");
                    private final java.lang.Object $recordFormat = java.util.Objects.requireNonNull(_recordFormat, "recordFormat is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $recordEncoding = _recordEncoding;

                    @Override
                    public java.lang.Object getRecordColumns() {
                        return this.$recordColumns;
                    }

                    @Override
                    public java.lang.Object getRecordFormat() {
                        return this.$recordFormat;
                    }

                    @Override
                    public java.lang.String getRecordEncoding() {
                        return this.$recordEncoding;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordColumns", om.valueToTree(this.getRecordColumns()));
                        obj.set("recordFormat", om.valueToTree(this.getRecordFormat()));
                        if (this.getRecordEncoding() != null) {
                            obj.set("recordEncoding", om.valueToTree(this.getRecordEncoding()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.InputSchemaProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.InputSchemaProperty.RecordColumns`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRecordColumns() {
                return this.jsiiGet("recordColumns", java.lang.Object.class);
            }

            /**
             * `CfnApplication.InputSchemaProperty.RecordFormat`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.Object getRecordFormat() {
                return this.jsiiGet("recordFormat", java.lang.Object.class);
            }

            /**
             * `CfnApplication.InputSchemaProperty.RecordEncoding`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getRecordEncoding() {
                return this.jsiiGet("recordEncoding", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JSONMappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.JSONMappingParametersProperty.RecordRowPath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordRowPath();

        /**
         * @return a {@link Builder} of {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link JSONMappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordRowPath;

            /**
             * Sets the value of RecordRowPath
             * @param value `CfnApplication.JSONMappingParametersProperty.RecordRowPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordRowPath(final java.lang.String value) {
                this._recordRowPath = java.util.Objects.requireNonNull(value, "recordRowPath is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JSONMappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public JSONMappingParametersProperty build() {
                return new JSONMappingParametersProperty() {
                    private final java.lang.String $recordRowPath = java.util.Objects.requireNonNull(_recordRowPath, "recordRowPath is required");

                    @Override
                    public java.lang.String getRecordRowPath() {
                        return this.$recordRowPath;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordRowPath", om.valueToTree(this.getRecordRowPath()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.JSONMappingParametersProperty.RecordRowPath`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordRowPath() {
                return this.jsiiGet("recordRowPath", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseInputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.KinesisFirehoseInputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceArn();
        /**
         * `CfnApplication.KinesisFirehoseInputProperty.RoleARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisFirehoseInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _resourceArn;
            private java.lang.String _roleArn;

            /**
             * Sets the value of ResourceArn
             * @param value `CfnApplication.KinesisFirehoseInputProperty.ResourceARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value `CfnApplication.KinesisFirehoseInputProperty.RoleARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoleArn(final java.lang.String value) {
                this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public KinesisFirehoseInputProperty build() {
                return new KinesisFirehoseInputProperty() {
                    private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    private final java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                        obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisFirehoseInputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.KinesisFirehoseInputProperty.ResourceARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * `CfnApplication.KinesisFirehoseInputProperty.RoleARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamsInputProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.KinesisStreamsInputProperty.ResourceARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getResourceArn();
        /**
         * `CfnApplication.KinesisStreamsInputProperty.RoleARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link KinesisStreamsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _resourceArn;
            private java.lang.String _roleArn;

            /**
             * Sets the value of ResourceArn
             * @param value `CfnApplication.KinesisStreamsInputProperty.ResourceARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withResourceArn(final java.lang.String value) {
                this._resourceArn = java.util.Objects.requireNonNull(value, "resourceArn is required");
                return this;
            }
            /**
             * Sets the value of RoleArn
             * @param value `CfnApplication.KinesisStreamsInputProperty.RoleARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRoleArn(final java.lang.String value) {
                this._roleArn = java.util.Objects.requireNonNull(value, "roleArn is required");
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public KinesisStreamsInputProperty build() {
                return new KinesisStreamsInputProperty() {
                    private final java.lang.String $resourceArn = java.util.Objects.requireNonNull(_resourceArn, "resourceArn is required");
                    private final java.lang.String $roleArn = java.util.Objects.requireNonNull(_roleArn, "roleArn is required");

                    @Override
                    public java.lang.String getResourceArn() {
                        return this.$resourceArn;
                    }

                    @Override
                    public java.lang.String getRoleArn() {
                        return this.$roleArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("resourceArn", om.valueToTree(this.getResourceArn()));
                        obj.set("roleArn", om.valueToTree(this.getRoleArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.KinesisStreamsInputProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.KinesisStreamsInputProperty.ResourceARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getResourceArn() {
                return this.jsiiGet("resourceArn", java.lang.String.class);
            }

            /**
             * `CfnApplication.KinesisStreamsInputProperty.RoleARN`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRoleArn() {
                return this.jsiiGet("roleArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingParametersProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.MappingParametersProperty.CSVMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getCsvMappingParameters();
        /**
         * `CfnApplication.MappingParametersProperty.JSONMappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getJsonMappingParameters();

        /**
         * @return a {@link Builder} of {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MappingParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _csvMappingParameters;
            @javax.annotation.Nullable
            private java.lang.Object _jsonMappingParameters;

            /**
             * Sets the value of CsvMappingParameters
             * @param value `CfnApplication.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of CsvMappingParameters
             * @param value `CfnApplication.MappingParametersProperty.CSVMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withCsvMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.CSVMappingParametersProperty value) {
                this._csvMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value `CfnApplication.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._jsonMappingParameters = value;
                return this;
            }
            /**
             * Sets the value of JsonMappingParameters
             * @param value `CfnApplication.MappingParametersProperty.JSONMappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withJsonMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.JSONMappingParametersProperty value) {
                this._jsonMappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public MappingParametersProperty build() {
                return new MappingParametersProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.Object $csvMappingParameters = _csvMappingParameters;
                    @javax.annotation.Nullable
                    private final java.lang.Object $jsonMappingParameters = _jsonMappingParameters;

                    @Override
                    public java.lang.Object getCsvMappingParameters() {
                        return this.$csvMappingParameters;
                    }

                    @Override
                    public java.lang.Object getJsonMappingParameters() {
                        return this.$jsonMappingParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        if (this.getCsvMappingParameters() != null) {
                            obj.set("csvMappingParameters", om.valueToTree(this.getCsvMappingParameters()));
                        }
                        if (this.getJsonMappingParameters() != null) {
                            obj.set("jsonMappingParameters", om.valueToTree(this.getJsonMappingParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.MappingParametersProperty.CSVMappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getCsvMappingParameters() {
                return this.jsiiGet("csvMappingParameters", java.lang.Object.class);
            }

            /**
             * `CfnApplication.MappingParametersProperty.JSONMappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getJsonMappingParameters() {
                return this.jsiiGet("jsonMappingParameters", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordColumnProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.RecordColumnProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getName();
        /**
         * `CfnApplication.RecordColumnProperty.SqlType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getSqlType();
        /**
         * `CfnApplication.RecordColumnProperty.Mapping`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getMapping();

        /**
         * @return a {@link Builder} of {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _name;
            private java.lang.String _sqlType;
            @javax.annotation.Nullable
            private java.lang.String _mapping;

            /**
             * Sets the value of Name
             * @param value `CfnApplication.RecordColumnProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withName(final java.lang.String value) {
                this._name = java.util.Objects.requireNonNull(value, "name is required");
                return this;
            }
            /**
             * Sets the value of SqlType
             * @param value `CfnApplication.RecordColumnProperty.SqlType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withSqlType(final java.lang.String value) {
                this._sqlType = java.util.Objects.requireNonNull(value, "sqlType is required");
                return this;
            }
            /**
             * Sets the value of Mapping
             * @param value `CfnApplication.RecordColumnProperty.Mapping`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMapping(@javax.annotation.Nullable final java.lang.String value) {
                this._mapping = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RecordColumnProperty build() {
                return new RecordColumnProperty() {
                    private final java.lang.String $name = java.util.Objects.requireNonNull(_name, "name is required");
                    private final java.lang.String $sqlType = java.util.Objects.requireNonNull(_sqlType, "sqlType is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $mapping = _mapping;

                    @Override
                    public java.lang.String getName() {
                        return this.$name;
                    }

                    @Override
                    public java.lang.String getSqlType() {
                        return this.$sqlType;
                    }

                    @Override
                    public java.lang.String getMapping() {
                        return this.$mapping;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("name", om.valueToTree(this.getName()));
                        obj.set("sqlType", om.valueToTree(this.getSqlType()));
                        if (this.getMapping() != null) {
                            obj.set("mapping", om.valueToTree(this.getMapping()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordColumnProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.RecordColumnProperty.Name`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getName() {
                return this.jsiiGet("name", java.lang.String.class);
            }

            /**
             * `CfnApplication.RecordColumnProperty.SqlType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getSqlType() {
                return this.jsiiGet("sqlType", java.lang.String.class);
            }

            /**
             * `CfnApplication.RecordColumnProperty.Mapping`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.String getMapping() {
                return this.jsiiGet("mapping", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecordFormatProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnApplication.RecordFormatProperty.RecordFormatType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.String getRecordFormatType();
        /**
         * `CfnApplication.RecordFormatProperty.MappingParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        java.lang.Object getMappingParameters();

        /**
         * @return a {@link Builder} of {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RecordFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Builder {
            private java.lang.String _recordFormatType;
            @javax.annotation.Nullable
            private java.lang.Object _mappingParameters;

            /**
             * Sets the value of RecordFormatType
             * @param value `CfnApplication.RecordFormatProperty.RecordFormatType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withRecordFormatType(final java.lang.String value) {
                this._recordFormatType = java.util.Objects.requireNonNull(value, "recordFormatType is required");
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value `CfnApplication.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.core.IResolvable value) {
                this._mappingParameters = value;
                return this;
            }
            /**
             * Sets the value of MappingParameters
             * @param value `CfnApplication.RecordFormatProperty.MappingParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withMappingParameters(@javax.annotation.Nullable final software.amazon.awscdk.services.kinesisanalytics.CfnApplication.MappingParametersProperty value) {
                this._mappingParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecordFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public RecordFormatProperty build() {
                return new RecordFormatProperty() {
                    private final java.lang.String $recordFormatType = java.util.Objects.requireNonNull(_recordFormatType, "recordFormatType is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $mappingParameters = _mappingParameters;

                    @Override
                    public java.lang.String getRecordFormatType() {
                        return this.$recordFormatType;
                    }

                    @Override
                    public java.lang.Object getMappingParameters() {
                        return this.$mappingParameters;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("recordFormatType", om.valueToTree(this.getRecordFormatType()));
                        if (this.getMappingParameters() != null) {
                            obj.set("mappingParameters", om.valueToTree(this.getMappingParameters()));
                        }
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisanalytics.CfnApplication.RecordFormatProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnApplication.RecordFormatProperty.RecordFormatType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public java.lang.String getRecordFormatType() {
                return this.jsiiGet("recordFormatType", java.lang.String.class);
            }

            /**
             * `CfnApplication.RecordFormatProperty.MappingParameters`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
             */
            @Override
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @javax.annotation.Nullable
            public java.lang.Object getMappingParameters() {
                return this.jsiiGet("mappingParameters", java.lang.Object.class);
            }
        }
    }
}
