/**
 * <h1>Actions for AWS::IoTEvents Detector Model</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library contains integration classes to specify actions of state events of Detector Model in <code>&#64;aws-cdk/aws-iotevents-alpha</code>.
 * Instances of these classes should be passed to <code>State</code> defined in <code>&#64;aws-cdk/aws-iotevents-alpha</code>
 * You can define built-in actions to use a timer or set a variable, or send data to other AWS resources.
 * <p>
 * This library contains integration classes to use a timer or set a variable, or send data to other AWS resources.
 * AWS IoT Events can trigger actions when it detects a specified event or transition event.
 * <p>
 * Currently supported are:
 * <p>
 * <ul>
 * <li>Use timer</li>
 * <li>Set variable to detector instance</li>
 * <li>Invoke a Lambda function</li>
 * </ul>
 * <p>
 * <h2>Use timer</h2>
 * <p>
 * The code snippet below creates an Action that creates the timer with duration in seconds.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.iotevents.alpha.*;
 * import software.amazon.awscdk.services.iotevents.actions.alpha.*;
 * 
 * IInput input;
 * 
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(
 *                     new SetTimerAction("MyTimer", Map.of(
 *                             "duration", cdk.Duration.seconds(60)))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Setting duration by <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">IoT Events Expression</a>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * SetTimerAction.Builder.create("MyTimer")
 *         .durationExpression(iotevents.Expression.inputAttribute(input, "payload.durationSeconds"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * And the timer can be reset and cleared. Below is an example of general
 * <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-examples-dhb.html">Device HeartBeat</a>
 * Detector Model:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Object online = State.Builder.create()
 *         .stateName("Online")
 *         .onEnter(List.of(Map.of(
 *                 "eventName", "enter-event",
 *                 "condition", iotevents.Expression.currentInput(input),
 *                 "actions", List.of(
 *                     SetTimerAction.Builder.create("MyTimer")
 *                             .duration(cdk.Duration.seconds(60))
 *                             .build()))))
 *         .onInput(List.of(Map.of(
 *                 "eventName", "input-event",
 *                 "condition", iotevents.Expression.currentInput(input),
 *                 "actions", List.of(
 *                     new ResetTimerAction("MyTimer")))))
 *         .onExit(List.of(Map.of(
 *                 "eventName", "exit-event",
 *                 "actions", List.of(
 *                     new ClearTimerAction("MyTimer")))))
 *         .build();
 * Object offline = State.Builder.create().stateName("Offline").build();
 * 
 * online.transitionTo(offline, Map.of("when", iotevents.Expression.timeout("MyTimer")));
 * offline.transitionTo(online, Map.of("when", iotevents.Expression.currentInput(input)));
 * </pre></blockquote>
 * <p>
 * <h2>Set variable to detector instance</h2>
 * <p>
 * The code snippet below creates an Action that set variable to detector instance
 * when it is triggered.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iotevents.alpha.*;
 * import software.amazon.awscdk.services.iotevents.actions.alpha.*;
 * 
 * IInput input;
 * 
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(
 *                     new SetVariableAction("MyVariable", Expression.inputAttribute(input, "payload.temperature"))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Invoke a Lambda function</h2>
 * <p>
 * The code snippet below creates an Action that invoke a Lambda function
 * when it is triggered.
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iotevents.alpha.*;
 * import software.amazon.awscdk.services.iotevents.actions.alpha.*;
 * import software.amazon.awscdk.services.lambda.*;
 * 
 * IInput input;
 * IFunction func;
 * 
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.iotevents.actions.alpha;
