package software.amazon.awscdk.services.iotevents.actions.alpha;

/**
 * (experimental) The duration of the timer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.iotevents.alpha.*;
 * import software.amazon.awscdk.services.iotevents.actions.alpha.*;
 * IInput input;
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(
 *                     new SetTimerAction("MyTimer", Map.of(
 *                             "duration", cdk.Duration.seconds(60)))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.97.0 (build 729de35)", date = "2024-04-24T21:00:39.611Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iotevents.actions.alpha.$Module.class, fqn = "@aws-cdk/aws-iotevents-actions-alpha.TimerDuration")
public abstract class TimerDuration extends software.amazon.jsii.JsiiObject {

    protected TimerDuration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TimerDuration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected TimerDuration() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Create a timer-duration from Duration.
     * <p>
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration fromDuration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration.class, "fromDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * (experimental) Create a timer-duration from Expression.
     * <p>
     * You can use a string expression that includes numbers, variables ($variable.<variable-name>),
     * and input values ($input.<input-name>.<path-to-datum>) as the duration.
     * <p>
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     * <p>
     * @param expression This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration fromExpression(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.alpha.Expression expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration.class, "fromExpression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.iotevents.actions.alpha.TimerDuration {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
