/**
 * <h2>Amazon Elastic Load Balancing Construct Library</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge" alt="Stability: Stable" /></p>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>The <code>@aws-cdk/aws-elasticloadbalancing</code> package provides constructs for configuring
 * classic load balancers.</p>
 * <h3>Configuring a Load Balancer</h3>
 * <p>Load balancers send traffic to one or more AutoScalingGroups. Create a load
 * balancer, set up listeners and a health check, and supply the fleet(s) you want
 * to load balance to in the <code>targets</code> property.</p>
 * <pre><code class="language-ts">const lb = new elb.LoadBalancer(this, 'LB', {
 *     vpc,
 *     internetFacing: true,
 *     healthCheck: {
 *         port: 80
 *     },
 * });
 * 
 * lb.addTarget(myAutoScalingGroup);
 * lb.addListener({
 *     externalPort: 80,
 * });
 * </code></pre>
 * <p>The load balancer allows all connections by default. If you want to change that,
 * pass the <code>allowConnectionsFrom</code> property while setting up the listener:</p>
 * <pre><code class="language-ts">lb.addListener({
 *     externalPort: 80,
 *     allowConnectionsFrom: [mySecurityGroup]
 * });
 * </code></pre>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.elasticloadbalancing;
