package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Construction properties for a LoadBalancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.LoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC network of the fleet instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Whether cross zone load balancing is enabled.
     * 
     * This controls whether the load balancer evenly distributes requests
     * across each availability zone
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getCrossZone() {
        return null;
    }

    /**
     * Health check settings for the load balancing targets.
     * 
     * Not required but recommended.
     * 
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancing.HealthCheck getHealthCheck() {
        return null;
    }

    /**
     * Whether this is an internet-facing Load Balancer.
     * 
     * This controls whether the LB has a public IP address assigned. It does
     * not open up the Load Balancer's security groups to public internet access.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getInternetFacing() {
        return null;
    }

    /**
     * What listeners to set up for the load balancer.
     * 
     * Can also be added by .addListener()
     * 
     * Default: -
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> getListeners() {
        return null;
    }

    /**
     * Which subnets to deploy the load balancer.
     * 
     * Can be used to define a specific set of subnets to deploy the load balancer to.
     * Useful multiple public or private subnets are covering the same availability zone.
     * 
     * Default: - Public subnets if internetFacing, Private subnets otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * What targets to load balance to.
     * 
     * Can also be added by .addTarget()
     * 
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> getTargets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.lang.Boolean crossZone;
        private software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck;
        private java.lang.Boolean internetFacing;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets;

        /**
         * Sets the value of Vpc
         * @param vpc VPC network of the fleet instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of CrossZone
         * @param crossZone Whether cross zone load balancing is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(java.lang.Boolean crossZone) {
            this.crossZone = crossZone;
            return this;
        }

        /**
         * Sets the value of HealthCheck
         * @param healthCheck Health check settings for the load balancing targets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of InternetFacing
         * @param internetFacing Whether this is an internet-facing Load Balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetFacing(java.lang.Boolean internetFacing) {
            this.internetFacing = internetFacing;
            return this;
        }

        /**
         * Sets the value of Listeners
         * @param listeners What listeners to set up for the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        /**
         * Sets the value of SubnetSelection
         * @param subnetSelection Which subnets to deploy the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of Targets
         * @param targets What targets to load balance to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LoadBalancerProps build() {
            return new Jsii$Proxy(vpc, crossZone, healthCheck, internetFacing, listeners, subnetSelection, targets);
        }
    }

    /**
     * An implementation for {@link LoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean crossZone;
        private final software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck;
        private final java.lang.Boolean internetFacing;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
            this.crossZone = this.jsiiGet("crossZone", java.lang.Boolean.class);
            this.healthCheck = this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancing.HealthCheck.class);
            this.internetFacing = this.jsiiGet("internetFacing", java.lang.Boolean.class);
            this.listeners = this.jsiiGet("listeners", java.util.List.class);
            this.subnetSelection = this.jsiiGet("subnetSelection", software.amazon.awscdk.services.ec2.SubnetSelection.class);
            this.targets = this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ec2.IVpc vpc, final java.lang.Boolean crossZone, final software.amazon.awscdk.services.elasticloadbalancing.HealthCheck healthCheck, final java.lang.Boolean internetFacing, final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> listeners, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> targets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(vpc, "vpc is required");
            this.crossZone = crossZone;
            this.healthCheck = healthCheck;
            this.internetFacing = internetFacing;
            this.listeners = listeners;
            this.subnetSelection = subnetSelection;
            this.targets = targets;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public java.lang.Boolean getCrossZone() {
            return this.crossZone;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancing.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public java.lang.Boolean getInternetFacing() {
            return this.internetFacing;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener> getListeners() {
            return this.listeners;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget> getTargets() {
            return this.targets;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getCrossZone() != null) {
                data.set("crossZone", om.valueToTree(this.getCrossZone()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getInternetFacing() != null) {
                data.set("internetFacing", om.valueToTree(this.getInternetFacing()));
            }
            if (this.getListeners() != null) {
                data.set("listeners", om.valueToTree(this.getListeners()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.LoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerProps.Jsii$Proxy that = (LoadBalancerProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.crossZone != null ? !this.crossZone.equals(that.crossZone) : that.crossZone != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.internetFacing != null ? !this.internetFacing.equals(that.internetFacing) : that.internetFacing != null) return false;
            if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
        }

        @Override
        public int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.crossZone != null ? this.crossZone.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.internetFacing != null ? this.internetFacing.hashCode() : 0);
            result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            return result;
        }
    }
}
