package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Add a backend to the load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.LoadBalancerListener")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerListener.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerListener extends software.amazon.jsii.JsiiSerializable {

    /**
     * External listening port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getExternalPort();

    /**
     * Allow connections to the load balancer from the given set of connection peers.
     * 
     * By default, connections will be allowed from anywhere. Set this to an empty list
     * to deny connections, or supply a custom list of peers to allow connections from
     * (IP ranges or security groups).
     * 
     * Default: Anywhere
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
        return null;
    }

    /**
     * What public protocol to use for load balancing.
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the external port is either 80 or 443.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getExternalProtocol() {
        return null;
    }

    /**
     * Instance listening port.
     * 
     * Same as the externalPort if not specified.
     * 
     * Default: externalPort
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getInternalPort() {
        return null;
    }

    /**
     * What public protocol to use for load balancing.
     * 
     * Either 'tcp', 'ssl', 'http' or 'https'.
     * 
     * May be omitted if the internal port is either 80 or 443.
     * 
     * The instance protocol is 'tcp' if the front-end protocol
     * is 'tcp' or 'ssl', the instance protocol is 'http' if the
     * front-end protocol is 'https'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getInternalProtocol() {
        return null;
    }

    /**
     * SSL policy names.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<java.lang.String> getPolicyNames() {
        return null;
    }

    /**
     * ID of SSL certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getSslCertificateId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerListener}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerListener}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number externalPort;
        private java.util.List<software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom;
        private software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol;
        private java.lang.Number internalPort;
        private software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol;
        private java.util.List<java.lang.String> policyNames;
        private java.lang.String sslCertificateId;

        /**
         * Sets the value of ExternalPort
         * @param externalPort External listening port. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalPort(java.lang.Number externalPort) {
            this.externalPort = externalPort;
            return this;
        }

        /**
         * Sets the value of AllowConnectionsFrom
         * @param allowConnectionsFrom Allow connections to the load balancer from the given set of connection peers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowConnectionsFrom(java.util.List<software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom) {
            this.allowConnectionsFrom = allowConnectionsFrom;
            return this;
        }

        /**
         * Sets the value of ExternalProtocol
         * @param externalProtocol What public protocol to use for load balancing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalProtocol(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol) {
            this.externalProtocol = externalProtocol;
            return this;
        }

        /**
         * Sets the value of InternalPort
         * @param internalPort Instance listening port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internalPort(java.lang.Number internalPort) {
            this.internalPort = internalPort;
            return this;
        }

        /**
         * Sets the value of InternalProtocol
         * @param internalProtocol What public protocol to use for load balancing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internalProtocol(software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol) {
            this.internalProtocol = internalProtocol;
            return this;
        }

        /**
         * Sets the value of PolicyNames
         * @param policyNames SSL policy names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyNames(java.util.List<java.lang.String> policyNames) {
            this.policyNames = policyNames;
            return this;
        }

        /**
         * Sets the value of SslCertificateId
         * @param sslCertificateId ID of SSL certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslCertificateId(java.lang.String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerListener}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public LoadBalancerListener build() {
            return new Jsii$Proxy(externalPort, allowConnectionsFrom, externalProtocol, internalPort, internalProtocol, policyNames, sslCertificateId);
        }
    }

    /**
     * An implementation for {@link LoadBalancerListener}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerListener {
        private final java.lang.Number externalPort;
        private final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom;
        private final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol;
        private final java.lang.Number internalPort;
        private final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol;
        private final java.util.List<java.lang.String> policyNames;
        private final java.lang.String sslCertificateId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.externalPort = this.jsiiGet("externalPort", java.lang.Number.class);
            this.allowConnectionsFrom = this.jsiiGet("allowConnectionsFrom", java.util.List.class);
            this.externalProtocol = this.jsiiGet("externalProtocol", software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol.class);
            this.internalPort = this.jsiiGet("internalPort", java.lang.Number.class);
            this.internalProtocol = this.jsiiGet("internalProtocol", software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol.class);
            this.policyNames = this.jsiiGet("policyNames", java.util.List.class);
            this.sslCertificateId = this.jsiiGet("sslCertificateId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number externalPort, final java.util.List<software.amazon.awscdk.services.ec2.IConnectable> allowConnectionsFrom, final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol externalProtocol, final java.lang.Number internalPort, final software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol internalProtocol, final java.util.List<java.lang.String> policyNames, final java.lang.String sslCertificateId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.externalPort = java.util.Objects.requireNonNull(externalPort, "externalPort is required");
            this.allowConnectionsFrom = allowConnectionsFrom;
            this.externalProtocol = externalProtocol;
            this.internalPort = internalPort;
            this.internalProtocol = internalProtocol;
            this.policyNames = policyNames;
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public java.lang.Number getExternalPort() {
            return this.externalPort;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.ec2.IConnectable> getAllowConnectionsFrom() {
            return this.allowConnectionsFrom;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getExternalProtocol() {
            return this.externalProtocol;
        }

        @Override
        public java.lang.Number getInternalPort() {
            return this.internalPort;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancing.LoadBalancingProtocol getInternalProtocol() {
            return this.internalProtocol;
        }

        @Override
        public java.util.List<java.lang.String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public java.lang.String getSslCertificateId() {
            return this.sslCertificateId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("externalPort", om.valueToTree(this.getExternalPort()));
            if (this.getAllowConnectionsFrom() != null) {
                data.set("allowConnectionsFrom", om.valueToTree(this.getAllowConnectionsFrom()));
            }
            if (this.getExternalProtocol() != null) {
                data.set("externalProtocol", om.valueToTree(this.getExternalProtocol()));
            }
            if (this.getInternalPort() != null) {
                data.set("internalPort", om.valueToTree(this.getInternalPort()));
            }
            if (this.getInternalProtocol() != null) {
                data.set("internalProtocol", om.valueToTree(this.getInternalProtocol()));
            }
            if (this.getPolicyNames() != null) {
                data.set("policyNames", om.valueToTree(this.getPolicyNames()));
            }
            if (this.getSslCertificateId() != null) {
                data.set("sslCertificateId", om.valueToTree(this.getSslCertificateId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.LoadBalancerListener"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerListener.Jsii$Proxy that = (LoadBalancerListener.Jsii$Proxy) o;

            if (!externalPort.equals(that.externalPort)) return false;
            if (this.allowConnectionsFrom != null ? !this.allowConnectionsFrom.equals(that.allowConnectionsFrom) : that.allowConnectionsFrom != null) return false;
            if (this.externalProtocol != null ? !this.externalProtocol.equals(that.externalProtocol) : that.externalProtocol != null) return false;
            if (this.internalPort != null ? !this.internalPort.equals(that.internalPort) : that.internalPort != null) return false;
            if (this.internalProtocol != null ? !this.internalProtocol.equals(that.internalProtocol) : that.internalProtocol != null) return false;
            if (this.policyNames != null ? !this.policyNames.equals(that.policyNames) : that.policyNames != null) return false;
            return this.sslCertificateId != null ? this.sslCertificateId.equals(that.sslCertificateId) : that.sslCertificateId == null;
        }

        @Override
        public int hashCode() {
            int result = this.externalPort.hashCode();
            result = 31 * result + (this.allowConnectionsFrom != null ? this.allowConnectionsFrom.hashCode() : 0);
            result = 31 * result + (this.externalProtocol != null ? this.externalProtocol.hashCode() : 0);
            result = 31 * result + (this.internalPort != null ? this.internalPort.hashCode() : 0);
            result = 31 * result + (this.internalProtocol != null ? this.internalProtocol.hashCode() : 0);
            result = 31 * result + (this.policyNames != null ? this.policyNames.hashCode() : 0);
            result = 31 * result + (this.sslCertificateId != null ? this.sslCertificateId.hashCode() : 0);
            return result;
        }
    }
}
