package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Reference to a listener's port just created.
 * 
 * This implements IConnectable with a default port (the port that an ELB
 * listener was just created on) for a given security group so that it can be
 * conveniently used just like any Connectable. E.g:
 * 
 *     const listener = elb.addListener(...);
 * 
 *     listener.connections.allowDefaultPortFromAnyIPv4();
 *     // or
 *     instance.connections.allowToDefaultPort(listener);
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.895Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.ListenerPort")
public class ListenerPort extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IConnectable {

    protected ListenerPort(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ListenerPort(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param securityGroup This parameter is required.
     * @param defaultPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ListenerPort(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.services.ec2.Port defaultPort) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required"), java.util.Objects.requireNonNull(defaultPort, "defaultPort is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }
}
