package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * A CloudFormation `AWS::ElasticLoadBalancing::LoadBalancer`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:04.889Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer")
public class CfnLoadBalancer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticLoadBalancing::LoadBalancer`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnLoadBalancer(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrCanonicalHostedZoneName() {
        return this.jsiiGet("attrCanonicalHostedZoneName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrCanonicalHostedZoneNameId() {
        return this.jsiiGet("attrCanonicalHostedZoneNameId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrDnsName() {
        return this.jsiiGet("attrDnsName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrSourceSecurityGroupGroupName() {
        return this.jsiiGet("attrSourceSecurityGroupGroupName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrSourceSecurityGroupOwnerAlias() {
        return this.jsiiGet("attrSourceSecurityGroupOwnerAlias", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-elasticloadbalancing-loadbalancer-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getListeners() {
        return this.jsiiGet("listeners", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setListeners(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("listeners", java.util.Objects.requireNonNull(value, "listeners is required"));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setListeners(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("listeners", java.util.Objects.requireNonNull(value, "listeners is required"));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAccessLoggingPolicy() {
        return this.jsiiGet("accessLoggingPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLoggingPolicy(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accessLoggingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-accessloggingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLoggingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty value) {
        this.jsiiSet("accessLoggingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAppCookieStickinessPolicy() {
        return this.jsiiGet("appCookieStickinessPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAppCookieStickinessPolicy(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("appCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-appcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAppCookieStickinessPolicy(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("appCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("availabilityZones", java.util.List.class));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-availabilityzones
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAvailabilityZones(final java.util.List<java.lang.String> value) {
        this.jsiiSet("availabilityZones", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getConnectionDrainingPolicy() {
        return this.jsiiGet("connectionDrainingPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionDrainingPolicy(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("connectionDrainingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectiondrainingpolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionDrainingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty value) {
        this.jsiiSet("connectionDrainingPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getConnectionSettings() {
        return this.jsiiGet("connectionSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionSettings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("connectionSettings", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-connectionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setConnectionSettings(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty value) {
        this.jsiiSet("connectionSettings", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCrossZone() {
        return this.jsiiGet("crossZone", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCrossZone(final java.lang.Boolean value) {
        this.jsiiSet("crossZone", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-crosszone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCrossZone(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("crossZone", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getHealthCheck() {
        return this.jsiiGet("healthCheck", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHealthCheck(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("healthCheck", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-healthcheck
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty value) {
        this.jsiiSet("healthCheck", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getInstances() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("instances", java.util.List.class));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Instances`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-instances
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setInstances(final java.util.List<java.lang.String> value) {
        this.jsiiSet("instances", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getLbCookieStickinessPolicy() {
        return this.jsiiGet("lbCookieStickinessPolicy", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLbCookieStickinessPolicy(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("lbCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-lbcookiestickinesspolicy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLbCookieStickinessPolicy(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("lbCookieStickinessPolicy", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getLoadBalancerName() {
        return this.jsiiGet("loadBalancerName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-elbname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setLoadBalancerName(final java.lang.String value) {
        this.jsiiSet("loadBalancerName", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getPolicies() {
        return this.jsiiGet("policies", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Policies`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-policies
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPolicies(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("policies", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getScheme() {
        return this.jsiiGet("scheme", java.lang.String.class);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-scheme
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setScheme(final java.lang.String value) {
        this.jsiiSet("scheme", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("securityGroups", java.util.List.class));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-securitygroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSecurityGroups(final java.util.List<java.lang.String> value) {
        this.jsiiSet("securityGroups", value);
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getSubnets() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("subnets", java.util.List.class));
    }

    /**
     * `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#cfn-ec2-elb-subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSubnets(final java.util.List<java.lang.String> value) {
        this.jsiiSet("subnets", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLoggingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccessLoggingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getS3BucketName();

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.EmitInterval`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-emitinterval
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getEmitInterval() {
            return null;
        }

        /**
         * `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketPrefix`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-accessloggingpolicy.html#cfn-elb-accessloggingpolicy-s3bucketprefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getS3BucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLoggingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLoggingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object enabled;
            private java.lang.String s3BucketName;
            private java.lang.Number emitInterval;
            private java.lang.String s3BucketPrefix;

            /**
             * Sets the value of Enabled
             * @param enabled `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnLoadBalancer.AccessLoggingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of S3BucketName
             * @param s3BucketName `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of EmitInterval
             * @param emitInterval `CfnLoadBalancer.AccessLoggingPolicyProperty.EmitInterval`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder emitInterval(java.lang.Number emitInterval) {
                this.emitInterval = emitInterval;
                return this;
            }

            /**
             * Sets the value of S3BucketPrefix
             * @param s3BucketPrefix `CfnLoadBalancer.AccessLoggingPolicyProperty.S3BucketPrefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder s3BucketPrefix(java.lang.String s3BucketPrefix) {
                this.s3BucketPrefix = s3BucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLoggingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccessLoggingPolicyProperty build() {
                return new Jsii$Proxy(enabled, s3BucketName, emitInterval, s3BucketPrefix);
            }
        }

        /**
         * An implementation for {@link AccessLoggingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLoggingPolicyProperty {
            private final java.lang.Object enabled;
            private final java.lang.String s3BucketName;
            private final java.lang.Number emitInterval;
            private final java.lang.String s3BucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.s3BucketName = this.jsiiGet("s3BucketName", java.lang.String.class);
                this.emitInterval = this.jsiiGet("emitInterval", java.lang.Number.class);
                this.s3BucketPrefix = this.jsiiGet("s3BucketPrefix", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.String s3BucketName, final java.lang.Number emitInterval, final java.lang.String s3BucketPrefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.s3BucketName = java.util.Objects.requireNonNull(s3BucketName, "s3BucketName is required");
                this.emitInterval = emitInterval;
                this.s3BucketPrefix = s3BucketPrefix;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public java.lang.Number getEmitInterval() {
                return this.emitInterval;
            }

            @Override
            public java.lang.String getS3BucketPrefix() {
                return this.s3BucketPrefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                if (this.getEmitInterval() != null) {
                    data.set("emitInterval", om.valueToTree(this.getEmitInterval()));
                }
                if (this.getS3BucketPrefix() != null) {
                    data.set("s3BucketPrefix", om.valueToTree(this.getS3BucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLoggingPolicyProperty.Jsii$Proxy that = (AccessLoggingPolicyProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!s3BucketName.equals(that.s3BucketName)) return false;
                if (this.emitInterval != null ? !this.emitInterval.equals(that.emitInterval) : that.emitInterval != null) return false;
                return this.s3BucketPrefix != null ? this.s3BucketPrefix.equals(that.s3BucketPrefix) : that.s3BucketPrefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.s3BucketName.hashCode());
                result = 31 * result + (this.emitInterval != null ? this.emitInterval.hashCode() : 0);
                result = 31 * result + (this.s3BucketPrefix != null ? this.s3BucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AppCookieStickinessPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AppCookieStickinessPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AppCookieStickinessPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.CookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-cookiename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCookieName();

        /**
         * `CfnLoadBalancer.AppCookieStickinessPolicyProperty.PolicyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-AppCookieStickinessPolicy.html#cfn-elb-appcookiestickinesspolicy-policyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPolicyName();

        /**
         * @return a {@link Builder} of {@link AppCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String cookieName;
            private java.lang.String policyName;

            /**
             * Sets the value of CookieName
             * @param cookieName `CfnLoadBalancer.AppCookieStickinessPolicyProperty.CookieName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cookieName(java.lang.String cookieName) {
                this.cookieName = cookieName;
                return this;
            }

            /**
             * Sets the value of PolicyName
             * @param policyName `CfnLoadBalancer.AppCookieStickinessPolicyProperty.PolicyName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder policyName(java.lang.String policyName) {
                this.policyName = policyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppCookieStickinessPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AppCookieStickinessPolicyProperty build() {
                return new Jsii$Proxy(cookieName, policyName);
            }
        }

        /**
         * An implementation for {@link AppCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppCookieStickinessPolicyProperty {
            private final java.lang.String cookieName;
            private final java.lang.String policyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieName = this.jsiiGet("cookieName", java.lang.String.class);
                this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cookieName, final java.lang.String policyName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieName = java.util.Objects.requireNonNull(cookieName, "cookieName is required");
                this.policyName = java.util.Objects.requireNonNull(policyName, "policyName is required");
            }

            @Override
            public java.lang.String getCookieName() {
                return this.cookieName;
            }

            @Override
            public java.lang.String getPolicyName() {
                return this.policyName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cookieName", om.valueToTree(this.getCookieName()));
                data.set("policyName", om.valueToTree(this.getPolicyName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.AppCookieStickinessPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppCookieStickinessPolicyProperty.Jsii$Proxy that = (AppCookieStickinessPolicyProperty.Jsii$Proxy) o;

                if (!cookieName.equals(that.cookieName)) return false;
                return this.policyName.equals(that.policyName);
            }

            @Override
            public int hashCode() {
                int result = this.cookieName.hashCode();
                result = 31 * result + (this.policyName.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionDrainingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ConnectionDrainingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getEnabled();

        /**
         * `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Timeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectiondrainingpolicy.html#cfn-elb-connectiondrainingpolicy-timeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionDrainingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionDrainingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object enabled;
            private java.lang.Number timeout;

            /**
             * Sets the value of Enabled
             * @param enabled `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Enabled
             * @param enabled `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of Timeout
             * @param timeout `CfnLoadBalancer.ConnectionDrainingPolicyProperty.Timeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionDrainingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ConnectionDrainingPolicyProperty build() {
                return new Jsii$Proxy(enabled, timeout);
            }
        }

        /**
         * An implementation for {@link ConnectionDrainingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionDrainingPolicyProperty {
            private final java.lang.Object enabled;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.timeout = this.jsiiGet("timeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.lang.Number timeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.timeout = timeout;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionDrainingPolicyProperty.Jsii$Proxy that = (ConnectionDrainingPolicyProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ConnectionSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.ConnectionSettingsProperty.IdleTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-connectionsettings.html#cfn-elb-connectionsettings-idletimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getIdleTimeout();

        /**
         * @return a {@link Builder} of {@link ConnectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number idleTimeout;

            /**
             * Sets the value of IdleTimeout
             * @param idleTimeout `CfnLoadBalancer.ConnectionSettingsProperty.IdleTimeout`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder idleTimeout(java.lang.Number idleTimeout) {
                this.idleTimeout = idleTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ConnectionSettingsProperty build() {
                return new Jsii$Proxy(idleTimeout);
            }
        }

        /**
         * An implementation for {@link ConnectionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionSettingsProperty {
            private final java.lang.Number idleTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleTimeout = this.jsiiGet("idleTimeout", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number idleTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleTimeout = java.util.Objects.requireNonNull(idleTimeout, "idleTimeout is required");
            }

            @Override
            public java.lang.Number getIdleTimeout() {
                return this.idleTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionSettingsProperty.Jsii$Proxy that = (ConnectionSettingsProperty.Jsii$Proxy) o;

                return this.idleTimeout.equals(that.idleTimeout);
            }

            @Override
            public int hashCode() {
                int result = this.idleTimeout.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface HealthCheckProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.HealthCheckProperty.HealthyThreshold`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-healthythreshold
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getHealthyThreshold();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.Interval`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-interval
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInterval();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.Target`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-target
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTarget();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.Timeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-timeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getTimeout();

        /**
         * `CfnLoadBalancer.HealthCheckProperty.UnhealthyThreshold`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-health-check.html#cfn-elb-healthcheck-unhealthythreshold
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUnhealthyThreshold();

        /**
         * @return a {@link Builder} of {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String healthyThreshold;
            private java.lang.String interval;
            private java.lang.String target;
            private java.lang.String timeout;
            private java.lang.String unhealthyThreshold;

            /**
             * Sets the value of HealthyThreshold
             * @param healthyThreshold `CfnLoadBalancer.HealthCheckProperty.HealthyThreshold`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder healthyThreshold(java.lang.String healthyThreshold) {
                this.healthyThreshold = healthyThreshold;
                return this;
            }

            /**
             * Sets the value of Interval
             * @param interval `CfnLoadBalancer.HealthCheckProperty.Interval`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder interval(java.lang.String interval) {
                this.interval = interval;
                return this;
            }

            /**
             * Sets the value of Target
             * @param target `CfnLoadBalancer.HealthCheckProperty.Target`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of Timeout
             * @param timeout `CfnLoadBalancer.HealthCheckProperty.Timeout`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder timeout(java.lang.String timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of UnhealthyThreshold
             * @param unhealthyThreshold `CfnLoadBalancer.HealthCheckProperty.UnhealthyThreshold`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder unhealthyThreshold(java.lang.String unhealthyThreshold) {
                this.unhealthyThreshold = unhealthyThreshold;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public HealthCheckProperty build() {
                return new Jsii$Proxy(healthyThreshold, interval, target, timeout, unhealthyThreshold);
            }
        }

        /**
         * An implementation for {@link HealthCheckProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckProperty {
            private final java.lang.String healthyThreshold;
            private final java.lang.String interval;
            private final java.lang.String target;
            private final java.lang.String timeout;
            private final java.lang.String unhealthyThreshold;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthyThreshold = this.jsiiGet("healthyThreshold", java.lang.String.class);
                this.interval = this.jsiiGet("interval", java.lang.String.class);
                this.target = this.jsiiGet("target", java.lang.String.class);
                this.timeout = this.jsiiGet("timeout", java.lang.String.class);
                this.unhealthyThreshold = this.jsiiGet("unhealthyThreshold", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String healthyThreshold, final java.lang.String interval, final java.lang.String target, final java.lang.String timeout, final java.lang.String unhealthyThreshold) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthyThreshold = java.util.Objects.requireNonNull(healthyThreshold, "healthyThreshold is required");
                this.interval = java.util.Objects.requireNonNull(interval, "interval is required");
                this.target = java.util.Objects.requireNonNull(target, "target is required");
                this.timeout = java.util.Objects.requireNonNull(timeout, "timeout is required");
                this.unhealthyThreshold = java.util.Objects.requireNonNull(unhealthyThreshold, "unhealthyThreshold is required");
            }

            @Override
            public java.lang.String getHealthyThreshold() {
                return this.healthyThreshold;
            }

            @Override
            public java.lang.String getInterval() {
                return this.interval;
            }

            @Override
            public java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public java.lang.String getTimeout() {
                return this.timeout;
            }

            @Override
            public java.lang.String getUnhealthyThreshold() {
                return this.unhealthyThreshold;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
                data.set("interval", om.valueToTree(this.getInterval()));
                data.set("target", om.valueToTree(this.getTarget()));
                data.set("timeout", om.valueToTree(this.getTimeout()));
                data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckProperty.Jsii$Proxy that = (HealthCheckProperty.Jsii$Proxy) o;

                if (!healthyThreshold.equals(that.healthyThreshold)) return false;
                if (!interval.equals(that.interval)) return false;
                if (!target.equals(that.target)) return false;
                if (!timeout.equals(that.timeout)) return false;
                return this.unhealthyThreshold.equals(that.unhealthyThreshold);
            }

            @Override
            public int hashCode() {
                int result = this.healthyThreshold.hashCode();
                result = 31 * result + (this.interval.hashCode());
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.timeout.hashCode());
                result = 31 * result + (this.unhealthyThreshold.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.LBCookieStickinessPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(LBCookieStickinessPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface LBCookieStickinessPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.CookieExpirationPeriod`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-cookieexpirationperiod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getCookieExpirationPeriod() {
            return null;
        }

        /**
         * `CfnLoadBalancer.LBCookieStickinessPolicyProperty.PolicyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-LBCookieStickinessPolicy.html#cfn-elb-lbcookiestickinesspolicy-policyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getPolicyName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LBCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LBCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String cookieExpirationPeriod;
            private java.lang.String policyName;

            /**
             * Sets the value of CookieExpirationPeriod
             * @param cookieExpirationPeriod `CfnLoadBalancer.LBCookieStickinessPolicyProperty.CookieExpirationPeriod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cookieExpirationPeriod(java.lang.String cookieExpirationPeriod) {
                this.cookieExpirationPeriod = cookieExpirationPeriod;
                return this;
            }

            /**
             * Sets the value of PolicyName
             * @param policyName `CfnLoadBalancer.LBCookieStickinessPolicyProperty.PolicyName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder policyName(java.lang.String policyName) {
                this.policyName = policyName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LBCookieStickinessPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public LBCookieStickinessPolicyProperty build() {
                return new Jsii$Proxy(cookieExpirationPeriod, policyName);
            }
        }

        /**
         * An implementation for {@link LBCookieStickinessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LBCookieStickinessPolicyProperty {
            private final java.lang.String cookieExpirationPeriod;
            private final java.lang.String policyName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cookieExpirationPeriod = this.jsiiGet("cookieExpirationPeriod", java.lang.String.class);
                this.policyName = this.jsiiGet("policyName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cookieExpirationPeriod, final java.lang.String policyName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cookieExpirationPeriod = cookieExpirationPeriod;
                this.policyName = policyName;
            }

            @Override
            public java.lang.String getCookieExpirationPeriod() {
                return this.cookieExpirationPeriod;
            }

            @Override
            public java.lang.String getPolicyName() {
                return this.policyName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCookieExpirationPeriod() != null) {
                    data.set("cookieExpirationPeriod", om.valueToTree(this.getCookieExpirationPeriod()));
                }
                if (this.getPolicyName() != null) {
                    data.set("policyName", om.valueToTree(this.getPolicyName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.LBCookieStickinessPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LBCookieStickinessPolicyProperty.Jsii$Proxy that = (LBCookieStickinessPolicyProperty.Jsii$Proxy) o;

                if (this.cookieExpirationPeriod != null ? !this.cookieExpirationPeriod.equals(that.cookieExpirationPeriod) : that.cookieExpirationPeriod != null) return false;
                return this.policyName != null ? this.policyName.equals(that.policyName) : that.policyName == null;
            }

            @Override
            public int hashCode() {
                int result = this.cookieExpirationPeriod != null ? this.cookieExpirationPeriod.hashCode() : 0;
                result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ListenersProperty")
    @software.amazon.jsii.Jsii.Proxy(ListenersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ListenersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.ListenersProperty.InstancePort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getInstancePort();

        /**
         * `CfnLoadBalancer.ListenersProperty.LoadBalancerPort`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-loadbalancerport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getLoadBalancerPort();

        /**
         * `CfnLoadBalancer.ListenersProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-protocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getProtocol();

        /**
         * `CfnLoadBalancer.ListenersProperty.InstanceProtocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-instanceprotocol
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getInstanceProtocol() {
            return null;
        }

        /**
         * `CfnLoadBalancer.ListenersProperty.PolicyNames`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-policynames
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.util.List<java.lang.String> getPolicyNames() {
            return null;
        }

        /**
         * `CfnLoadBalancer.ListenersProperty.SSLCertificateId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-listener.html#cfn-ec2-elb-listener-sslcertificateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getSslCertificateId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListenersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListenersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String instancePort;
            private java.lang.String loadBalancerPort;
            private java.lang.String protocol;
            private java.lang.String instanceProtocol;
            private java.util.List<java.lang.String> policyNames;
            private java.lang.String sslCertificateId;

            /**
             * Sets the value of InstancePort
             * @param instancePort `CfnLoadBalancer.ListenersProperty.InstancePort`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instancePort(java.lang.String instancePort) {
                this.instancePort = instancePort;
                return this;
            }

            /**
             * Sets the value of LoadBalancerPort
             * @param loadBalancerPort `CfnLoadBalancer.ListenersProperty.LoadBalancerPort`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder loadBalancerPort(java.lang.String loadBalancerPort) {
                this.loadBalancerPort = loadBalancerPort;
                return this;
            }

            /**
             * Sets the value of Protocol
             * @param protocol `CfnLoadBalancer.ListenersProperty.Protocol`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of InstanceProtocol
             * @param instanceProtocol `CfnLoadBalancer.ListenersProperty.InstanceProtocol`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instanceProtocol(java.lang.String instanceProtocol) {
                this.instanceProtocol = instanceProtocol;
                return this;
            }

            /**
             * Sets the value of PolicyNames
             * @param policyNames `CfnLoadBalancer.ListenersProperty.PolicyNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder policyNames(java.util.List<java.lang.String> policyNames) {
                this.policyNames = policyNames;
                return this;
            }

            /**
             * Sets the value of SslCertificateId
             * @param sslCertificateId `CfnLoadBalancer.ListenersProperty.SSLCertificateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder sslCertificateId(java.lang.String sslCertificateId) {
                this.sslCertificateId = sslCertificateId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListenersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ListenersProperty build() {
                return new Jsii$Proxy(instancePort, loadBalancerPort, protocol, instanceProtocol, policyNames, sslCertificateId);
            }
        }

        /**
         * An implementation for {@link ListenersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListenersProperty {
            private final java.lang.String instancePort;
            private final java.lang.String loadBalancerPort;
            private final java.lang.String protocol;
            private final java.lang.String instanceProtocol;
            private final java.util.List<java.lang.String> policyNames;
            private final java.lang.String sslCertificateId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instancePort = this.jsiiGet("instancePort", java.lang.String.class);
                this.loadBalancerPort = this.jsiiGet("loadBalancerPort", java.lang.String.class);
                this.protocol = this.jsiiGet("protocol", java.lang.String.class);
                this.instanceProtocol = this.jsiiGet("instanceProtocol", java.lang.String.class);
                this.policyNames = this.jsiiGet("policyNames", java.util.List.class);
                this.sslCertificateId = this.jsiiGet("sslCertificateId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String instancePort, final java.lang.String loadBalancerPort, final java.lang.String protocol, final java.lang.String instanceProtocol, final java.util.List<java.lang.String> policyNames, final java.lang.String sslCertificateId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instancePort = java.util.Objects.requireNonNull(instancePort, "instancePort is required");
                this.loadBalancerPort = java.util.Objects.requireNonNull(loadBalancerPort, "loadBalancerPort is required");
                this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
                this.instanceProtocol = instanceProtocol;
                this.policyNames = policyNames;
                this.sslCertificateId = sslCertificateId;
            }

            @Override
            public java.lang.String getInstancePort() {
                return this.instancePort;
            }

            @Override
            public java.lang.String getLoadBalancerPort() {
                return this.loadBalancerPort;
            }

            @Override
            public java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public java.lang.String getInstanceProtocol() {
                return this.instanceProtocol;
            }

            @Override
            public java.util.List<java.lang.String> getPolicyNames() {
                return this.policyNames;
            }

            @Override
            public java.lang.String getSslCertificateId() {
                return this.sslCertificateId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instancePort", om.valueToTree(this.getInstancePort()));
                data.set("loadBalancerPort", om.valueToTree(this.getLoadBalancerPort()));
                data.set("protocol", om.valueToTree(this.getProtocol()));
                if (this.getInstanceProtocol() != null) {
                    data.set("instanceProtocol", om.valueToTree(this.getInstanceProtocol()));
                }
                if (this.getPolicyNames() != null) {
                    data.set("policyNames", om.valueToTree(this.getPolicyNames()));
                }
                if (this.getSslCertificateId() != null) {
                    data.set("sslCertificateId", om.valueToTree(this.getSslCertificateId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.ListenersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListenersProperty.Jsii$Proxy that = (ListenersProperty.Jsii$Proxy) o;

                if (!instancePort.equals(that.instancePort)) return false;
                if (!loadBalancerPort.equals(that.loadBalancerPort)) return false;
                if (!protocol.equals(that.protocol)) return false;
                if (this.instanceProtocol != null ? !this.instanceProtocol.equals(that.instanceProtocol) : that.instanceProtocol != null) return false;
                if (this.policyNames != null ? !this.policyNames.equals(that.policyNames) : that.policyNames != null) return false;
                return this.sslCertificateId != null ? this.sslCertificateId.equals(that.sslCertificateId) : that.sslCertificateId == null;
            }

            @Override
            public int hashCode() {
                int result = this.instancePort.hashCode();
                result = 31 * result + (this.loadBalancerPort.hashCode());
                result = 31 * result + (this.protocol.hashCode());
                result = 31 * result + (this.instanceProtocol != null ? this.instanceProtocol.hashCode() : 0);
                result = 31 * result + (this.policyNames != null ? this.policyNames.hashCode() : 0);
                result = 31 * result + (this.sslCertificateId != null ? this.sslCertificateId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancing.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.PoliciesProperty")
    @software.amazon.jsii.Jsii.Proxy(PoliciesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PoliciesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnLoadBalancer.PoliciesProperty.Attributes`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-attributes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getAttributes();

        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policyname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPolicyName();

        /**
         * `CfnLoadBalancer.PoliciesProperty.PolicyType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-policytype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPolicyType();

        /**
         * `CfnLoadBalancer.PoliciesProperty.InstancePorts`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-instanceports
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.util.List<java.lang.String> getInstancePorts() {
            return null;
        }

        /**
         * `CfnLoadBalancer.PoliciesProperty.LoadBalancerPorts`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb-policy.html#cfn-ec2-elb-policy-loadbalancerports
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.util.List<java.lang.String> getLoadBalancerPorts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object attributes;
            private java.lang.String policyName;
            private java.lang.String policyType;
            private java.util.List<java.lang.String> instancePorts;
            private java.util.List<java.lang.String> loadBalancerPorts;

            /**
             * Sets the value of Attributes
             * @param attributes `CfnLoadBalancer.PoliciesProperty.Attributes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder attributes(java.util.List<java.lang.Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of Attributes
             * @param attributes `CfnLoadBalancer.PoliciesProperty.Attributes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder attributes(software.amazon.awscdk.core.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of PolicyName
             * @param policyName `CfnLoadBalancer.PoliciesProperty.PolicyName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder policyName(java.lang.String policyName) {
                this.policyName = policyName;
                return this;
            }

            /**
             * Sets the value of PolicyType
             * @param policyType `CfnLoadBalancer.PoliciesProperty.PolicyType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder policyType(java.lang.String policyType) {
                this.policyType = policyType;
                return this;
            }

            /**
             * Sets the value of InstancePorts
             * @param instancePorts `CfnLoadBalancer.PoliciesProperty.InstancePorts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder instancePorts(java.util.List<java.lang.String> instancePorts) {
                this.instancePorts = instancePorts;
                return this;
            }

            /**
             * Sets the value of LoadBalancerPorts
             * @param loadBalancerPorts `CfnLoadBalancer.PoliciesProperty.LoadBalancerPorts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder loadBalancerPorts(java.util.List<java.lang.String> loadBalancerPorts) {
                this.loadBalancerPorts = loadBalancerPorts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PoliciesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PoliciesProperty build() {
                return new Jsii$Proxy(attributes, policyName, policyType, instancePorts, loadBalancerPorts);
            }
        }

        /**
         * An implementation for {@link PoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PoliciesProperty {
            private final java.lang.Object attributes;
            private final java.lang.String policyName;
            private final java.lang.String policyType;
            private final java.util.List<java.lang.String> instancePorts;
            private final java.util.List<java.lang.String> loadBalancerPorts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = this.jsiiGet("attributes", java.lang.Object.class);
                this.policyName = this.jsiiGet("policyName", java.lang.String.class);
                this.policyType = this.jsiiGet("policyType", java.lang.String.class);
                this.instancePorts = this.jsiiGet("instancePorts", java.util.List.class);
                this.loadBalancerPorts = this.jsiiGet("loadBalancerPorts", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object attributes, final java.lang.String policyName, final java.lang.String policyType, final java.util.List<java.lang.String> instancePorts, final java.util.List<java.lang.String> loadBalancerPorts) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = java.util.Objects.requireNonNull(attributes, "attributes is required");
                this.policyName = java.util.Objects.requireNonNull(policyName, "policyName is required");
                this.policyType = java.util.Objects.requireNonNull(policyType, "policyType is required");
                this.instancePorts = instancePorts;
                this.loadBalancerPorts = loadBalancerPorts;
            }

            @Override
            public java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public java.lang.String getPolicyName() {
                return this.policyName;
            }

            @Override
            public java.lang.String getPolicyType() {
                return this.policyType;
            }

            @Override
            public java.util.List<java.lang.String> getInstancePorts() {
                return this.instancePorts;
            }

            @Override
            public java.util.List<java.lang.String> getLoadBalancerPorts() {
                return this.loadBalancerPorts;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributes", om.valueToTree(this.getAttributes()));
                data.set("policyName", om.valueToTree(this.getPolicyName()));
                data.set("policyType", om.valueToTree(this.getPolicyType()));
                if (this.getInstancePorts() != null) {
                    data.set("instancePorts", om.valueToTree(this.getInstancePorts()));
                }
                if (this.getLoadBalancerPorts() != null) {
                    data.set("loadBalancerPorts", om.valueToTree(this.getLoadBalancerPorts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-elasticloadbalancing.CfnLoadBalancer.PoliciesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PoliciesProperty.Jsii$Proxy that = (PoliciesProperty.Jsii$Proxy) o;

                if (!attributes.equals(that.attributes)) return false;
                if (!policyName.equals(that.policyName)) return false;
                if (!policyType.equals(that.policyType)) return false;
                if (this.instancePorts != null ? !this.instancePorts.equals(that.instancePorts) : that.instancePorts != null) return false;
                return this.loadBalancerPorts != null ? this.loadBalancerPorts.equals(that.loadBalancerPorts) : that.loadBalancerPorts == null;
            }

            @Override
            public int hashCode() {
                int result = this.attributes.hashCode();
                result = 31 * result + (this.policyName.hashCode());
                result = 31 * result + (this.policyType.hashCode());
                result = 31 * result + (this.instancePorts != null ? this.instancePorts.hashCode() : 0);
                result = 31 * result + (this.loadBalancerPorts != null ? this.loadBalancerPorts.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancerProps.Builder();
        }

        /**
         * @return {@code this}
         * @param listeners `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder listeners(final software.amazon.awscdk.core.IResolvable listeners) {
            this.props.listeners(listeners);
            return this;
        }
        /**
         * @return {@code this}
         * @param listeners `AWS::ElasticLoadBalancing::LoadBalancer.Listeners`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder listeners(final java.util.List<java.lang.Object> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * @return {@code this}
         * @param accessLoggingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLoggingPolicy(final software.amazon.awscdk.core.IResolvable accessLoggingPolicy) {
            this.props.accessLoggingPolicy(accessLoggingPolicy);
            return this;
        }
        /**
         * @return {@code this}
         * @param accessLoggingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AccessLoggingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLoggingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy) {
            this.props.accessLoggingPolicy(accessLoggingPolicy);
            return this;
        }

        /**
         * @return {@code this}
         * @param appCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder appCookieStickinessPolicy(final software.amazon.awscdk.core.IResolvable appCookieStickinessPolicy) {
            this.props.appCookieStickinessPolicy(appCookieStickinessPolicy);
            return this;
        }
        /**
         * @return {@code this}
         * @param appCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.AppCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder appCookieStickinessPolicy(final java.util.List<java.lang.Object> appCookieStickinessPolicy) {
            this.props.appCookieStickinessPolicy(appCookieStickinessPolicy);
            return this;
        }

        /**
         * @return {@code this}
         * @param availabilityZones `AWS::ElasticLoadBalancing::LoadBalancer.AvailabilityZones`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder availabilityZones(final java.util.List<java.lang.String> availabilityZones) {
            this.props.availabilityZones(availabilityZones);
            return this;
        }

        /**
         * @return {@code this}
         * @param connectionDrainingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionDrainingPolicy(final software.amazon.awscdk.core.IResolvable connectionDrainingPolicy) {
            this.props.connectionDrainingPolicy(connectionDrainingPolicy);
            return this;
        }
        /**
         * @return {@code this}
         * @param connectionDrainingPolicy `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionDrainingPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionDrainingPolicy(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty connectionDrainingPolicy) {
            this.props.connectionDrainingPolicy(connectionDrainingPolicy);
            return this;
        }

        /**
         * @return {@code this}
         * @param connectionSettings `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionSettings(final software.amazon.awscdk.core.IResolvable connectionSettings) {
            this.props.connectionSettings(connectionSettings);
            return this;
        }
        /**
         * @return {@code this}
         * @param connectionSettings `AWS::ElasticLoadBalancing::LoadBalancer.ConnectionSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder connectionSettings(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty connectionSettings) {
            this.props.connectionSettings(connectionSettings);
            return this;
        }

        /**
         * @return {@code this}
         * @param crossZone `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder crossZone(final java.lang.Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }
        /**
         * @return {@code this}
         * @param crossZone `AWS::ElasticLoadBalancing::LoadBalancer.CrossZone`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder crossZone(final software.amazon.awscdk.core.IResolvable crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        /**
         * @return {@code this}
         * @param healthCheck `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder healthCheck(final software.amazon.awscdk.core.IResolvable healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }
        /**
         * @return {@code this}
         * @param healthCheck `AWS::ElasticLoadBalancing::LoadBalancer.HealthCheck`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder healthCheck(final software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * @return {@code this}
         * @param instances `AWS::ElasticLoadBalancing::LoadBalancer.Instances`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder instances(final java.util.List<java.lang.String> instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * @return {@code this}
         * @param lbCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder lbCookieStickinessPolicy(final software.amazon.awscdk.core.IResolvable lbCookieStickinessPolicy) {
            this.props.lbCookieStickinessPolicy(lbCookieStickinessPolicy);
            return this;
        }
        /**
         * @return {@code this}
         * @param lbCookieStickinessPolicy `AWS::ElasticLoadBalancing::LoadBalancer.LBCookieStickinessPolicy`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder lbCookieStickinessPolicy(final java.util.List<java.lang.Object> lbCookieStickinessPolicy) {
            this.props.lbCookieStickinessPolicy(lbCookieStickinessPolicy);
            return this;
        }

        /**
         * @return {@code this}
         * @param loadBalancerName `AWS::ElasticLoadBalancing::LoadBalancer.LoadBalancerName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder loadBalancerName(final java.lang.String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        /**
         * @return {@code this}
         * @param policies `AWS::ElasticLoadBalancing::LoadBalancer.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policies(final software.amazon.awscdk.core.IResolvable policies) {
            this.props.policies(policies);
            return this;
        }
        /**
         * @return {@code this}
         * @param policies `AWS::ElasticLoadBalancing::LoadBalancer.Policies`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policies(final java.util.List<java.lang.Object> policies) {
            this.props.policies(policies);
            return this;
        }

        /**
         * @return {@code this}
         * @param scheme `AWS::ElasticLoadBalancing::LoadBalancer.Scheme`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder scheme(final java.lang.String scheme) {
            this.props.scheme(scheme);
            return this;
        }

        /**
         * @return {@code this}
         * @param securityGroups `AWS::ElasticLoadBalancing::LoadBalancer.SecurityGroups`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * @return {@code this}
         * @param subnets `AWS::ElasticLoadBalancing::LoadBalancer.Subnets`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder subnets(final java.util.List<java.lang.String> subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * @return {@code this}
         * @param tags `AWS::ElasticLoadBalancing::LoadBalancer.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer build() {
            return new software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
