/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancing;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancing.;
import software.amazon.awscdk.services.elasticloadbalancing.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancing.ListenerPort;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerListener;
import software.amazon.awscdk.services.elasticloadbalancing.LoadBalancerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticloadbalancing.LoadBalancer")
public class LoadBalancer
extends Resource
implements IConnectable {
    protected LoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LoadBalancer(Construct scope, String id, LoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public ListenerPort addListener(LoadBalancerListener listener) {
        return (ListenerPort)((Object)this.jsiiCall("addListener", ListenerPort.class, new Object[]{Objects.requireNonNull(listener, "listener is required")}));
    }

    public void addTarget(ILoadBalancerTarget target) {
        this.jsiiCall("addTarget", Void.class, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public Connections getConnections() {
        return (Connections)this.jsiiGet("connections", Connections.class);
    }

    public List<ListenerPort> getListenerPorts() {
        return Collections.unmodifiableList((List)this.jsiiGet("listenerPorts", List.class));
    }

    public String getLoadBalancerCanonicalHostedZoneName() {
        return (String)this.jsiiGet("loadBalancerCanonicalHostedZoneName", String.class);
    }

    public String getLoadBalancerCanonicalHostedZoneNameId() {
        return (String)this.jsiiGet("loadBalancerCanonicalHostedZoneNameId", String.class);
    }

    public String getLoadBalancerDnsName() {
        return (String)this.jsiiGet("loadBalancerDnsName", String.class);
    }

    public String getLoadBalancerName() {
        return (String)this.jsiiGet("loadBalancerName", String.class);
    }

    public String getLoadBalancerSourceSecurityGroupGroupName() {
        return (String)this.jsiiGet("loadBalancerSourceSecurityGroupGroupName", String.class);
    }

    public String getLoadBalancerSourceSecurityGroupOwnerAlias() {
        return (String)this.jsiiGet("loadBalancerSourceSecurityGroupOwnerAlias", String.class);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final LoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new LoadBalancerProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder crossZone(Boolean crossZone) {
            this.props.crossZone(crossZone);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder listeners(List<LoadBalancerListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder targets(List<ILoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

