package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `AWS::ElasticBeanstalk::ConfigurationTemplate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:15:23.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnConfigurationTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApplicationName();

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-environmentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getEnvironmentId();

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getOptionSettings();

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPlatformArn();

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getSolutionStackName();

    /**
     * `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticbeanstalk-configurationtemplate.html#cfn-elasticbeanstalk-configurationtemplate-sourceconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getSourceConfiguration();

    /**
     * @return a {@link Builder} of {@link CfnConfigurationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String applicationName;
        private java.lang.String description;
        private java.lang.String environmentId;
        private java.lang.Object optionSettings;
        private java.lang.String platformArn;
        private java.lang.String solutionStackName;
        private java.lang.Object sourceConfiguration;

        /**
         * Sets the value of ApplicationName
         * @param applicationName `AWS::ElasticBeanstalk::ConfigurationTemplate.ApplicationName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ElasticBeanstalk::ConfigurationTemplate.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of EnvironmentId
         * @param environmentId `AWS::ElasticBeanstalk::ConfigurationTemplate.EnvironmentId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder environmentId(java.lang.String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        /**
         * Sets the value of OptionSettings
         * @param optionSettings `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder optionSettings(software.amazon.awscdk.core.IResolvable optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        /**
         * Sets the value of OptionSettings
         * @param optionSettings `AWS::ElasticBeanstalk::ConfigurationTemplate.OptionSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder optionSettings(java.util.List<java.lang.Object> optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        /**
         * Sets the value of PlatformArn
         * @param platformArn `AWS::ElasticBeanstalk::ConfigurationTemplate.PlatformArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder platformArn(java.lang.String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        /**
         * Sets the value of SolutionStackName
         * @param solutionStackName `AWS::ElasticBeanstalk::ConfigurationTemplate.SolutionStackName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder solutionStackName(java.lang.String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        /**
         * Sets the value of SourceConfiguration
         * @param sourceConfiguration `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceConfiguration(software.amazon.awscdk.core.IResolvable sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Sets the value of SourceConfiguration
         * @param sourceConfiguration `AWS::ElasticBeanstalk::ConfigurationTemplate.SourceConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder sourceConfiguration(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnConfigurationTemplateProps build() {
            return new Jsii$Proxy(applicationName, description, environmentId, optionSettings, platformArn, solutionStackName, sourceConfiguration);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationTemplateProps {
        private final java.lang.String applicationName;
        private final java.lang.String description;
        private final java.lang.String environmentId;
        private final java.lang.Object optionSettings;
        private final java.lang.String platformArn;
        private final java.lang.String solutionStackName;
        private final java.lang.Object sourceConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.applicationName = this.jsiiGet("applicationName", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.environmentId = this.jsiiGet("environmentId", java.lang.String.class);
            this.optionSettings = this.jsiiGet("optionSettings", java.lang.Object.class);
            this.platformArn = this.jsiiGet("platformArn", java.lang.String.class);
            this.solutionStackName = this.jsiiGet("solutionStackName", java.lang.String.class);
            this.sourceConfiguration = this.jsiiGet("sourceConfiguration", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String applicationName, java.lang.String description, java.lang.String environmentId, java.lang.Object optionSettings, java.lang.String platformArn, java.lang.String solutionStackName, java.lang.Object sourceConfiguration) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(applicationName, "applicationName is required");
            this.description = description;
            this.environmentId = environmentId;
            this.optionSettings = optionSettings;
            this.platformArn = platformArn;
            this.solutionStackName = solutionStackName;
            this.sourceConfiguration = sourceConfiguration;
        }

        @Override
        public java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public java.lang.Object getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public java.lang.String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public java.lang.String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public java.lang.Object getSourceConfiguration() {
            return this.sourceConfiguration;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("applicationName", om.valueToTree(this.getApplicationName()));
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentId() != null) {
                obj.set("environmentId", om.valueToTree(this.getEnvironmentId()));
            }
            if (this.getOptionSettings() != null) {
                obj.set("optionSettings", om.valueToTree(this.getOptionSettings()));
            }
            if (this.getPlatformArn() != null) {
                obj.set("platformArn", om.valueToTree(this.getPlatformArn()));
            }
            if (this.getSolutionStackName() != null) {
                obj.set("solutionStackName", om.valueToTree(this.getSolutionStackName()));
            }
            if (this.getSourceConfiguration() != null) {
                obj.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationTemplateProps.Jsii$Proxy that = (CfnConfigurationTemplateProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentId != null ? !this.environmentId.equals(that.environmentId) : that.environmentId != null) return false;
            if (this.optionSettings != null ? !this.optionSettings.equals(that.optionSettings) : that.optionSettings != null) return false;
            if (this.platformArn != null ? !this.platformArn.equals(that.platformArn) : that.platformArn != null) return false;
            if (this.solutionStackName != null ? !this.solutionStackName.equals(that.solutionStackName) : that.solutionStackName != null) return false;
            return this.sourceConfiguration != null ? this.sourceConfiguration.equals(that.sourceConfiguration) : that.sourceConfiguration == null;
        }

        @Override
        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentId != null ? this.environmentId.hashCode() : 0);
            result = 31 * result + (this.optionSettings != null ? this.optionSettings.hashCode() : 0);
            result = 31 * result + (this.platformArn != null ? this.platformArn.hashCode() : 0);
            result = 31 * result + (this.solutionStackName != null ? this.solutionStackName.hashCode() : 0);
            result = 31 * result + (this.sourceConfiguration != null ? this.sourceConfiguration.hashCode() : 0);
            return result;
        }
    }
}
