/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import java.util.List;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment;
import software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironmentProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnEnvironmentProps
extends JsiiSerializable {
    public String getApplicationName();

    public String getCnamePrefix();

    public String getDescription();

    public String getEnvironmentName();

    public Object getOptionSettings();

    public String getPlatformArn();

    public String getSolutionStackName();

    public List<CfnTag> getTags();

    public String getTemplateName();

    public Object getTier();

    public String getVersionLabel();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String applicationName;
        private String cnamePrefix;
        private String description;
        private String environmentName;
        private Object optionSettings;
        private String platformArn;
        private String solutionStackName;
        private List<CfnTag> tags;
        private String templateName;
        private Object tier;
        private String versionLabel;

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder cnamePrefix(String cnamePrefix) {
            this.cnamePrefix = cnamePrefix;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public Builder optionSettings(IResolvable optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        public Builder optionSettings(List<Object> optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        public Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder tier(IResolvable tier) {
            this.tier = tier;
            return this;
        }

        public Builder tier(CfnEnvironment.TierProperty tier) {
            this.tier = tier;
            return this;
        }

        public Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public CfnEnvironmentProps build() {
            return new Jsii.Proxy(this.applicationName, this.cnamePrefix, this.description, this.environmentName, this.optionSettings, this.platformArn, this.solutionStackName, this.tags, this.templateName, this.tier, this.versionLabel, null);
        }
    }
}

