/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticbeanstalk;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.elasticbeanstalk.;
import software.amazon.awscdk.services.elasticbeanstalk.CfnApplication;
import software.amazon.awscdk.services.elasticbeanstalk.CfnApplicationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-elasticbeanstalk.CfnApplication")
public class CfnApplication
extends CfnResource {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(Construct scope, String id, CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props}));
    }

    public CfnApplication(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        this.setObjRef(JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")}));
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public String getApplicationName() {
        return (String)this.jsiiGet("applicationName", String.class);
    }

    public void setApplicationName(String value) {
        this.jsiiSet("applicationName", value);
    }

    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(String value) {
        this.jsiiSet("description", value);
    }

    public Object getResourceLifecycleConfig() {
        return this.jsiiGet("resourceLifecycleConfig", Object.class);
    }

    public void setResourceLifecycleConfig(IResolvable value) {
        this.jsiiSet("resourceLifecycleConfig", value);
    }

    public void setResourceLifecycleConfig(ApplicationResourceLifecycleConfigProperty value) {
        this.jsiiSet("resourceLifecycleConfig", value);
    }

    public static interface MaxCountRuleProperty
    extends JsiiSerializable {
        public Object getDeleteSourceFromS3();

        public Object getEnabled();

        public Number getMaxCount();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object deleteSourceFromS3;
            private Object enabled;
            private Number maxCount;

            public Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder deleteSourceFromS3(IResolvable deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder maxCount(Number maxCount) {
                this.maxCount = maxCount;
                return this;
            }

            public MaxCountRuleProperty build() {
                return new Jsii.Proxy(this.deleteSourceFromS3, this.enabled, this.maxCount, null);
            }
        }
    }

    public static interface MaxAgeRuleProperty
    extends JsiiSerializable {
        public Object getDeleteSourceFromS3();

        public Object getEnabled();

        public Number getMaxAgeInDays();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object deleteSourceFromS3;
            private Object enabled;
            private Number maxAgeInDays;

            public Builder deleteSourceFromS3(Boolean deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder deleteSourceFromS3(IResolvable deleteSourceFromS3) {
                this.deleteSourceFromS3 = deleteSourceFromS3;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder maxAgeInDays(Number maxAgeInDays) {
                this.maxAgeInDays = maxAgeInDays;
                return this;
            }

            public MaxAgeRuleProperty build() {
                return new Jsii.Proxy(this.deleteSourceFromS3, this.enabled, this.maxAgeInDays, null);
            }
        }
    }

    public static interface ApplicationVersionLifecycleConfigProperty
    extends JsiiSerializable {
        public Object getMaxAgeRule();

        public Object getMaxCountRule();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object maxAgeRule;
            private Object maxCountRule;

            public Builder maxAgeRule(IResolvable maxAgeRule) {
                this.maxAgeRule = maxAgeRule;
                return this;
            }

            public Builder maxAgeRule(MaxAgeRuleProperty maxAgeRule) {
                this.maxAgeRule = maxAgeRule;
                return this;
            }

            public Builder maxCountRule(IResolvable maxCountRule) {
                this.maxCountRule = maxCountRule;
                return this;
            }

            public Builder maxCountRule(MaxCountRuleProperty maxCountRule) {
                this.maxCountRule = maxCountRule;
                return this;
            }

            public ApplicationVersionLifecycleConfigProperty build() {
                return new Jsii.Proxy(this.maxAgeRule, this.maxCountRule, null);
            }
        }
    }

    public static interface ApplicationResourceLifecycleConfigProperty
    extends JsiiSerializable {
        public String getServiceRole();

        public Object getVersionLifecycleConfig();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String serviceRole;
            private Object versionLifecycleConfig;

            public Builder serviceRole(String serviceRole) {
                this.serviceRole = serviceRole;
                return this;
            }

            public Builder versionLifecycleConfig(IResolvable versionLifecycleConfig) {
                this.versionLifecycleConfig = versionLifecycleConfig;
                return this;
            }

            public Builder versionLifecycleConfig(ApplicationVersionLifecycleConfigProperty versionLifecycleConfig) {
                this.versionLifecycleConfig = versionLifecycleConfig;
                return this;
            }

            public ApplicationResourceLifecycleConfigProperty build() {
                return new Jsii.Proxy(this.serviceRole, this.versionLifecycleConfig, null);
            }
        }
    }
}

