package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * A CloudFormation `AWS::ElasticBeanstalk::Environment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:35:33.575Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticbeanstalk.$Module.class, fqn = "@aws-cdk/aws-elasticbeanstalk.CfnEnvironment")
public class CfnEnvironment extends software.amazon.awscdk.core.CfnResource {

    protected CfnEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ElasticBeanstalk::Environment`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnEnvironment(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrEndpointUrl() {
        return this.jsiiGet("attrEndpointUrl", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-elasticbeanstalk-environment-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApplicationName() {
        return this.jsiiGet("applicationName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.ApplicationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-applicationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationName(final java.lang.String value) {
        this.jsiiSet("applicationName", java.util.Objects.requireNonNull(value, "applicationName is required"));
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCnamePrefix() {
        return this.jsiiGet("cnamePrefix", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.CNAMEPrefix`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-cnameprefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCnamePrefix(final java.lang.String value) {
        this.jsiiSet("cnamePrefix", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getEnvironmentName() {
        return this.jsiiGet("environmentName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.EnvironmentName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnvironmentName(final java.lang.String value) {
        this.jsiiSet("environmentName", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getOptionSettings() {
        return this.jsiiGet("optionSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOptionSettings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.OptionSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-optionsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOptionSettings(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("optionSettings", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getPlatformArn() {
        return this.jsiiGet("platformArn", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.PlatformArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setPlatformArn(final java.lang.String value) {
        this.jsiiSet("platformArn", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getSolutionStackName() {
        return this.jsiiGet("solutionStackName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.SolutionStackName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-solutionstackname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setSolutionStackName(final java.lang.String value) {
        this.jsiiSet("solutionStackName", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getTemplateName() {
        return this.jsiiGet("templateName", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.TemplateName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-templatename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTemplateName(final java.lang.String value) {
        this.jsiiSet("templateName", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTier() {
        return this.jsiiGet("tier", java.lang.Object.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTier(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tier", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.Tier`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-tier
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTier(final software.amazon.awscdk.services.elasticbeanstalk.CfnEnvironment.TierProperty value) {
        this.jsiiSet("tier", value);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getVersionLabel() {
        return this.jsiiGet("versionLabel", java.lang.String.class);
    }

    /**
     * `AWS::ElasticBeanstalk::Environment.VersionLabel`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-versionlabel
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVersionLabel(final java.lang.String value) {
        this.jsiiSet("versionLabel", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface OptionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEnvironment.OptionSettingProperty.Namespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNamespace();

        /**
         * `CfnEnvironment.OptionSettingProperty.OptionName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-optionname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getOptionName();

        /**
         * `CfnEnvironment.OptionSettingProperty.ResourceName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-elasticbeanstalk-environment-optionsetting-resourcename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceName();

        /**
         * `CfnEnvironment.OptionSettingProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-option-settings.html#cfn-beanstalk-optionsettings-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link OptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String namespace;
            private java.lang.String optionName;
            private java.lang.String resourceName;
            private java.lang.String value;

            /**
             * Sets the value of Namespace
             * @param namespace `CfnEnvironment.OptionSettingProperty.Namespace`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of OptionName
             * @param optionName `CfnEnvironment.OptionSettingProperty.OptionName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder optionName(java.lang.String optionName) {
                this.optionName = optionName;
                return this;
            }

            /**
             * Sets the value of ResourceName
             * @param resourceName `CfnEnvironment.OptionSettingProperty.ResourceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceName(java.lang.String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnEnvironment.OptionSettingProperty.Value`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public OptionSettingProperty build() {
                return new Jsii$Proxy(namespace, optionName, resourceName, value);
            }
        }

        /**
         * An implementation for {@link OptionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionSettingProperty {
            private final java.lang.String namespace;
            private final java.lang.String optionName;
            private final java.lang.String resourceName;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
                this.optionName = this.jsiiGet("optionName", java.lang.String.class);
                this.resourceName = this.jsiiGet("resourceName", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String namespace, java.lang.String optionName, java.lang.String resourceName, java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
                this.optionName = java.util.Objects.requireNonNull(optionName, "optionName is required");
                this.resourceName = resourceName;
                this.value = value;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public java.lang.String getOptionName() {
                return this.optionName;
            }

            @Override
            public java.lang.String getResourceName() {
                return this.resourceName;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("namespace", om.valueToTree(this.getNamespace()));
                obj.set("optionName", om.valueToTree(this.getOptionName()));
                if (this.getResourceName() != null) {
                    obj.set("resourceName", om.valueToTree(this.getResourceName()));
                }
                if (this.getValue() != null) {
                    obj.set("value", om.valueToTree(this.getValue()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionSettingProperty.Jsii$Proxy that = (OptionSettingProperty.Jsii$Proxy) o;

                if (!namespace.equals(that.namespace)) return false;
                if (!optionName.equals(that.optionName)) return false;
                if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public int hashCode() {
                int result = this.namespace.hashCode();
                result = 31 * result + (this.optionName.hashCode());
                result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEnvironment.TierProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnEnvironment.TierProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnEnvironment.TierProperty.Version`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment-tier.html#cfn-beanstalk-env-tier-version
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link TierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String type;
            private java.lang.String version;

            /**
             * Sets the value of Name
             * @param name `CfnEnvironment.TierProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnEnvironment.TierProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of Version
             * @param version `CfnEnvironment.TierProperty.Version`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TierProperty build() {
                return new Jsii$Proxy(name, type, version);
            }
        }

        /**
         * An implementation for {@link TierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TierProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.version = this.jsiiGet("version", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String name, java.lang.String type, java.lang.String version) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = name;
                this.type = type;
                this.version = version;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getName() != null) {
                    obj.set("name", om.valueToTree(this.getName()));
                }
                if (this.getType() != null) {
                    obj.set("type", om.valueToTree(this.getType()));
                }
                if (this.getVersion() != null) {
                    obj.set("version", om.valueToTree(this.getVersion()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TierProperty.Jsii$Proxy that = (TierProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
}
