package software.amazon.awscdk.appdelivery;

/**
 * A class to deploy a stack that is part of a CDK App, using CodePipeline. This composite Action takes care of preparing and executing a CloudFormation ChangeSet.
 * 
 * It currently does *not* support stacks that make use of ``Asset``s, and
 * requires the deployed stack is in the same account and region where the
 * CodePipeline is hosted.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.3 (build 26aa77c)", date = "2019-11-12T00:10:16.081Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.appdelivery.$Module.class, fqn = "@aws-cdk/app-delivery.PipelineDeployStackAction")
public class PipelineDeployStackAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.IAction {

    protected PipelineDeployStackAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineDeployStackAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PipelineDeployStackAction(final software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add policy statements to the role deploying the stack.
     * 
     * This role is passed to CloudFormation and must have the IAM permissions
     * necessary to deploy the stack or you can grant this role `adminPermissions`
     * by using that option during creation. If you do not grant
     * `adminPermissions` you need to identify the proper statements to add to
     * this role based on the CloudFormation Resources in your stack.
     * 
     * EXPERIMENTAL
     * 
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToDeploymentRolePolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToDeploymentRolePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * EXPERIMENTAL
     * 
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.codepipeline.ActionConfig bind(final software.amazon.awscdk.core.Construct scope, final software.amazon.awscdk.services.codepipeline.IStage stage, final software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.codepipeline.ActionConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * EXPERIMENTAL
     * 
     * @param name This parameter is required.
     * @param target
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.events.Rule onStateChange(final java.lang.String name, final software.amazon.awscdk.services.events.IRuleTarget target, final software.amazon.awscdk.services.events.RuleProps options) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, options });
    }

    /**
     * EXPERIMENTAL
     * 
     * @param name This parameter is required.
     * @param target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.events.Rule onStateChange(final java.lang.String name, final software.amazon.awscdk.services.events.IRuleTarget target) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
    }

    /**
     * EXPERIMENTAL
     * 
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.events.Rule onStateChange(final java.lang.String name) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.codepipeline.ActionProperties getActionProperties() {
        return this.jsiiGet("actionProperties", software.amazon.awscdk.services.codepipeline.ActionProperties.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.iam.IRole getDeploymentRole() {
        return this.jsiiGet("deploymentRole", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.appdelivery.PipelineDeployStackAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps.Builder();
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param adminPermissions Whether to grant admin permissions to CloudFormation while deploying this template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminPermissions(final java.lang.Boolean adminPermissions) {
            this.props.adminPermissions(adminPermissions);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param input The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(final software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.props.input(input);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param stack The CDK stack to be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stack(final software.amazon.awscdk.core.Stack stack) {
            this.props.stack(stack);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param capabilities Acknowledge certain changes made as part of deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder capabilities(final java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param changeSetName The name to use when creating a ChangeSet for the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changeSetName(final java.lang.String changeSetName) {
            this.props.changeSetName(changeSetName);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param createChangeSetRunOrder The runOrder for the CodePipeline action creating the ChangeSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createChangeSetRunOrder(final java.lang.Number createChangeSetRunOrder) {
            this.props.createChangeSetRunOrder(createChangeSetRunOrder);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param executeChangeSetRunOrder The runOrder for the CodePipeline action executing the ChangeSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeChangeSetRunOrder(final java.lang.Number executeChangeSetRunOrder) {
            this.props.executeChangeSetRunOrder(executeChangeSetRunOrder);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param role IAM role to assume when deploying changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.appdelivery.PipelineDeployStackAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.appdelivery.PipelineDeployStackAction build() {
            return new software.amazon.awscdk.appdelivery.PipelineDeployStackAction(
                this.props.build()
            );
        }
    }
}
