/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.appdelivery;

import java.util.List;
import software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineDeployStackActionProps
extends JsiiSerializable {
    public Boolean getAdminPermissions();

    public Artifact getInput();

    public Stack getStack();

    public List<CloudFormationCapabilities> getCapabilities();

    public String getChangeSetName();

    public Number getCreateChangeSetRunOrder();

    public Number getExecuteChangeSetRunOrder();

    public IRole getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean adminPermissions;
        private Artifact input;
        private Stack stack;
        private List<CloudFormationCapabilities> capabilities;
        private String changeSetName;
        private Number createChangeSetRunOrder;
        private Number executeChangeSetRunOrder;
        private IRole role;

        public Builder adminPermissions(Boolean adminPermissions) {
            this.adminPermissions = adminPermissions;
            return this;
        }

        public Builder input(Artifact input) {
            this.input = input;
            return this;
        }

        public Builder stack(Stack stack) {
            this.stack = stack;
            return this;
        }

        public Builder capabilities(List<CloudFormationCapabilities> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public Builder createChangeSetRunOrder(Number createChangeSetRunOrder) {
            this.createChangeSetRunOrder = createChangeSetRunOrder;
            return this;
        }

        public Builder executeChangeSetRunOrder(Number executeChangeSetRunOrder) {
            this.executeChangeSetRunOrder = executeChangeSetRunOrder;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public PipelineDeployStackActionProps build() {
            return new Jsii.Proxy(this.adminPermissions, this.input, this.stack, this.capabilities, this.changeSetName, this.createChangeSetRunOrder, this.executeChangeSetRunOrder, this.role, null);
        }
    }
}

