package software.amazon.awscdk.appdelivery;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:45:24.718Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PipelineDeployStackActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to grant admin permissions to CloudFormation while deploying this template.
     * 
     * Setting this to `true` affects the defaults for `role` and `capabilities`, if you
     * don't specify any alternatives.
     * 
     * The default role that will be created for you will have admin (i.e., `*`)
     * permissions on all resources, and the deployment will have named IAM
     * capabilities (i.e., able to create all IAM resources).
     * 
     * This is a shorthand that you can use if you fully trust the templates that
     * are deployed in this pipeline. If you want more fine-grained permissions,
     * use `addToRolePolicy` and `capabilities` to control what the CloudFormation
     * deployment is allowed to do.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getAdminPermissions();

    /**
     * The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.codepipeline.Artifact getInput();

    /**
     * The CDK stack to be deployed.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.core.Stack getStack();

    /**
     * Acknowledge certain changes made as part of deployment.
     * 
     * For stacks that contain certain resources, explicit acknowledgement that AWS CloudFormation
     * might create or update those resources. For example, you must specify AnonymousIAM if your
     * stack template contains AWS Identity and Access Management (IAM) resources. For more
     * information
     * 
     * Default: [AnonymousIAM, AutoExpand], unless `adminPermissions` is true
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> getCapabilities();

    /**
     * The name to use when creating a ChangeSet for the stack.
     * 
     * Default: CDK-CodePipeline-ChangeSet
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getChangeSetName();

    /**
     * The runOrder for the CodePipeline action creating the ChangeSet.
     * 
     * Default: 1
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getCreateChangeSetRunOrder();

    /**
     * The runOrder for the CodePipeline action executing the ChangeSet.
     * 
     * Default: ``createChangeSetRunOrder + 1``
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getExecuteChangeSetRunOrder();

    /**
     * IAM role to assume when deploying changes.
     * 
     * If not specified, a fresh role is created. The role is created with zero
     * permissions unless `adminPermissions` is true, in which case the role will have
     * admin permissions.
     * 
     * Default: A fresh role with admin or no permissions (depending on the value of `adminPermissions`).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.IRole getRole();

    /**
     * @return a {@link Builder} of {@link PipelineDeployStackActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineDeployStackActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.Boolean adminPermissions;
        private software.amazon.awscdk.services.codepipeline.Artifact input;
        private software.amazon.awscdk.core.Stack stack;
        private java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities;
        private java.lang.String changeSetName;
        private java.lang.Number createChangeSetRunOrder;
        private java.lang.Number executeChangeSetRunOrder;
        private software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of AdminPermissions
         * @param adminPermissions Whether to grant admin permissions to CloudFormation while deploying this template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminPermissions(java.lang.Boolean adminPermissions) {
            this.adminPermissions = adminPermissions;
            return this;
        }

        /**
         * Sets the value of Input
         * @param input The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of Stack
         * @param stack The CDK stack to be deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stack(software.amazon.awscdk.core.Stack stack) {
            this.stack = stack;
            return this;
        }

        /**
         * Sets the value of Capabilities
         * @param capabilities Acknowledge certain changes made as part of deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder capabilities(java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        /**
         * Sets the value of ChangeSetName
         * @param changeSetName The name to use when creating a ChangeSet for the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changeSetName(java.lang.String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        /**
         * Sets the value of CreateChangeSetRunOrder
         * @param createChangeSetRunOrder The runOrder for the CodePipeline action creating the ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createChangeSetRunOrder(java.lang.Number createChangeSetRunOrder) {
            this.createChangeSetRunOrder = createChangeSetRunOrder;
            return this;
        }

        /**
         * Sets the value of ExecuteChangeSetRunOrder
         * @param executeChangeSetRunOrder The runOrder for the CodePipeline action executing the ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeChangeSetRunOrder(java.lang.Number executeChangeSetRunOrder) {
            this.executeChangeSetRunOrder = executeChangeSetRunOrder;
            return this;
        }

        /**
         * Sets the value of Role
         * @param role IAM role to assume when deploying changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineDeployStackActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public PipelineDeployStackActionProps build() {
            return new Jsii$Proxy(adminPermissions, input, stack, capabilities, changeSetName, createChangeSetRunOrder, executeChangeSetRunOrder, role);
        }
    }

    /**
     * An implementation for {@link PipelineDeployStackActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineDeployStackActionProps {
        private final java.lang.Boolean adminPermissions;
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final software.amazon.awscdk.core.Stack stack;
        private final java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities;
        private final java.lang.String changeSetName;
        private final java.lang.Number createChangeSetRunOrder;
        private final java.lang.Number executeChangeSetRunOrder;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.adminPermissions = this.jsiiGet("adminPermissions", java.lang.Boolean.class);
            this.input = this.jsiiGet("input", software.amazon.awscdk.services.codepipeline.Artifact.class);
            this.stack = this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
            this.capabilities = this.jsiiGet("capabilities", java.util.List.class);
            this.changeSetName = this.jsiiGet("changeSetName", java.lang.String.class);
            this.createChangeSetRunOrder = this.jsiiGet("createChangeSetRunOrder", java.lang.Number.class);
            this.executeChangeSetRunOrder = this.jsiiGet("executeChangeSetRunOrder", java.lang.Number.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean adminPermissions, software.amazon.awscdk.services.codepipeline.Artifact input, software.amazon.awscdk.core.Stack stack, java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities, java.lang.String changeSetName, java.lang.Number createChangeSetRunOrder, java.lang.Number executeChangeSetRunOrder, software.amazon.awscdk.services.iam.IRole role) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adminPermissions = java.util.Objects.requireNonNull(adminPermissions, "adminPermissions is required");
            this.input = java.util.Objects.requireNonNull(input, "input is required");
            this.stack = java.util.Objects.requireNonNull(stack, "stack is required");
            this.capabilities = capabilities;
            this.changeSetName = changeSetName;
            this.createChangeSetRunOrder = createChangeSetRunOrder;
            this.executeChangeSetRunOrder = executeChangeSetRunOrder;
            this.role = role;
        }

        @Override
        public java.lang.Boolean getAdminPermissions() {
            return this.adminPermissions;
        }

        @Override
        public software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public software.amazon.awscdk.core.Stack getStack() {
            return this.stack;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public java.lang.String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public java.lang.Number getCreateChangeSetRunOrder() {
            return this.createChangeSetRunOrder;
        }

        @Override
        public java.lang.Number getExecuteChangeSetRunOrder() {
            return this.executeChangeSetRunOrder;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("adminPermissions", om.valueToTree(this.getAdminPermissions()));
            obj.set("input", om.valueToTree(this.getInput()));
            obj.set("stack", om.valueToTree(this.getStack()));
            if (this.getCapabilities() != null) {
                obj.set("capabilities", om.valueToTree(this.getCapabilities()));
            }
            if (this.getChangeSetName() != null) {
                obj.set("changeSetName", om.valueToTree(this.getChangeSetName()));
            }
            if (this.getCreateChangeSetRunOrder() != null) {
                obj.set("createChangeSetRunOrder", om.valueToTree(this.getCreateChangeSetRunOrder()));
            }
            if (this.getExecuteChangeSetRunOrder() != null) {
                obj.set("executeChangeSetRunOrder", om.valueToTree(this.getExecuteChangeSetRunOrder()));
            }
            if (this.getRole() != null) {
                obj.set("role", om.valueToTree(this.getRole()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineDeployStackActionProps.Jsii$Proxy that = (PipelineDeployStackActionProps.Jsii$Proxy) o;

            if (!adminPermissions.equals(that.adminPermissions)) return false;
            if (!input.equals(that.input)) return false;
            if (!stack.equals(that.stack)) return false;
            if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) return false;
            if (this.changeSetName != null ? !this.changeSetName.equals(that.changeSetName) : that.changeSetName != null) return false;
            if (this.createChangeSetRunOrder != null ? !this.createChangeSetRunOrder.equals(that.createChangeSetRunOrder) : that.createChangeSetRunOrder != null) return false;
            if (this.executeChangeSetRunOrder != null ? !this.executeChangeSetRunOrder.equals(that.executeChangeSetRunOrder) : that.executeChangeSetRunOrder != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public int hashCode() {
            int result = this.adminPermissions.hashCode();
            result = 31 * result + (this.input.hashCode());
            result = 31 * result + (this.stack.hashCode());
            result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
            result = 31 * result + (this.changeSetName != null ? this.changeSetName.hashCode() : 0);
            result = 31 * result + (this.createChangeSetRunOrder != null ? this.createChangeSetRunOrder.hashCode() : 0);
            result = 31 * result + (this.executeChangeSetRunOrder != null ? this.executeChangeSetRunOrder.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
