package software.amazon.awscdk.appdelivery;

/**
 * A class to deploy a stack that is part of a CDK App, using CodePipeline. This composite Action takes care of preparing and executing a CloudFormation ChangeSet.
 * 
 * It currently does *not* support stacks that make use of ``Asset``s, and
 * requires the deployed stack is in the same account and region where the
 * CodePipeline is hosted.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:54:06.499Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.appdelivery.$Module.class, fqn = "@aws-cdk/app-delivery.PipelineDeployStackAction")
public class PipelineDeployStackAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.IAction {
    protected PipelineDeployStackAction(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PipelineDeployStackAction(final software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add policy statements to the role deploying the stack.
     * 
     * This role is passed to CloudFormation and must have the IAM permissions
     * necessary to deploy the stack or you can grant this role `adminPermissions`
     * by using that option during creation. If you do not grant
     * `adminPermissions` you need to identify the proper statements to add to
     * this role based on the CloudFormation Resources in your stack.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToDeploymentRolePolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToDeploymentRolePolicy", Void.class, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.codepipeline.ActionConfig bind(final software.amazon.awscdk.core.Construct scope, final software.amazon.awscdk.services.codepipeline.IStage stage, final software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.codepipeline.ActionConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.events.Rule onStateChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IRuleTarget target, @javax.annotation.Nullable final software.amazon.awscdk.services.events.RuleProps options) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, options });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.events.Rule onStateChange(final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.events.IRuleTarget target) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.events.Rule onStateChange(final java.lang.String name) {
        return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.codepipeline.ActionProperties getActionProperties() {
        return this.jsiiGet("actionProperties", software.amazon.awscdk.services.codepipeline.ActionProperties.class);
    }

    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.services.iam.IRole getDeploymentRole() {
        return this.jsiiGet("deploymentRole", software.amazon.awscdk.services.iam.IRole.class);
    }
}
