/**
 * <h2>Continuous Integration / Continuous Delivery for CDK Applications</h2>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This library includes a <em>CodePipeline</em> composite Action for deploying AWS CDK Applications.</p>
 * <p>This module is part of the <a href="https://github.com/awslabs/aws-cdk">AWS Cloud Development Kit</a> project.</p>
 * <h3>Limitations</h3>
 * <p>The construct library in it's current form has the following limitations:</p>
 * <ol>
 * <li>It can only deploy stacks that are hosted in the same AWS account and region as the <em>CodePipeline</em> is.</li>
 * <li>Stacks that make use of <code>Asset</code>s cannot be deployed successfully.</li>
 * </ol>
 * <h3>Getting Started</h3>
 * <p>In order to add the <code>PipelineDeployStackAction</code> to your <em>CodePipeline</em>, you need to have a <em>CodePipeline</em> artifact that
 * contains the result of invoking <code>cdk synth -o &lt;dir&gt;</code> on your <em>CDK App</em>. You can for example achieve this using a
 * <em>CodeBuild</em> project.</p>
 * <p>The example below defines a <em>CDK App</em> that contains 3 stacks:</p>
 * <ul>
 * <li><code>CodePipelineStack</code> manages the <em>CodePipeline</em> resources, and self-updates before deploying any other stack</li>
 * <li><code>ServiceStackA</code> and <code>ServiceStackB</code> are service infrastructure stacks, and need to be deployed in this order</li>
 * </ul>
 * <pre><code>  ┏━━━━━━━━━━━━━━━━┓  ┏━━━━━━━━━━━━━━━━┓  ┏━━━━━━━━━━━━━━━━━┓  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
 *   ┃     Source     ┃  ┃     Build      ┃  ┃  Self-Update    ┃  ┃             Deploy              ┃
 *   ┃                ┃  ┃                ┃  ┃                 ┃  ┃                                 ┃
 *   ┃ ┌────────────┐ ┃  ┃ ┌────────────┐ ┃  ┃ ┌─────────────┐ ┃  ┃ ┌─────────────┐ ┌─────────────┐ ┃
 *   ┃ │   GitHub   ┣━╋━━╋━▶ CodeBuild  ┣━╋━━╋━▶Deploy Stack ┣━╋━━╋━▶Deploy Stack ┣━▶Deploy Stack │ ┃
 *   ┃ │            │ ┃  ┃ │            │ ┃  ┃ │PipelineStack│ ┃  ┃ │ServiceStackA│ │ServiceStackB│ ┃
 *   ┃ └────────────┘ ┃  ┃ └────────────┘ ┃  ┃ └─────────────┘ ┃  ┃ └─────────────┘ └─────────────┘ ┃
 *   ┗━━━━━━━━━━━━━━━━┛  ┗━━━━━━━━━━━━━━━━┛  ┗━━━━━━━━━━━━━━━━━┛  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
 * </code></pre>
 * <h4><code>index.ts</code></h4>
 * <pre><code class="language-typescript">import codebuild = require('@aws-cdk/aws-codebuild');
 * import codepipeline = require('@aws-cdk/aws-codepipeline');
 * import codepipeline_actions = require('@aws-cdk/aws-codepipeline-actions');
 * import cdk = require('@aws-cdk/core');
 * import cicd = require('@aws-cdk/app-delivery');
 * 
 * const app = new cdk.App();
 * 
 * // We define a stack that contains the CodePipeline
 * const pipelineStack = new cdk.Stack(app, 'PipelineStack');
 * const pipeline = new codepipeline.Pipeline(pipelineStack, 'CodePipeline', {
 *   // Mutating a CodePipeline can cause the currently propagating state to be
 *   // &quot;lost&quot;. Ensure we re-run the latest change through the pipeline after it's
 *   // been mutated so we're sure the latest state is fully deployed through.
 *   restartExecutionOnUpdate: true,
 *   /* ... *{@literal /}
 * });
 * 
 * // Configure the CodePipeline source - where your CDK App's source code is hosted
 * const sourceOutput = new codepipeline.Artifact();
 * const source = new codepipeline_actions.GitHubSourceAction({
 *   actionName: 'GitHub',
 *   output: sourceOutput,
 *   /* ... *{@literal /}
 * });
 * pipeline.addStage({
 *   stageName: 'source',
 *   actions: [source],
 * });
 * 
 * const project = new codebuild.PipelineProject(pipelineStack, 'CodeBuild', {
 *   /**
 *   * Choose an environment configuration that meets your use case.
 *   * For NodeJS, this might be:
 *   *
 *   * environment: {
 *   *   buildImage: codebuild.LinuxBuildImage.UBUNTU_14_04_NODEJS_10_1_0,
 *   * },
 *   *{@literal /}
 * });
 * const synthesizedApp = new codepipeline.Artifact();
 * const buildAction = new codepipeline_actions.CodeBuildAction({
 *   actionName: 'CodeBuild',
 *   project,
 *   input: sourceOutput,
 *   outputs: [synthesizedApp],
 * });
 * pipeline.addStage({
 *   stageName: 'build',
 *   actions: [buildAction],
 * });
 * 
 * // Optionally, self-update the pipeline stack
 * const selfUpdateStage = pipeline.addStage({ stageName: 'SelfUpdate' });
 * selfUpdateStage.addAction(new cicd.PipelineDeployStackAction({
 *   stack: pipelineStack,
 *   input: synthesizedApp,
 *   adminPermissions: true,
 * }));
 * 
 * // Now add our service stacks
 * const deployStage = pipeline.addStage({ stageName: 'Deploy' });
 * const serviceStackA = new MyServiceStackA(app, 'ServiceStackA', { /* ... *{@literal /} });
 * // Add actions to deploy the stacks in the deploy stage:
 * const deployServiceAAction = new cicd.PipelineDeployStackAction({
 *   stack: serviceStackA,
 *   input: synthesizedApp,
 *   // See the note below for details about this option.
 *   adminPermissions: false,
 * });
 * deployStage.addAction(deployServiceAAction);
 * // Add the necessary permissions for you service deploy action. This role is
 * // is passed to CloudFormation and needs the permissions necessary to deploy
 * // stack. Alternatively you can enable [Administrator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_job-functions.html#jf_administrator) permissions above,
 * // users should understand the privileged nature of this role.
 * deployServiceAAction.addToRolePolicy(new iam.PolicyStatement({
 *     actions: ['service:SomeAction'],
 *     resources: [myResource.myResourceArn],
 *     // add more Action(s) and/or Resource(s) here, as needed
 * }));
 * 
 * const serviceStackB = new MyServiceStackB(app, 'ServiceStackB', { /* ... *{@literal /} });
 * deployStage.addAction(new cicd.PipelineDeployStackAction({
 *   stack: serviceStackB,
 *   input: synthesizedApp,
 *   createChangeSetRunOrder: 998,
 *   adminPermissions: true, // no need to modify the role with admin
 * }));
 * </code></pre>
 * <h4><code>buildspec.yml</code></h4>
 * <p>The repository can contain a file at the root level named <code>buildspec.yml</code>, or
 * you can in-line the buildspec. Note that <code>buildspec.yaml</code> is not compatible.</p>
 * <p>For example, a <em>TypeScript</em> or <em>Javascript</em> CDK App can add the following <code>buildspec.yml</code>
 * at the root of the repository:</p>
 * <pre><code class="language-yml">version: 0.2
 * phases:
 *   install:
 *     commands:
 *       # Installs the npm dependencies as defined by the `package.json` file
 *       # present in the root directory of the package
 *       # (`cdk init app --language=typescript` would have created one for you)
 *       - npm install
 *   build:
 *     commands:
 *       # Builds the CDK App so it can be synthesized
 *       - npm run build
 *       # Synthesizes the CDK App and puts the resulting artifacts into `dist`
 *       - npm run cdk synth -- -o dist
 * artifacts:
 *   # The output artifact is all the files in the `dist` directory
 *   base-directory: dist
 *   files: '**{@literal /}*'
 * </code></pre>
 * <p>The <code>PipelineDeployStackAction</code> expects it's <code>input</code> to contain the result of
 * synthesizing a CDK App using the <code>cdk synth -o &lt;directory&gt;</code>.</p>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.appdelivery;
