/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.appdelivery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineDeployStackActionProps
extends JsiiSerializable {
    public Boolean getAdminPermissions();

    public Artifact getInput();

    public Stack getStack();

    public List<CloudFormationCapabilities> getCapabilities();

    public String getChangeSetName();

    public Number getCreateChangeSetRunOrder();

    public Number getExecuteChangeSetRunOrder();

    public IRole getRole();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean _adminPermissions;
        private Artifact _input;
        private Stack _stack;
        @Nullable
        private List<CloudFormationCapabilities> _capabilities;
        @Nullable
        private String _changeSetName;
        @Nullable
        private Number _createChangeSetRunOrder;
        @Nullable
        private Number _executeChangeSetRunOrder;
        @Nullable
        private IRole _role;

        public Builder withAdminPermissions(Boolean value) {
            this._adminPermissions = Objects.requireNonNull(value, "adminPermissions is required");
            return this;
        }

        public Builder withInput(Artifact value) {
            this._input = Objects.requireNonNull(value, "input is required");
            return this;
        }

        public Builder withStack(Stack value) {
            this._stack = Objects.requireNonNull(value, "stack is required");
            return this;
        }

        public Builder withCapabilities(@Nullable List<CloudFormationCapabilities> value) {
            this._capabilities = value;
            return this;
        }

        public Builder withChangeSetName(@Nullable String value) {
            this._changeSetName = value;
            return this;
        }

        public Builder withCreateChangeSetRunOrder(@Nullable Number value) {
            this._createChangeSetRunOrder = value;
            return this;
        }

        public Builder withExecuteChangeSetRunOrder(@Nullable Number value) {
            this._executeChangeSetRunOrder = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public PipelineDeployStackActionProps build() {
            return new PipelineDeployStackActionProps(){
                private final Boolean $adminPermissions;
                private final Artifact $input;
                private final Stack $stack;
                @Nullable
                private final List<CloudFormationCapabilities> $capabilities;
                @Nullable
                private final String $changeSetName;
                @Nullable
                private final Number $createChangeSetRunOrder;
                @Nullable
                private final Number $executeChangeSetRunOrder;
                @Nullable
                private final IRole $role;
                {
                    this.$adminPermissions = Objects.requireNonNull(_adminPermissions, "adminPermissions is required");
                    this.$input = Objects.requireNonNull(_input, "input is required");
                    this.$stack = Objects.requireNonNull(_stack, "stack is required");
                    this.$capabilities = _capabilities;
                    this.$changeSetName = _changeSetName;
                    this.$createChangeSetRunOrder = _createChangeSetRunOrder;
                    this.$executeChangeSetRunOrder = _executeChangeSetRunOrder;
                    this.$role = _role;
                }

                @Override
                public Boolean getAdminPermissions() {
                    return this.$adminPermissions;
                }

                @Override
                public Artifact getInput() {
                    return this.$input;
                }

                @Override
                public Stack getStack() {
                    return this.$stack;
                }

                @Override
                public List<CloudFormationCapabilities> getCapabilities() {
                    return this.$capabilities;
                }

                @Override
                public String getChangeSetName() {
                    return this.$changeSetName;
                }

                @Override
                public Number getCreateChangeSetRunOrder() {
                    return this.$createChangeSetRunOrder;
                }

                @Override
                public Number getExecuteChangeSetRunOrder() {
                    return this.$executeChangeSetRunOrder;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("adminPermissions", om.valueToTree((Object)this.getAdminPermissions()));
                    obj.set("input", om.valueToTree((Object)this.getInput()));
                    obj.set("stack", om.valueToTree((Object)this.getStack()));
                    if (this.getCapabilities() != null) {
                        obj.set("capabilities", om.valueToTree(this.getCapabilities()));
                    }
                    if (this.getChangeSetName() != null) {
                        obj.set("changeSetName", om.valueToTree((Object)this.getChangeSetName()));
                    }
                    if (this.getCreateChangeSetRunOrder() != null) {
                        obj.set("createChangeSetRunOrder", om.valueToTree((Object)this.getCreateChangeSetRunOrder()));
                    }
                    if (this.getExecuteChangeSetRunOrder() != null) {
                        obj.set("executeChangeSetRunOrder", om.valueToTree((Object)this.getExecuteChangeSetRunOrder()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    return obj;
                }
            };
        }
    }
}

