package software.amazon.awscdk.services.autoscalingplans;

/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:47.277Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan")
public class CfnScalingPlan extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnScalingPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScalingPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::AutoScalingPlans::ScalingPlan`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnScalingPlan(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrScalingPlanName() {
        return this.jsiiGet("attrScalingPlanName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrScalingPlanVersion() {
        return this.jsiiGet("attrScalingPlanVersion", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getApplicationSource() {
        return this.jsiiGet("applicationSource", java.lang.Object.class);
    }

    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationSource(final software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty value) {
        this.jsiiSet("applicationSource", java.util.Objects.requireNonNull(value, "applicationSource is required"));
    }

    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApplicationSource(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("applicationSource", java.util.Objects.requireNonNull(value, "applicationSource is required"));
    }

    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getScalingInstructions() {
        return this.jsiiGet("scalingInstructions", java.lang.Object.class);
    }

    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setScalingInstructions(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("scalingInstructions", java.util.Objects.requireNonNull(value, "scalingInstructions is required"));
    }

    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setScalingInstructions(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("scalingInstructions", java.util.Objects.requireNonNull(value, "scalingInstructions is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.ApplicationSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApplicationSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.ApplicationSourceProperty.CloudFormationStackARN`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-cloudformationstackarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getCloudFormationStackArn() {
            return null;
        }

        /**
         * `CfnScalingPlan.ApplicationSourceProperty.TagFilters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-tagfilters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApplicationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String cloudFormationStackArn;
            private java.lang.Object tagFilters;

            /**
             * Sets the value of CloudFormationStackArn
             * @param cloudFormationStackArn `CfnScalingPlan.ApplicationSourceProperty.CloudFormationStackARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cloudFormationStackArn(java.lang.String cloudFormationStackArn) {
                this.cloudFormationStackArn = cloudFormationStackArn;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnScalingPlan.ApplicationSourceProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(software.amazon.awscdk.core.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of TagFilters
             * @param tagFilters `CfnScalingPlan.ApplicationSourceProperty.TagFilters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder tagFilters(java.util.List<java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApplicationSourceProperty build() {
                return new Jsii$Proxy(cloudFormationStackArn, tagFilters);
            }
        }

        /**
         * An implementation for {@link ApplicationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationSourceProperty {
            private final java.lang.String cloudFormationStackArn;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudFormationStackArn = this.jsiiGet("cloudFormationStackArn", java.lang.String.class);
                this.tagFilters = this.jsiiGet("tagFilters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String cloudFormationStackArn, final java.lang.Object tagFilters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudFormationStackArn = cloudFormationStackArn;
                this.tagFilters = tagFilters;
            }

            @Override
            public java.lang.String getCloudFormationStackArn() {
                return this.cloudFormationStackArn;
            }

            @Override
            public java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudFormationStackArn() != null) {
                    data.set("cloudFormationStackArn", om.valueToTree(this.getCloudFormationStackArn()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.ApplicationSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationSourceProperty.Jsii$Proxy that = (ApplicationSourceProperty.Jsii$Proxy) o;

                if (this.cloudFormationStackArn != null ? !this.cloudFormationStackArn.equals(that.cloudFormationStackArn) : that.cloudFormationStackArn != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public int hashCode() {
                int result = this.cloudFormationStackArn != null ? this.cloudFormationStackArn.hashCode() : 0;
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedLoadMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CustomizedLoadMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.MetricName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-metricname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMetricName();

        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Namespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNamespace();

        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Statistic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-statistic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatistic();

        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Dimensions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-dimensions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDimensions() {
            return null;
        }

        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Unit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-unit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String metricName;
            private java.lang.String namespace;
            private java.lang.String statistic;
            private java.lang.Object dimensions;
            private java.lang.String unit;

            /**
             * Sets the value of MetricName
             * @param metricName `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.MetricName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of Namespace
             * @param namespace `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Namespace`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of Statistic
             * @param statistic `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Statistic`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of Dimensions
             * @param dimensions `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Dimensions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dimensions(software.amazon.awscdk.core.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of Dimensions
             * @param dimensions `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Dimensions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dimensions(java.util.List<java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of Unit
             * @param unit `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Unit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedLoadMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CustomizedLoadMetricSpecificationProperty build() {
                return new Jsii$Proxy(metricName, namespace, statistic, dimensions, unit);
            }
        }

        /**
         * An implementation for {@link CustomizedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedLoadMetricSpecificationProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.Object dimensions;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = this.jsiiGet("metricName", java.lang.String.class);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
                this.statistic = this.jsiiGet("statistic", java.lang.String.class);
                this.dimensions = this.jsiiGet("dimensions", java.lang.Object.class);
                this.unit = this.jsiiGet("unit", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String metricName, final java.lang.String namespace, final java.lang.String statistic, final java.lang.Object dimensions, final java.lang.String unit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
                this.statistic = java.util.Objects.requireNonNull(statistic, "statistic is required");
                this.dimensions = dimensions;
                this.unit = unit;
            }

            @Override
            public java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("statistic", om.valueToTree(this.getStatistic()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedLoadMetricSpecificationProperty.Jsii$Proxy that = (CustomizedLoadMetricSpecificationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                if (!statistic.equals(that.statistic)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.statistic.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.CustomizedScalingMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizedScalingMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CustomizedScalingMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.MetricName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-metricname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getMetricName();

        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Namespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-namespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getNamespace();

        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Statistic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-statistic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatistic();

        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Dimensions`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-dimensions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDimensions() {
            return null;
        }

        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Unit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-unit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String metricName;
            private java.lang.String namespace;
            private java.lang.String statistic;
            private java.lang.Object dimensions;
            private java.lang.String unit;

            /**
             * Sets the value of MetricName
             * @param metricName `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.MetricName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of Namespace
             * @param namespace `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Namespace`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of Statistic
             * @param statistic `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Statistic`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of Dimensions
             * @param dimensions `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Dimensions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dimensions(software.amazon.awscdk.core.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of Dimensions
             * @param dimensions `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Dimensions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dimensions(java.util.List<java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of Unit
             * @param unit `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Unit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizedScalingMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CustomizedScalingMetricSpecificationProperty build() {
                return new Jsii$Proxy(metricName, namespace, statistic, dimensions, unit);
            }
        }

        /**
         * An implementation for {@link CustomizedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizedScalingMetricSpecificationProperty {
            private final java.lang.String metricName;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.Object dimensions;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = this.jsiiGet("metricName", java.lang.String.class);
                this.namespace = this.jsiiGet("namespace", java.lang.String.class);
                this.statistic = this.jsiiGet("statistic", java.lang.String.class);
                this.dimensions = this.jsiiGet("dimensions", java.lang.Object.class);
                this.unit = this.jsiiGet("unit", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String metricName, final java.lang.String namespace, final java.lang.String statistic, final java.lang.Object dimensions, final java.lang.String unit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(metricName, "metricName is required");
                this.namespace = java.util.Objects.requireNonNull(namespace, "namespace is required");
                this.statistic = java.util.Objects.requireNonNull(statistic, "statistic is required");
                this.dimensions = dimensions;
                this.unit = unit;
            }

            @Override
            public java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                data.set("statistic", om.valueToTree(this.getStatistic()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.CustomizedScalingMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizedScalingMetricSpecificationProperty.Jsii$Proxy that = (CustomizedScalingMetricSpecificationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!namespace.equals(that.namespace)) return false;
                if (!statistic.equals(that.statistic)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.statistic.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.MetricDimensionProperty.Name`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getName();

        /**
         * `CfnScalingPlan.MetricDimensionProperty.Value`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-value
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String name;
            private java.lang.String value;

            /**
             * Sets the value of Name
             * @param name `CfnScalingPlan.MetricDimensionProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of Value
             * @param value `CfnScalingPlan.MetricDimensionProperty.Value`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(name, value);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.value = this.jsiiGet("value", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String name, final java.lang.String value) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.value = java.util.Objects.requireNonNull(value, "value is required");
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.String getValue() {
                return this.value;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedLoadMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PredefinedLoadMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.PredefinedLoadMetricType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-predefinedloadmetrictype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPredefinedLoadMetricType();

        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.ResourceLabel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-resourcelabel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String predefinedLoadMetricType;
            private java.lang.String resourceLabel;

            /**
             * Sets the value of PredefinedLoadMetricType
             * @param predefinedLoadMetricType `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.PredefinedLoadMetricType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predefinedLoadMetricType(java.lang.String predefinedLoadMetricType) {
                this.predefinedLoadMetricType = predefinedLoadMetricType;
                return this;
            }

            /**
             * Sets the value of ResourceLabel
             * @param resourceLabel `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.ResourceLabel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedLoadMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PredefinedLoadMetricSpecificationProperty build() {
                return new Jsii$Proxy(predefinedLoadMetricType, resourceLabel);
            }
        }

        /**
         * An implementation for {@link PredefinedLoadMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedLoadMetricSpecificationProperty {
            private final java.lang.String predefinedLoadMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedLoadMetricType = this.jsiiGet("predefinedLoadMetricType", java.lang.String.class);
                this.resourceLabel = this.jsiiGet("resourceLabel", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String predefinedLoadMetricType, final java.lang.String resourceLabel) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedLoadMetricType = java.util.Objects.requireNonNull(predefinedLoadMetricType, "predefinedLoadMetricType is required");
                this.resourceLabel = resourceLabel;
            }

            @Override
            public java.lang.String getPredefinedLoadMetricType() {
                return this.predefinedLoadMetricType;
            }

            @Override
            public java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedLoadMetricType", om.valueToTree(this.getPredefinedLoadMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedLoadMetricSpecificationProperty.Jsii$Proxy that = (PredefinedLoadMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedLoadMetricType.equals(that.predefinedLoadMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public int hashCode() {
                int result = this.predefinedLoadMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.PredefinedScalingMetricSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PredefinedScalingMetricSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface PredefinedScalingMetricSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.PredefinedScalingMetricType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-predefinedscalingmetrictype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPredefinedScalingMetricType();

        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.ResourceLabel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-resourcelabel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getResourceLabel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredefinedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredefinedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String predefinedScalingMetricType;
            private java.lang.String resourceLabel;

            /**
             * Sets the value of PredefinedScalingMetricType
             * @param predefinedScalingMetricType `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.PredefinedScalingMetricType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predefinedScalingMetricType(java.lang.String predefinedScalingMetricType) {
                this.predefinedScalingMetricType = predefinedScalingMetricType;
                return this;
            }

            /**
             * Sets the value of ResourceLabel
             * @param resourceLabel `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.ResourceLabel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceLabel(java.lang.String resourceLabel) {
                this.resourceLabel = resourceLabel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredefinedScalingMetricSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public PredefinedScalingMetricSpecificationProperty build() {
                return new Jsii$Proxy(predefinedScalingMetricType, resourceLabel);
            }
        }

        /**
         * An implementation for {@link PredefinedScalingMetricSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredefinedScalingMetricSpecificationProperty {
            private final java.lang.String predefinedScalingMetricType;
            private final java.lang.String resourceLabel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.predefinedScalingMetricType = this.jsiiGet("predefinedScalingMetricType", java.lang.String.class);
                this.resourceLabel = this.jsiiGet("resourceLabel", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String predefinedScalingMetricType, final java.lang.String resourceLabel) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.predefinedScalingMetricType = java.util.Objects.requireNonNull(predefinedScalingMetricType, "predefinedScalingMetricType is required");
                this.resourceLabel = resourceLabel;
            }

            @Override
            public java.lang.String getPredefinedScalingMetricType() {
                return this.predefinedScalingMetricType;
            }

            @Override
            public java.lang.String getResourceLabel() {
                return this.resourceLabel;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("predefinedScalingMetricType", om.valueToTree(this.getPredefinedScalingMetricType()));
                if (this.getResourceLabel() != null) {
                    data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.PredefinedScalingMetricSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredefinedScalingMetricSpecificationProperty.Jsii$Proxy that = (PredefinedScalingMetricSpecificationProperty.Jsii$Proxy) o;

                if (!predefinedScalingMetricType.equals(that.predefinedScalingMetricType)) return false;
                return this.resourceLabel != null ? this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel == null;
            }

            @Override
            public int hashCode() {
                int result = this.predefinedScalingMetricType.hashCode();
                result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.ScalingInstructionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingInstructionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ScalingInstructionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MaxCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-maxcapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getMaxCapacity();

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MinCapacity`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-mincapacity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getMinCapacity();

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ResourceId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-resourceid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getResourceId();

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalableDimension`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalabledimension
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getScalableDimension();

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ServiceNamespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-servicenamespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getServiceNamespace();

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.TargetTrackingConfigurations`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-targettrackingconfigurations
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getTargetTrackingConfigurations();

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.CustomizedLoadMetricSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-customizedloadmetricspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getCustomizedLoadMetricSpecification() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.DisableDynamicScaling`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-disabledynamicscaling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDisableDynamicScaling() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredefinedLoadMetricSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predefinedloadmetricspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getPredefinedLoadMetricSpecification() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getPredictiveScalingMaxCapacityBehavior() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBuffer`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybuffer
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getPredictiveScalingMaxCapacityBuffer() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getPredictiveScalingMode() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalingPolicyUpdateBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalingpolicyupdatebehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getScalingPolicyUpdateBehavior() {
            return null;
        }

        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScheduledActionBufferTime`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scheduledactionbuffertime
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getScheduledActionBufferTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number maxCapacity;
            private java.lang.Number minCapacity;
            private java.lang.String resourceId;
            private java.lang.String scalableDimension;
            private java.lang.String serviceNamespace;
            private java.lang.Object targetTrackingConfigurations;
            private java.lang.Object customizedLoadMetricSpecification;
            private java.lang.Object disableDynamicScaling;
            private java.lang.Object predefinedLoadMetricSpecification;
            private java.lang.String predictiveScalingMaxCapacityBehavior;
            private java.lang.Number predictiveScalingMaxCapacityBuffer;
            private java.lang.String predictiveScalingMode;
            private java.lang.String scalingPolicyUpdateBehavior;
            private java.lang.Number scheduledActionBufferTime;

            /**
             * Sets the value of MaxCapacity
             * @param maxCapacity `CfnScalingPlan.ScalingInstructionProperty.MaxCapacity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of MinCapacity
             * @param minCapacity `CfnScalingPlan.ScalingInstructionProperty.MinCapacity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Sets the value of ResourceId
             * @param resourceId `CfnScalingPlan.ScalingInstructionProperty.ResourceId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of ScalableDimension
             * @param scalableDimension `CfnScalingPlan.ScalingInstructionProperty.ScalableDimension`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scalableDimension(java.lang.String scalableDimension) {
                this.scalableDimension = scalableDimension;
                return this;
            }

            /**
             * Sets the value of ServiceNamespace
             * @param serviceNamespace `CfnScalingPlan.ScalingInstructionProperty.ServiceNamespace`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder serviceNamespace(java.lang.String serviceNamespace) {
                this.serviceNamespace = serviceNamespace;
                return this;
            }

            /**
             * Sets the value of TargetTrackingConfigurations
             * @param targetTrackingConfigurations `CfnScalingPlan.ScalingInstructionProperty.TargetTrackingConfigurations`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetTrackingConfigurations(software.amazon.awscdk.core.IResolvable targetTrackingConfigurations) {
                this.targetTrackingConfigurations = targetTrackingConfigurations;
                return this;
            }

            /**
             * Sets the value of TargetTrackingConfigurations
             * @param targetTrackingConfigurations `CfnScalingPlan.ScalingInstructionProperty.TargetTrackingConfigurations`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetTrackingConfigurations(java.util.List<java.lang.Object> targetTrackingConfigurations) {
                this.targetTrackingConfigurations = targetTrackingConfigurations;
                return this;
            }

            /**
             * Sets the value of CustomizedLoadMetricSpecification
             * @param customizedLoadMetricSpecification `CfnScalingPlan.ScalingInstructionProperty.CustomizedLoadMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder customizedLoadMetricSpecification(software.amazon.awscdk.core.IResolvable customizedLoadMetricSpecification) {
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of CustomizedLoadMetricSpecification
             * @param customizedLoadMetricSpecification `CfnScalingPlan.ScalingInstructionProperty.CustomizedLoadMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder customizedLoadMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.CustomizedLoadMetricSpecificationProperty customizedLoadMetricSpecification) {
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of DisableDynamicScaling
             * @param disableDynamicScaling `CfnScalingPlan.ScalingInstructionProperty.DisableDynamicScaling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder disableDynamicScaling(java.lang.Boolean disableDynamicScaling) {
                this.disableDynamicScaling = disableDynamicScaling;
                return this;
            }

            /**
             * Sets the value of DisableDynamicScaling
             * @param disableDynamicScaling `CfnScalingPlan.ScalingInstructionProperty.DisableDynamicScaling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder disableDynamicScaling(software.amazon.awscdk.core.IResolvable disableDynamicScaling) {
                this.disableDynamicScaling = disableDynamicScaling;
                return this;
            }

            /**
             * Sets the value of PredefinedLoadMetricSpecification
             * @param predefinedLoadMetricSpecification `CfnScalingPlan.ScalingInstructionProperty.PredefinedLoadMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.core.IResolvable predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of PredefinedLoadMetricSpecification
             * @param predefinedLoadMetricSpecification `CfnScalingPlan.ScalingInstructionProperty.PredefinedLoadMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predefinedLoadMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.PredefinedLoadMetricSpecificationProperty predefinedLoadMetricSpecification) {
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                return this;
            }

            /**
             * Sets the value of PredictiveScalingMaxCapacityBehavior
             * @param predictiveScalingMaxCapacityBehavior `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predictiveScalingMaxCapacityBehavior(java.lang.String predictiveScalingMaxCapacityBehavior) {
                this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior;
                return this;
            }

            /**
             * Sets the value of PredictiveScalingMaxCapacityBuffer
             * @param predictiveScalingMaxCapacityBuffer `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBuffer`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predictiveScalingMaxCapacityBuffer(java.lang.Number predictiveScalingMaxCapacityBuffer) {
                this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer;
                return this;
            }

            /**
             * Sets the value of PredictiveScalingMode
             * @param predictiveScalingMode `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predictiveScalingMode(java.lang.String predictiveScalingMode) {
                this.predictiveScalingMode = predictiveScalingMode;
                return this;
            }

            /**
             * Sets the value of ScalingPolicyUpdateBehavior
             * @param scalingPolicyUpdateBehavior `CfnScalingPlan.ScalingInstructionProperty.ScalingPolicyUpdateBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scalingPolicyUpdateBehavior(java.lang.String scalingPolicyUpdateBehavior) {
                this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior;
                return this;
            }

            /**
             * Sets the value of ScheduledActionBufferTime
             * @param scheduledActionBufferTime `CfnScalingPlan.ScalingInstructionProperty.ScheduledActionBufferTime`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scheduledActionBufferTime(java.lang.Number scheduledActionBufferTime) {
                this.scheduledActionBufferTime = scheduledActionBufferTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingInstructionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ScalingInstructionProperty build() {
                return new Jsii$Proxy(maxCapacity, minCapacity, resourceId, scalableDimension, serviceNamespace, targetTrackingConfigurations, customizedLoadMetricSpecification, disableDynamicScaling, predefinedLoadMetricSpecification, predictiveScalingMaxCapacityBehavior, predictiveScalingMaxCapacityBuffer, predictiveScalingMode, scalingPolicyUpdateBehavior, scheduledActionBufferTime);
            }
        }

        /**
         * An implementation for {@link ScalingInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingInstructionProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;
            private final java.lang.String resourceId;
            private final java.lang.String scalableDimension;
            private final java.lang.String serviceNamespace;
            private final java.lang.Object targetTrackingConfigurations;
            private final java.lang.Object customizedLoadMetricSpecification;
            private final java.lang.Object disableDynamicScaling;
            private final java.lang.Object predefinedLoadMetricSpecification;
            private final java.lang.String predictiveScalingMaxCapacityBehavior;
            private final java.lang.Number predictiveScalingMaxCapacityBuffer;
            private final java.lang.String predictiveScalingMode;
            private final java.lang.String scalingPolicyUpdateBehavior;
            private final java.lang.Number scheduledActionBufferTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = this.jsiiGet("maxCapacity", java.lang.Number.class);
                this.minCapacity = this.jsiiGet("minCapacity", java.lang.Number.class);
                this.resourceId = this.jsiiGet("resourceId", java.lang.String.class);
                this.scalableDimension = this.jsiiGet("scalableDimension", java.lang.String.class);
                this.serviceNamespace = this.jsiiGet("serviceNamespace", java.lang.String.class);
                this.targetTrackingConfigurations = this.jsiiGet("targetTrackingConfigurations", java.lang.Object.class);
                this.customizedLoadMetricSpecification = this.jsiiGet("customizedLoadMetricSpecification", java.lang.Object.class);
                this.disableDynamicScaling = this.jsiiGet("disableDynamicScaling", java.lang.Object.class);
                this.predefinedLoadMetricSpecification = this.jsiiGet("predefinedLoadMetricSpecification", java.lang.Object.class);
                this.predictiveScalingMaxCapacityBehavior = this.jsiiGet("predictiveScalingMaxCapacityBehavior", java.lang.String.class);
                this.predictiveScalingMaxCapacityBuffer = this.jsiiGet("predictiveScalingMaxCapacityBuffer", java.lang.Number.class);
                this.predictiveScalingMode = this.jsiiGet("predictiveScalingMode", java.lang.String.class);
                this.scalingPolicyUpdateBehavior = this.jsiiGet("scalingPolicyUpdateBehavior", java.lang.String.class);
                this.scheduledActionBufferTime = this.jsiiGet("scheduledActionBufferTime", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number maxCapacity, final java.lang.Number minCapacity, final java.lang.String resourceId, final java.lang.String scalableDimension, final java.lang.String serviceNamespace, final java.lang.Object targetTrackingConfigurations, final java.lang.Object customizedLoadMetricSpecification, final java.lang.Object disableDynamicScaling, final java.lang.Object predefinedLoadMetricSpecification, final java.lang.String predictiveScalingMaxCapacityBehavior, final java.lang.Number predictiveScalingMaxCapacityBuffer, final java.lang.String predictiveScalingMode, final java.lang.String scalingPolicyUpdateBehavior, final java.lang.Number scheduledActionBufferTime) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(minCapacity, "minCapacity is required");
                this.resourceId = java.util.Objects.requireNonNull(resourceId, "resourceId is required");
                this.scalableDimension = java.util.Objects.requireNonNull(scalableDimension, "scalableDimension is required");
                this.serviceNamespace = java.util.Objects.requireNonNull(serviceNamespace, "serviceNamespace is required");
                this.targetTrackingConfigurations = java.util.Objects.requireNonNull(targetTrackingConfigurations, "targetTrackingConfigurations is required");
                this.customizedLoadMetricSpecification = customizedLoadMetricSpecification;
                this.disableDynamicScaling = disableDynamicScaling;
                this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
                this.predictiveScalingMaxCapacityBehavior = predictiveScalingMaxCapacityBehavior;
                this.predictiveScalingMaxCapacityBuffer = predictiveScalingMaxCapacityBuffer;
                this.predictiveScalingMode = predictiveScalingMode;
                this.scalingPolicyUpdateBehavior = scalingPolicyUpdateBehavior;
                this.scheduledActionBufferTime = scheduledActionBufferTime;
            }

            @Override
            public java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            public java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public java.lang.String getScalableDimension() {
                return this.scalableDimension;
            }

            @Override
            public java.lang.String getServiceNamespace() {
                return this.serviceNamespace;
            }

            @Override
            public java.lang.Object getTargetTrackingConfigurations() {
                return this.targetTrackingConfigurations;
            }

            @Override
            public java.lang.Object getCustomizedLoadMetricSpecification() {
                return this.customizedLoadMetricSpecification;
            }

            @Override
            public java.lang.Object getDisableDynamicScaling() {
                return this.disableDynamicScaling;
            }

            @Override
            public java.lang.Object getPredefinedLoadMetricSpecification() {
                return this.predefinedLoadMetricSpecification;
            }

            @Override
            public java.lang.String getPredictiveScalingMaxCapacityBehavior() {
                return this.predictiveScalingMaxCapacityBehavior;
            }

            @Override
            public java.lang.Number getPredictiveScalingMaxCapacityBuffer() {
                return this.predictiveScalingMaxCapacityBuffer;
            }

            @Override
            public java.lang.String getPredictiveScalingMode() {
                return this.predictiveScalingMode;
            }

            @Override
            public java.lang.String getScalingPolicyUpdateBehavior() {
                return this.scalingPolicyUpdateBehavior;
            }

            @Override
            public java.lang.Number getScheduledActionBufferTime() {
                return this.scheduledActionBufferTime;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
                data.set("resourceId", om.valueToTree(this.getResourceId()));
                data.set("scalableDimension", om.valueToTree(this.getScalableDimension()));
                data.set("serviceNamespace", om.valueToTree(this.getServiceNamespace()));
                data.set("targetTrackingConfigurations", om.valueToTree(this.getTargetTrackingConfigurations()));
                if (this.getCustomizedLoadMetricSpecification() != null) {
                    data.set("customizedLoadMetricSpecification", om.valueToTree(this.getCustomizedLoadMetricSpecification()));
                }
                if (this.getDisableDynamicScaling() != null) {
                    data.set("disableDynamicScaling", om.valueToTree(this.getDisableDynamicScaling()));
                }
                if (this.getPredefinedLoadMetricSpecification() != null) {
                    data.set("predefinedLoadMetricSpecification", om.valueToTree(this.getPredefinedLoadMetricSpecification()));
                }
                if (this.getPredictiveScalingMaxCapacityBehavior() != null) {
                    data.set("predictiveScalingMaxCapacityBehavior", om.valueToTree(this.getPredictiveScalingMaxCapacityBehavior()));
                }
                if (this.getPredictiveScalingMaxCapacityBuffer() != null) {
                    data.set("predictiveScalingMaxCapacityBuffer", om.valueToTree(this.getPredictiveScalingMaxCapacityBuffer()));
                }
                if (this.getPredictiveScalingMode() != null) {
                    data.set("predictiveScalingMode", om.valueToTree(this.getPredictiveScalingMode()));
                }
                if (this.getScalingPolicyUpdateBehavior() != null) {
                    data.set("scalingPolicyUpdateBehavior", om.valueToTree(this.getScalingPolicyUpdateBehavior()));
                }
                if (this.getScheduledActionBufferTime() != null) {
                    data.set("scheduledActionBufferTime", om.valueToTree(this.getScheduledActionBufferTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.ScalingInstructionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingInstructionProperty.Jsii$Proxy that = (ScalingInstructionProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                if (!minCapacity.equals(that.minCapacity)) return false;
                if (!resourceId.equals(that.resourceId)) return false;
                if (!scalableDimension.equals(that.scalableDimension)) return false;
                if (!serviceNamespace.equals(that.serviceNamespace)) return false;
                if (!targetTrackingConfigurations.equals(that.targetTrackingConfigurations)) return false;
                if (this.customizedLoadMetricSpecification != null ? !this.customizedLoadMetricSpecification.equals(that.customizedLoadMetricSpecification) : that.customizedLoadMetricSpecification != null) return false;
                if (this.disableDynamicScaling != null ? !this.disableDynamicScaling.equals(that.disableDynamicScaling) : that.disableDynamicScaling != null) return false;
                if (this.predefinedLoadMetricSpecification != null ? !this.predefinedLoadMetricSpecification.equals(that.predefinedLoadMetricSpecification) : that.predefinedLoadMetricSpecification != null) return false;
                if (this.predictiveScalingMaxCapacityBehavior != null ? !this.predictiveScalingMaxCapacityBehavior.equals(that.predictiveScalingMaxCapacityBehavior) : that.predictiveScalingMaxCapacityBehavior != null) return false;
                if (this.predictiveScalingMaxCapacityBuffer != null ? !this.predictiveScalingMaxCapacityBuffer.equals(that.predictiveScalingMaxCapacityBuffer) : that.predictiveScalingMaxCapacityBuffer != null) return false;
                if (this.predictiveScalingMode != null ? !this.predictiveScalingMode.equals(that.predictiveScalingMode) : that.predictiveScalingMode != null) return false;
                if (this.scalingPolicyUpdateBehavior != null ? !this.scalingPolicyUpdateBehavior.equals(that.scalingPolicyUpdateBehavior) : that.scalingPolicyUpdateBehavior != null) return false;
                return this.scheduledActionBufferTime != null ? this.scheduledActionBufferTime.equals(that.scheduledActionBufferTime) : that.scheduledActionBufferTime == null;
            }

            @Override
            public int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                result = 31 * result + (this.resourceId.hashCode());
                result = 31 * result + (this.scalableDimension.hashCode());
                result = 31 * result + (this.serviceNamespace.hashCode());
                result = 31 * result + (this.targetTrackingConfigurations.hashCode());
                result = 31 * result + (this.customizedLoadMetricSpecification != null ? this.customizedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableDynamicScaling != null ? this.disableDynamicScaling.hashCode() : 0);
                result = 31 * result + (this.predefinedLoadMetricSpecification != null ? this.predefinedLoadMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.predictiveScalingMaxCapacityBehavior != null ? this.predictiveScalingMaxCapacityBehavior.hashCode() : 0);
                result = 31 * result + (this.predictiveScalingMaxCapacityBuffer != null ? this.predictiveScalingMaxCapacityBuffer.hashCode() : 0);
                result = 31 * result + (this.predictiveScalingMode != null ? this.predictiveScalingMode.hashCode() : 0);
                result = 31 * result + (this.scalingPolicyUpdateBehavior != null ? this.scalingPolicyUpdateBehavior.hashCode() : 0);
                result = 31 * result + (this.scheduledActionBufferTime != null ? this.scheduledActionBufferTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.TagFilterProperty.Key`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getKey();

        /**
         * `CfnScalingPlan.TagFilterProperty.Values`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-values
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String key;
            private java.util.List<java.lang.String> values;

            /**
             * Sets the value of Key
             * @param key `CfnScalingPlan.TagFilterProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of Values
             * @param values `CfnScalingPlan.TagFilterProperty.Values`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TagFilterProperty build() {
                return new Jsii$Proxy(key, values);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = this.jsiiGet("key", java.lang.String.class);
                this.values = this.jsiiGet("values", java.util.List.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String key, final java.util.List<java.lang.String> values) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.values = values;
            }

            @Override
            public java.lang.String getKey() {
                return this.key;
            }

            @Override
            public java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.autoscalingplans.$Module.class, fqn = "@aws-cdk/aws-autoscalingplans.CfnScalingPlan.TargetTrackingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetTrackingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface TargetTrackingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.TargetValue`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-targetvalue
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getTargetValue();

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.CustomizedScalingMetricSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-customizedscalingmetricspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getCustomizedScalingMetricSpecification() {
            return null;
        }

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.DisableScaleIn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-disablescalein
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDisableScaleIn() {
            return null;
        }

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.EstimatedInstanceWarmup`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-estimatedinstancewarmup
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getEstimatedInstanceWarmup() {
            return null;
        }

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.PredefinedScalingMetricSpecification`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-predefinedscalingmetricspecification
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getPredefinedScalingMetricSpecification() {
            return null;
        }

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleInCooldown`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleincooldown
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getScaleInCooldown() {
            return null;
        }

        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleOutCooldown`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleoutcooldown
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getScaleOutCooldown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number targetValue;
            private java.lang.Object customizedScalingMetricSpecification;
            private java.lang.Object disableScaleIn;
            private java.lang.Number estimatedInstanceWarmup;
            private java.lang.Object predefinedScalingMetricSpecification;
            private java.lang.Number scaleInCooldown;
            private java.lang.Number scaleOutCooldown;

            /**
             * Sets the value of TargetValue
             * @param targetValue `CfnScalingPlan.TargetTrackingConfigurationProperty.TargetValue`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder targetValue(java.lang.Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            /**
             * Sets the value of CustomizedScalingMetricSpecification
             * @param customizedScalingMetricSpecification `CfnScalingPlan.TargetTrackingConfigurationProperty.CustomizedScalingMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder customizedScalingMetricSpecification(software.amazon.awscdk.core.IResolvable customizedScalingMetricSpecification) {
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of CustomizedScalingMetricSpecification
             * @param customizedScalingMetricSpecification `CfnScalingPlan.TargetTrackingConfigurationProperty.CustomizedScalingMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder customizedScalingMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.CustomizedScalingMetricSpecificationProperty customizedScalingMetricSpecification) {
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of DisableScaleIn
             * @param disableScaleIn `CfnScalingPlan.TargetTrackingConfigurationProperty.DisableScaleIn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of DisableScaleIn
             * @param disableScaleIn `CfnScalingPlan.TargetTrackingConfigurationProperty.DisableScaleIn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder disableScaleIn(software.amazon.awscdk.core.IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            /**
             * Sets the value of EstimatedInstanceWarmup
             * @param estimatedInstanceWarmup `CfnScalingPlan.TargetTrackingConfigurationProperty.EstimatedInstanceWarmup`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder estimatedInstanceWarmup(java.lang.Number estimatedInstanceWarmup) {
                this.estimatedInstanceWarmup = estimatedInstanceWarmup;
                return this;
            }

            /**
             * Sets the value of PredefinedScalingMetricSpecification
             * @param predefinedScalingMetricSpecification `CfnScalingPlan.TargetTrackingConfigurationProperty.PredefinedScalingMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.core.IResolvable predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of PredefinedScalingMetricSpecification
             * @param predefinedScalingMetricSpecification `CfnScalingPlan.TargetTrackingConfigurationProperty.PredefinedScalingMetricSpecification`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder predefinedScalingMetricSpecification(software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.PredefinedScalingMetricSpecificationProperty predefinedScalingMetricSpecification) {
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                return this;
            }

            /**
             * Sets the value of ScaleInCooldown
             * @param scaleInCooldown `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleInCooldown`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scaleInCooldown(java.lang.Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            /**
             * Sets the value of ScaleOutCooldown
             * @param scaleOutCooldown `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleOutCooldown`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder scaleOutCooldown(java.lang.Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetTrackingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public TargetTrackingConfigurationProperty build() {
                return new Jsii$Proxy(targetValue, customizedScalingMetricSpecification, disableScaleIn, estimatedInstanceWarmup, predefinedScalingMetricSpecification, scaleInCooldown, scaleOutCooldown);
            }
        }

        /**
         * An implementation for {@link TargetTrackingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetTrackingConfigurationProperty {
            private final java.lang.Number targetValue;
            private final java.lang.Object customizedScalingMetricSpecification;
            private final java.lang.Object disableScaleIn;
            private final java.lang.Number estimatedInstanceWarmup;
            private final java.lang.Object predefinedScalingMetricSpecification;
            private final java.lang.Number scaleInCooldown;
            private final java.lang.Number scaleOutCooldown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetValue = this.jsiiGet("targetValue", java.lang.Number.class);
                this.customizedScalingMetricSpecification = this.jsiiGet("customizedScalingMetricSpecification", java.lang.Object.class);
                this.disableScaleIn = this.jsiiGet("disableScaleIn", java.lang.Object.class);
                this.estimatedInstanceWarmup = this.jsiiGet("estimatedInstanceWarmup", java.lang.Number.class);
                this.predefinedScalingMetricSpecification = this.jsiiGet("predefinedScalingMetricSpecification", java.lang.Object.class);
                this.scaleInCooldown = this.jsiiGet("scaleInCooldown", java.lang.Number.class);
                this.scaleOutCooldown = this.jsiiGet("scaleOutCooldown", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number targetValue, final java.lang.Object customizedScalingMetricSpecification, final java.lang.Object disableScaleIn, final java.lang.Number estimatedInstanceWarmup, final java.lang.Object predefinedScalingMetricSpecification, final java.lang.Number scaleInCooldown, final java.lang.Number scaleOutCooldown) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetValue = java.util.Objects.requireNonNull(targetValue, "targetValue is required");
                this.customizedScalingMetricSpecification = customizedScalingMetricSpecification;
                this.disableScaleIn = disableScaleIn;
                this.estimatedInstanceWarmup = estimatedInstanceWarmup;
                this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
                this.scaleInCooldown = scaleInCooldown;
                this.scaleOutCooldown = scaleOutCooldown;
            }

            @Override
            public java.lang.Number getTargetValue() {
                return this.targetValue;
            }

            @Override
            public java.lang.Object getCustomizedScalingMetricSpecification() {
                return this.customizedScalingMetricSpecification;
            }

            @Override
            public java.lang.Object getDisableScaleIn() {
                return this.disableScaleIn;
            }

            @Override
            public java.lang.Number getEstimatedInstanceWarmup() {
                return this.estimatedInstanceWarmup;
            }

            @Override
            public java.lang.Object getPredefinedScalingMetricSpecification() {
                return this.predefinedScalingMetricSpecification;
            }

            @Override
            public java.lang.Number getScaleInCooldown() {
                return this.scaleInCooldown;
            }

            @Override
            public java.lang.Number getScaleOutCooldown() {
                return this.scaleOutCooldown;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetValue", om.valueToTree(this.getTargetValue()));
                if (this.getCustomizedScalingMetricSpecification() != null) {
                    data.set("customizedScalingMetricSpecification", om.valueToTree(this.getCustomizedScalingMetricSpecification()));
                }
                if (this.getDisableScaleIn() != null) {
                    data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
                }
                if (this.getEstimatedInstanceWarmup() != null) {
                    data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
                }
                if (this.getPredefinedScalingMetricSpecification() != null) {
                    data.set("predefinedScalingMetricSpecification", om.valueToTree(this.getPredefinedScalingMetricSpecification()));
                }
                if (this.getScaleInCooldown() != null) {
                    data.set("scaleInCooldown", om.valueToTree(this.getScaleInCooldown()));
                }
                if (this.getScaleOutCooldown() != null) {
                    data.set("scaleOutCooldown", om.valueToTree(this.getScaleOutCooldown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-autoscalingplans.CfnScalingPlan.TargetTrackingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetTrackingConfigurationProperty.Jsii$Proxy that = (TargetTrackingConfigurationProperty.Jsii$Proxy) o;

                if (!targetValue.equals(that.targetValue)) return false;
                if (this.customizedScalingMetricSpecification != null ? !this.customizedScalingMetricSpecification.equals(that.customizedScalingMetricSpecification) : that.customizedScalingMetricSpecification != null) return false;
                if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
                if (this.estimatedInstanceWarmup != null ? !this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup != null) return false;
                if (this.predefinedScalingMetricSpecification != null ? !this.predefinedScalingMetricSpecification.equals(that.predefinedScalingMetricSpecification) : that.predefinedScalingMetricSpecification != null) return false;
                if (this.scaleInCooldown != null ? !this.scaleInCooldown.equals(that.scaleInCooldown) : that.scaleInCooldown != null) return false;
                return this.scaleOutCooldown != null ? this.scaleOutCooldown.equals(that.scaleOutCooldown) : that.scaleOutCooldown == null;
            }

            @Override
            public int hashCode() {
                int result = this.targetValue.hashCode();
                result = 31 * result + (this.customizedScalingMetricSpecification != null ? this.customizedScalingMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
                result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
                result = 31 * result + (this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.hashCode() : 0);
                result = 31 * result + (this.scaleInCooldown != null ? this.scaleInCooldown.hashCode() : 0);
                result = 31 * result + (this.scaleOutCooldown != null ? this.scaleOutCooldown.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscalingplans.CfnScalingPlanProps.Builder();
        }

        /**
         * @return {@code this}
         * @param applicationSource `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationSource(final software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan.ApplicationSourceProperty applicationSource) {
            this.props.applicationSource(applicationSource);
            return this;
        }
        /**
         * @return {@code this}
         * @param applicationSource `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder applicationSource(final software.amazon.awscdk.core.IResolvable applicationSource) {
            this.props.applicationSource(applicationSource);
            return this;
        }

        /**
         * @return {@code this}
         * @param scalingInstructions `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder scalingInstructions(final software.amazon.awscdk.core.IResolvable scalingInstructions) {
            this.props.scalingInstructions(scalingInstructions);
            return this;
        }
        /**
         * @return {@code this}
         * @param scalingInstructions `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder scalingInstructions(final java.util.List<java.lang.Object> scalingInstructions) {
            this.props.scalingInstructions(scalingInstructions);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan build() {
            return new software.amazon.awscdk.services.autoscalingplans.CfnScalingPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
