package software.amazon.awscdk.services.apigatewayv2.authorizers.alpha;

/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.*;
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizer;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpUrlIntegration;
 * UserPool userPool = new UserPool(this, "UserPool");
 * HttpUserPoolAuthorizer authorizer = new HttpUserPoolAuthorizer("BooksAuthorizer", userPool);
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-11-14T19:55:23.012Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpUserPoolAuthorizer")
public class HttpUserPoolAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer {

    protected HttpUserPoolAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpUserPoolAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param pool The user pool to use for authorization. This parameter is required.
     * @param props Properties to configure the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpUserPoolAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool pool, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pool, "pool is required"), props });
    }

    /**
     * (experimental) Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param pool The user pool to use for authorization. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpUserPoolAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool pool) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pool, "pool is required") });
    }

    /**
     * (experimental) Bind this authorizer to a specified Http route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id The id of the underlying construct. This parameter is required.
         * @param pool The user pool to use for authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.cognito.IUserPool pool) {
            return new Builder(id, pool);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.IUserPool pool;
        private software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizerProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.cognito.IUserPool pool) {
            this.id = id;
            this.pool = pool;
        }

        /**
         * (experimental) Friendly name of the authorizer.
         * <p>
         * Default: - same value as `id` passed in the constructor
         * <p>
         * @return {@code this}
         * @param authorizerName Friendly name of the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props().authorizerName(authorizerName);
            return this;
        }

        /**
         * (experimental) The identity source for which authorization is requested.
         * <p>
         * Default: ['$request.header.Authorization']
         * <p>
         * @return {@code this}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props().identitySource(identitySource);
            return this;
        }

        /**
         * (experimental) The user pool clients that should be used to authorize requests with the user pool.
         * <p>
         * Default: - a new client will be created for the given user pool
         * <p>
         * @return {@code this}
         * @param userPoolClients The user pool clients that should be used to authorize requests with the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClients(final java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPoolClient> userPoolClients) {
            this.props().userPoolClients(userPoolClients);
            return this;
        }

        /**
         * (experimental) The AWS region in which the user pool is present.
         * <p>
         * Default: - same region as the Route the authorizer is attached to.
         * <p>
         * @return {@code this}
         * @param userPoolRegion The AWS region in which the user pool is present. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolRegion(final java.lang.String userPoolRegion) {
            this.props().userPoolRegion(userPoolRegion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizer build() {
            return new software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizer(
                this.id,
                this.pool,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpUserPoolAuthorizerProps.Builder();
            }
            return this.props;
        }
    }
}
