package software.amazon.awscdk.services.apigatewayv2.authorizers.alpha;

/**
 * (experimental) Authorize WebSocket API Routes with IAM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.WebSocketIamAuthorizer;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.WebSocketLambdaIntegration;
 * // This function handles your connect route
 * Function connectHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "WebSocketApi");
 * webSocketApi.addRoute("$connect", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("Integration", connectHandler))
 *         .authorizer(new WebSocketIamAuthorizer())
 *         .build());
 * // Create an IAM user (identity)
 * User user = new User(this, "User");
 * String webSocketArn = Stack.of(this).formatArn(ArnComponents.builder()
 *         .service("execute-api")
 *         .resource(webSocketApi.getApiId())
 *         .build());
 * // Grant access to the IAM user
 * user.attachInlinePolicy(Policy.Builder.create(this, "AllowInvoke")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("execute-api:Invoke"))
 *                     .effect(Effect.ALLOW)
 *                     .resources(List.of(webSocketArn))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.91.0 (build 1b1f239)", date = "2023-11-13T23:01:16.214Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-authorizers-alpha.WebSocketIamAuthorizer")
public class WebSocketIamAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.alpha.IWebSocketRouteAuthorizer {

    protected WebSocketIamAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketIamAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public WebSocketIamAuthorizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Bind this authorizer to a specified WebSocket route.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteAuthorizerBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.WebSocketRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }
}
