package software.amazon.awscdk.services.apigatewayv2.authorizers.alpha;

/**
 * (experimental) Authorize Http Api routes via a lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizer;
 * import software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaResponseType;
 * import software.amazon.awscdk.services.apigatewayv2.integrations.alpha.HttpUrlIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * HttpLambdaAuthorizer authorizer = HttpLambdaAuthorizer.Builder.create("BooksAuthorizer", authHandler)
 *         .responseTypes(List.of(HttpLambdaResponseType.SIMPLE))
 *         .build();
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.89.0 (build 2f74b3e)", date = "2023-10-26T23:04:40.048Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.$Module.class, fqn = "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpLambdaAuthorizer")
public class HttpLambdaAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.alpha.IHttpRouteAuthorizer {

    protected HttpLambdaAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpLambdaAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Initialize a lambda authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param handler This parameter is required.
     * @param props Properties to configure the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpLambdaAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * (experimental) Initialize a lambda authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public HttpLambdaAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * (experimental) Bind this authorizer to a specified Http route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.alpha.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id The id of the underlying construct. This parameter is required.
         * @param handler This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            return new Builder(id, handler);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizerProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.id = id;
            this.handler = handler;
        }

        /**
         * (experimental) Friendly authorizer name.
         * <p>
         * Default: - same value as `id` passed in the constructor.
         * <p>
         * @return {@code this}
         * @param authorizerName Friendly authorizer name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props().authorizerName(authorizerName);
            return this;
        }

        /**
         * (experimental) The identity source for which authorization is requested.
         * <p>
         * Default: ['$request.header.Authorization']
         * <p>
         * @return {@code this}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props().identitySource(identitySource);
            return this;
        }

        /**
         * (experimental) The types of responses the lambda can return.
         * <p>
         * If HttpLambdaResponseType.SIMPLE is included then
         * response format 2.0 will be used.
         * <p>
         * Default: [HttpLambdaResponseType.IAM]
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html#http-api-lambda-authorizer.payload-format-response</a>
         * @param responseTypes The types of responses the lambda can return. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseTypes(final java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaResponseType> responseTypes) {
            this.props().responseTypes(responseTypes);
            return this;
        }

        /**
         * (experimental) How long APIGateway should cache the results.
         * <p>
         * Max 1 hour.
         * Disable caching by setting this to <code>Duration.seconds(0)</code>.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resultsCacheTtl How long APIGateway should cache the results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resultsCacheTtl(final software.amazon.awscdk.Duration resultsCacheTtl) {
            this.props().resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizer build() {
            return new software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizer(
                this.id,
                this.handler,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.authorizers.alpha.HttpLambdaAuthorizerProps.Builder();
            }
            return this.props;
        }
    }
}
