package com.zn.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.widget.ScrollView;

public class YunControlScrollView extends ScrollView {

	private int mMaxOverDistance = 50;//px
	private Context mContext;
	public YunControlScrollView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.mContext = context;
		initView();

	}
	public YunControlScrollView(Context context) {
		super(context);
		this.mContext = context;
		initView();

	}
	
	@Override
	protected boolean overScrollBy(int deltaX, int deltaY, int scrollX,
			int scrollY, int scrollRangeX, int scrollRangeY,
			int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
		return super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX,
				scrollRangeY, maxOverScrollX, mMaxOverDistance, isTouchEvent);
	}
	
	private void initView(){
		DisplayMetrics metrics = mContext.getResources().getDisplayMetrics();
	    float density = metrics.density;
	    mMaxOverDistance = (int) (density*mMaxOverDistance);
	
	}
}
