package com.zn.view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import com.zn.znutils.R;


/**
 * Created by zn on 2017/7/23.
 */

public class WaittingDialog extends Dialog {
    private Context mContext;
    private TextView title;
    private ProgressWheel progressWheel;
    public WaittingDialog(Context context) {
        super(context);
        mContext = context;
    }
    public WaittingDialog(Context context, int theme) {
        super(context, theme);
        mContext = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        LayoutInflater inflater = LayoutInflater.from(mContext);
        View v = inflater.inflate(R.layout.waitting_dialog_layout, null);// 得到加载view
        title = (TextView)v.findViewById(R.id.loading_title);
        progressWheel = (ProgressWheel) v.findViewById(R.id.progress_wheel);
        setContentView(v);


    }

    public void setLoadingTitle(String title){
        this.title.setText(title);
    }
    public void setBarColor(int color){
        progressWheel.setBarColor(color);
    }
}
