package com.zn.openssl;

import android.content.res.AssetManager;

/**
 * Created by zn on 2017/7/17.
 */

public class OpenSSLTool {
    static{
        System.loadLibrary("encryptdecrypt");
    }

    /**
     * 使用assets中的密钥文件进行加密解密
     * */
    public  native byte[] rsaEncryptWithKeyInAssets(AssetManager ass, String path_key, byte[] data );
    public  native byte[] rsaDecryptWithKeyInAssets( AssetManager ass,String path_key,byte[] data);
    /**
     * 创建RSA密钥对，保存在内存中
     * */
    public  native byte[] createRasKeypairToMem(int keyLen);
    /**
     * 使用保存在内存中的密钥进行加密解密
     * */
    public  native byte[] rsaEncryptWithKeyInMem(byte[] pub_key,byte[] data );
    public  native byte[] rsaDecryptWithKeyInMem(byte[] pri_key,byte[] data);

    /**
     * 创建RSA密钥对，保存在文件中
     * */
    public  native int createRasKeypairToFile(int keyLen);
    /**
     * 使用保存在文件中的密钥进行加密解密
     * */
    public native byte[] rsaEncryptWithKeyInFile(byte[] data);
    public native byte[] rsaDecryptWithKeyInFile(byte[] data);

    /**
     * 使用AES KEY加密解密
     * */
    public native byte[] aesEncodeByte(byte[] input, byte[] key, int input_len, int key_len);
    public native byte[] aesDecryptByte(byte[] input, byte[] key, int input_len, int key_len);

    /**
     * MD5 加密
     * */
    public native String MD5Degist(byte[] in);
}
