package com.zn.easydialogtoast;

import android.content.Context;
import android.text.InputType;
import android.widget.Toast;

import com.afollestad.materialdialogs.MaterialDialog;

import es.dmoral.toasty.Toasty;

/**
 * Created by zn on 2017/12/16.
 */

public class EasyDialogToasyUtils {
    private static final EasyDialogToasyUtils ourInstance = new EasyDialogToasyUtils();

    public static EasyDialogToasyUtils getInstance() {
        return ourInstance;
    }

    private EasyDialogToasyUtils() {
    }

    /**
     * showMsgDialog
     * @param titleResId title of this dialog
     * @param contentResId message detail of this dialog
     * @return MaterialDialog
     * */
    public MaterialDialog showMsgDialog(Context context,int titleResId, int contentResId){
        return new MaterialDialog.Builder(context)
                .title(titleResId)
                .content(contentResId)
                .positiveText(R.string.ok)
                .show();
    }

    /**
     * showMsgDialog
     * @param title title of this dialog
     * @param content message detail of this dialog
     * @return MaterialDialog
     * */
    public MaterialDialog showMsgDialog(Context context,String title, String content){
        return new MaterialDialog.Builder(context)
                .title(title)
                .content(content)
                .positiveText(R.string.ok)
                .show();
    }

    /**
     * showSingleInputDialog
     * @param context
     * @param title  Title
     * @param content  Content
     * @param hint
     * @param prefill
     * @param callback
     *     Event Handler
     * */
    public MaterialDialog showSingleInputDialog(Context context,String title, String content,String hint,
                                          String prefill,MaterialDialog.InputCallback callback) {
        return new MaterialDialog.Builder(context)
                .title(title)
                .content(content)
                .inputType(InputType.TYPE_CLASS_TEXT)
                .input(hint, prefill, callback)
                .show();
    }

    /**
     * showSingleInputDialog
     * @param context
     * @param title  Title
     * @param content  Content
     * @param callback
     *     Event Handler
     * */
    public MaterialDialog showSingleInputDialog(Context context,int title, int content,
                                                MaterialDialog.InputCallback callback) {
        return new MaterialDialog.Builder(context)
                .title(title)
                .content(content)
                .inputType(InputType.TYPE_CLASS_TEXT)
                .input("", "", callback)
                .show();
    }

    /**
     * showLoadingDialog
     * @param context
     * @param title Title
     * @param content
     *     Content
     * */
    public MaterialDialog showLoadingDialog(Context context,String title, String content) {
        return new MaterialDialog.Builder(context)
                .title(title)
                .content(content)
                .progress(true, 0)
                .show();
    }
    /**
     * showLoadingDialog
     * @param context
     * @param title Title
     * @param content
     *     Content
     * */
    public MaterialDialog showLoadingDialog(Context context,int title, int content) {
        return new MaterialDialog.Builder(context)
                .title(title)
                .content(content)
                .progress(true, 0)
                .show();
    }

    /**
     * hideLoadingDialog
     * @param dialog
     * */
    public void hideLoadingDialog(MaterialDialog dialog){
        if (dialog != null)
            dialog.dismiss();
    }

    /**
     * showHandleDialog
     * @param context
     * @param titleResId
     * @param contentId
     * @param Okcallback
     * */
    public MaterialDialog showHandleDialog(Context context,int titleResId, int contentId,
                                           MaterialDialog.SingleButtonCallback Okcallback) {
        return new MaterialDialog.Builder(context)
                .title(titleResId)
                .content(contentId)
                .positiveText(R.string.ok)
                .negativeText(R.string.cancel)
                .onPositive(Okcallback)
                .show();
    }

    /**
     * showHandleDialog
     * @param context
     * @param title
     * @param content
     * @param Okcallback
     * */
    public MaterialDialog showHandleDialog(Context context,String title, String content,
                                           MaterialDialog.SingleButtonCallback Okcallback) {
        return new MaterialDialog.Builder(context)
                .title(title)
                .content(content)
                .positiveText(R.string.ok)
                .negativeText(R.string.cancel)
                .onPositive(Okcallback)
                .show();
    }

    /**
     * showErrorToast
     * @param context
     * @param content
     * */
    public void showErrorToast(Context context,String content){
        Toasty.error(context, content, Toast.LENGTH_SHORT, true).show();
    }

    /**
     * showSuccessToast
     * @param content
     * @param context
     * */
    public void showSuccessToast(Context context,String content){
        Toasty.success(context, content, Toast.LENGTH_SHORT, true).show();
    }

    /**
     showInfoToast
     @param context
     @param content
     */
    public void showInfoToast(Context context,String content){
        Toasty.info(context, content, Toast.LENGTH_SHORT, true).show();
    }

    /**
     *
     * showWarningToast
     * @param context
     * @param content */
    public void showWarningToast(Context context, String content){
        Toasty.warning(context, content, Toast.LENGTH_SHORT, true).show();
    }

}
