package com.craftman.cardform;

import android.support.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;

/**
 * The model of a Stripe card token.
 */
public class Token {

    public static final String TYPE_CARD = "card";
    private final String mId;
    private final String mType;
    private final Date mCreated;
    private final boolean mLivemode;
    private final boolean mUsed;
    private final CreditCard mCreditCard;
    /**
     * Constructor that should not be invoked in your code.  This is used by Stripe to
     * create tokens using a Stripe API response.
     */
    public Token(
            String id,
            boolean livemode,
            Date created,
            Boolean used,
            CreditCard creditCard,
            @TokenType String type) {
        mId = id;
        mType = type;
        mCreated = created;
        mLivemode = livemode;
        mCreditCard = creditCard;
        mUsed = used;
    }

    /***
     * @return the {@link Date} this token was created
     */
    public Date getCreated() {
        return mCreated;
    }

    /**
     * @return the {@link #mId} of this token
     */
    public String getId() {
        return mId;
    }

    /**
     * @return {@code true} if this token is valid for a real payment, {@code false} if
     * it is only usable for testing
     */
    public boolean getLivemode() {
        return mLivemode;
    }

    /**
     * @return {@code true} if this token has been used, {@code false} otherwise
     */
    public boolean getUsed() {
        return mUsed;
    }

    /**
     * @return Get the {@link TokenType} of this token.
     */
    @TokenType
    public String getType() {
        return mType;
    }

    /**
     * @return the {@link CreditCard} for this token
     */
    public CreditCard getCard() {
        return mCreditCard;
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({TYPE_CARD})
    public @interface TokenType {
    }
}
