/*
 * Decompiled with CFR 0.152.
 */
package smartthings.ratpack.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import ratpack.exec.Promise;
import ratpack.rx.RxRatpack;
import rx.Observable;
import smartthings.ratpack.cassandra.CassandraService;

public class RxCassandraService {
    private final CassandraService cassandraService;

    @Inject
    public RxCassandraService(CassandraService cassandraService) {
        this.cassandraService = cassandraService;
    }

    public Observable<ResultSet> executeAndReturnResultSet(Statement statement) {
        return RxRatpack.observe((Promise)this.cassandraService.execute(statement));
    }

    public Observable<Row> execute(Statement ... statements) {
        List resultSets = Lists.transform(Arrays.asList(statements), this::executeAndReturnResultSet);
        return Observable.merge((Iterable)resultSets).flatMap(Observable::from);
    }

    public Session getSession() {
        return this.cassandraService.getSession();
    }

    public Cluster getCluster() {
        return this.cassandraService.getCluster();
    }
}

