/*
 * Decompiled with CFR 0.152.
 */
package smartthings.ratpack.cassandra;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.server.Service;
import ratpack.server.StartEvent;
import smartthings.migration.MigrationParameters;
import smartthings.migration.MigrationRunner;
import smartthings.ratpack.cassandra.CassandraModule;

public class CassandraMigrationService
implements Service {
    private Logger logger = LoggerFactory.getLogger(CassandraMigrationService.class);
    CassandraModule.Config config;

    @Inject
    public CassandraMigrationService(CassandraModule.Config config) {
        this.config = config;
    }

    public void onStart(StartEvent event) throws Exception {
        if (this.config.autoMigrate.booleanValue()) {
            this.logger.info("Auto Migrating");
            MigrationRunner migrationRunner = new MigrationRunner();
            MigrationParameters.Builder builder = new MigrationParameters.Builder().setKeyspace(this.config.getKeyspace()).setMigrationsLogFile(this.config.migrationFile);
            String seed = (String)this.config.getSeeds().get(0);
            if (seed.contains(":")) {
                String[] tokens = seed.split(":");
                builder.setHost(tokens[0]);
                builder.setPort(Integer.parseInt(tokens[1]));
            } else {
                builder.setHost(seed);
            }
            if (this.config.getUser() != null) {
                builder.setUsername(this.config.getUser()).setPassword(this.config.getPassword());
            }
            if (this.config.getTruststore() != null) {
                builder.setTruststorePath(this.config.getTruststore().getPath()).setTruststorePassword(this.config.getTruststore().getPassword()).setKeystorePath(this.config.getKeystore().getPath()).setKeystorePassword(this.config.getKeystore().getPassword());
            }
            MigrationParameters parameters = builder.build();
            migrationRunner.run(parameters);
        } else {
            this.logger.info("Not Migrating as the module is configured to not auto migrate.");
        }
    }
}

