/*
 * Decompiled with CFR 0.152.
 */
package smartthings.ratpack.brave;

import brave.sampler.BoundarySampler;
import brave.sampler.RateLimitingSampler;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsyncClientBuilder;
import ratpack.zipkin.ServerTracingModule;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.sqs.SQSSender;

public class ServerTracingConfig {
    private String serviceName;
    private String reporter;
    private float sampleRate;
    private String samplerKind = "BOUNDARY";
    private String queueUrl;
    private String awsAccessKey;
    private String awsSecretAccessKey;
    private String awsRoleArn;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public String getSamplerKind() {
        return this.samplerKind;
    }

    public void setSamplerKind(String samplerKind) {
        this.samplerKind = samplerKind;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretAccessKey() {
        return this.awsSecretAccessKey;
    }

    public void setAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public String getAwsRoleArn() {
        return this.awsRoleArn;
    }

    public void setAwsRoleArn(String awsRoleArn) {
        this.awsRoleArn = awsRoleArn;
    }

    public ServerTracingModule.Config toConfig() {
        return new ServerTracingModule.Config().serviceName(this.serviceName).spanReporterV2(this.getSpanReporter()).sampler(this.samplerKind.equals("RATE_LIMITING") ? RateLimitingSampler.create((int)Math.round(this.sampleRate)) : BoundarySampler.create((float)this.sampleRate));
    }

    private Reporter<Span> getSpanReporter() {
        if ("CONSOLE".equals(this.reporter)) {
            return Reporter.CONSOLE;
        }
        if ("SQS".equals(this.reporter)) {
            return AsyncReporter.builder((Sender)this.getSqsSender()).build();
        }
        return Reporter.NOOP;
    }

    private SQSSender getSqsSender() {
        Object provider = this.awsAccessKey != null && this.awsSecretAccessKey != null ? new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.awsAccessKey, this.awsSecretAccessKey))}) : new DefaultAWSCredentialsProviderChain();
        if (this.awsRoleArn != null) {
            provider = new STSAssumeRoleSessionCredentialsProvider.Builder(this.awsRoleArn, "zipkin").withStsClient((AWSSecurityTokenService)((AWSSecurityTokenServiceAsyncClientBuilder)AWSSecurityTokenServiceAsyncClientBuilder.standard().withCredentials((AWSCredentialsProvider)provider)).build()).build();
        }
        return SQSSender.newBuilder().queueUrl(this.queueUrl).credentialsProvider((AWSCredentialsProvider)provider).build();
    }
}

