package smartthings.ratpack.brave;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import ratpack.path.PathBinding;
import ratpack.zipkin.ServerRequest;
import ratpack.zipkin.SpanNameProvider;

/**
 * SpanNameProvider implementation that uses the Ratpack PathBinding
 * to create an optimized span name by converting
 * "/some/:someId/other/:otherId" to "/some/_someId_/other/_otherId_".
 */
public class PathTokenSpanNameProvider implements SpanNameProvider {

	@Override
	public String spanName(ServerRequest request, Optional<PathBinding> pathBindingOpt) {

		String methodName = request.getMethod().getName().toLowerCase(Locale.ENGLISH);

		if (pathBindingOpt.isPresent()) {
			PathBinding pathBinding = pathBindingOpt.get();

			if (pathBinding.getDescription() != null &&
					pathBinding.getAllTokens() != null &&
					pathBinding.getAllTokens().size() > 0) {

				String template = pathBinding.getDescription();
				Set<String> tokens = pathBinding.getAllTokens().keySet();

				// convert /some/:someId/other/:otherId to /some/_someId_/other/_otherId_
				for (String token : tokens) {
					template = template.replaceAll(":" + token, "_" + token + "_");
				}

				return methodName + " " + template;
			}
		}

		// default is to just return the method name.
		return methodName;
	}

}
