/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.sqs;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import smartthings.brave.sqs.AmazonSQSB3Propagation;
import smartthings.brave.sqs.AmazonSQSClientParser;
import smartthings.brave.sqs.AmazonSQSClientSampler;
import smartthings.brave.sqs.AmazonSQSClientTracing;
import zipkin2.Endpoint;

public class TracingAmazonSQSClient
implements AmazonSQS {
    private final AmazonSQS delegate;
    private final Tracing tracing;
    private final AmazonSQSClientParser parser;
    private final AmazonSQSClientSampler sampler;
    private final String remoteServiceName;
    private final TraceContext.Injector<Map<String, MessageAttributeValue>> injector;
    private final TraceContext.Extractor<Map<String, MessageAttributeValue>> extractor;

    public static AmazonSQS create(Tracing tracing, AmazonSQS delegate) {
        return new TracingAmazonSQSClient(AmazonSQSClientTracing.create(tracing), delegate);
    }

    public static AmazonSQS create(AmazonSQSClientTracing clientTracing, AmazonSQS delegate) {
        return new TracingAmazonSQSClient(clientTracing, delegate);
    }

    private TracingAmazonSQSClient(AmazonSQSClientTracing tracing, AmazonSQS delegate) {
        this.delegate = delegate;
        this.tracing = tracing.tracing();
        this.parser = tracing.parser();
        this.sampler = tracing.sampler();
        String remoteServiceName = tracing.remoteServiceName();
        this.remoteServiceName = remoteServiceName != null ? remoteServiceName : "amazon-sqs";
        this.injector = tracing.tracing().propagation().injector(AmazonSQSB3Propagation.INJECTOR);
        this.extractor = tracing.tracing().propagation().extractor(AmazonSQSB3Propagation.EXTRACTOR);
    }

    public void setEndpoint(String endpoint) {
        this.delegate.setEndpoint(endpoint);
    }

    public void setRegion(Region region) {
        this.delegate.setRegion(region);
    }

    public AddPermissionResult addPermission(AddPermissionRequest addPermissionRequest) {
        return this.delegate.addPermission(addPermissionRequest);
    }

    public AddPermissionResult addPermission(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        return this.addPermission(new AddPermissionRequest(queueUrl, label, aWSAccountIds, actions));
    }

    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        return this.delegate.changeMessageVisibility(changeMessageVisibilityRequest);
    }

    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeMessageVisibility(new ChangeMessageVisibilityRequest(queueUrl, receiptHandle, visibilityTimeout));
    }

    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        return this.delegate.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        return this.changeMessageVisibilityBatch(new ChangeMessageVisibilityBatchRequest(queueUrl, entries));
    }

    public CreateQueueResult createQueue(CreateQueueRequest createQueueRequest) {
        return this.delegate.createQueue(createQueueRequest);
    }

    public CreateQueueResult createQueue(String queueName) {
        return this.createQueue(new CreateQueueRequest(queueName));
    }

    /*
     * Exception decompiling
     */
    public DeleteMessageResult deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) {
        return this.deleteMessage(new DeleteMessageRequest(queueUrl, receiptHandle));
    }

    /*
     * Exception decompiling
     */
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        return this.deleteMessageBatch(new DeleteMessageBatchRequest(queueUrl, entries));
    }

    public DeleteQueueResult deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        return this.delegate.deleteQueue(deleteQueueRequest);
    }

    public DeleteQueueResult deleteQueue(String queueUrl) {
        return this.deleteQueue(new DeleteQueueRequest(queueUrl));
    }

    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        return this.delegate.getQueueAttributes(getQueueAttributesRequest);
    }

    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) {
        return this.getQueueAttributes(new GetQueueAttributesRequest(queueUrl, attributeNames));
    }

    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        return this.delegate.getQueueUrl(getQueueUrlRequest);
    }

    public GetQueueUrlResult getQueueUrl(String queueName) {
        return this.getQueueUrl(new GetQueueUrlRequest(queueName));
    }

    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        return this.delegate.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
    }

    public ListQueuesResult listQueues(ListQueuesRequest listQueuesRequest) {
        return this.delegate.listQueues(listQueuesRequest);
    }

    public ListQueuesResult listQueues() {
        return this.listQueues(new ListQueuesRequest());
    }

    public ListQueuesResult listQueues(String queueNamePrefix) {
        return this.listQueues(new ListQueuesRequest(queueNamePrefix));
    }

    public PurgeQueueResult purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        return this.delegate.purgeQueue(purgeQueueRequest);
    }

    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        receiveMessageRequest = receiveMessageRequest.withMessageAttributeNames((Collection)this.tracing.propagation().keys());
        ReceiveMessageResult result = this.delegate.receiveMessage(receiveMessageRequest);
        for (Message message : result.getMessages()) {
            TraceContextOrSamplingFlags traceContextOrSamplingFlags = this.extractor.extract((Object)message.getMessageAttributes());
            TraceContext ctx = traceContextOrSamplingFlags.context();
            Span oneWay = this.withEndpoint(ctx != null ? this.tracing.tracer().joinSpan(ctx) : this.tracing.tracer().newTrace(traceContextOrSamplingFlags.samplingFlags()));
            oneWay.kind(Span.Kind.SERVER);
            this.parser.response(result, (SpanCustomizer)oneWay);
            oneWay.annotate("receive-" + this.parser.spanName(receiveMessageRequest.getQueueUrl()));
            oneWay.start().flush();
        }
        return result;
    }

    public ReceiveMessageResult receiveMessage(String queueUrl) {
        return this.receiveMessage(new ReceiveMessageRequest(queueUrl));
    }

    public RemovePermissionResult removePermission(RemovePermissionRequest removePermissionRequest) {
        return this.delegate.removePermission(removePermissionRequest);
    }

    public RemovePermissionResult removePermission(String queueUrl, String label) {
        return this.removePermission(new RemovePermissionRequest(queueUrl, label));
    }

    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) {
        Span oneWay = this.withEndpoint(this.tracing.tracer().nextSpan()).kind(Span.Kind.CLIENT).start();
        this.injector.inject(oneWay.context(), (Object)sendMessageRequest.getMessageAttributes());
        this.parser.request(sendMessageRequest, (SpanCustomizer)oneWay);
        SendMessageResult result = this.delegate.sendMessage(sendMessageRequest);
        oneWay.flush();
        return result;
    }

    public SendMessageResult sendMessage(String queueUrl, String messageBody) {
        return this.sendMessage(new SendMessageRequest(queueUrl, messageBody));
    }

    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        LinkedList<Span> oneWays = new LinkedList<Span>();
        for (SendMessageBatchRequestEntry entry : sendMessageBatchRequest.getEntries()) {
            Span s = this.withEndpoint(this.tracing.tracer().nextSpan()).kind(Span.Kind.CLIENT).start();
            this.parser.request(sendMessageBatchRequest, (SpanCustomizer)s);
            this.injector.inject(s.context(), (Object)entry.getMessageAttributes());
            oneWays.add(s);
        }
        SendMessageBatchResult result = this.delegate.sendMessageBatch(sendMessageBatchRequest);
        for (Span oneWay : oneWays) {
            oneWay.flush();
        }
        return result;
    }

    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        return this.sendMessageBatch(new SendMessageBatchRequest(queueUrl, entries));
    }

    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        return this.delegate.setQueueAttributes(setQueueAttributesRequest);
    }

    public SetQueueAttributesResult setQueueAttributes(String queueUrl, Map<String, String> attributes) {
        return this.setQueueAttributes(new SetQueueAttributesRequest(queueUrl, attributes));
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.delegate.getCachedResponseMetadata(request);
    }

    private Span withEndpoint(Span span) {
        if (!span.isNoop()) {
            span.remoteEndpoint(Endpoint.newBuilder().serviceName(this.remoteServiceName).build());
        }
        return span;
    }
}

