/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.sqs;

import brave.SpanCustomizer;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.net.MalformedURLException;
import java.net.URL;

public class AmazonSQSClientParser {
    public void request(SendMessageRequest request, SpanCustomizer customizer) {
        customizer.name(this.spanName(request));
        customizer.tag("sqs.queue_url", request.getQueueUrl());
    }

    public void request(SendMessageBatchRequest request, SpanCustomizer customizer) {
        customizer.name(this.spanName(request));
        customizer.tag("sqs.queue_url", request.getQueueUrl());
    }

    public void request(ReceiveMessageRequest request, SpanCustomizer customizer) {
        customizer.name(this.spanName(request));
        customizer.tag("sqs.queue_url", request.getQueueUrl());
    }

    public void request(DeleteMessageRequest request, SpanCustomizer customizer) {
        customizer.name(this.spanName(request));
        customizer.tag("sqs.queue_url", request.getQueueUrl());
        customizer.tag("sqs.receipt_handle", request.getReceiptHandle());
    }

    public void request(DeleteMessageBatchRequest request, SpanCustomizer customizer) {
        customizer.name(this.spanName(request));
        customizer.tag("sqs.queue_url", request.getQueueUrl());
        for (DeleteMessageBatchRequestEntry entry : request.getEntries()) {
            customizer.tag("sqs.receipt_handle", entry.getReceiptHandle());
        }
    }

    public void response(SendMessageResult result, SpanCustomizer customizer) {
        customizer.tag("sqs.msg_id", result.getMessageId());
    }

    public void response(SendMessageBatchResult result, SpanCustomizer customizer) {
        for (SendMessageBatchResultEntry entry : result.getSuccessful()) {
            customizer.tag("sqs.msg_id", entry.getMessageId());
        }
    }

    public void response(ReceiveMessageResult result, SpanCustomizer customizer) {
        for (Message message : result.getMessages()) {
            customizer.tag("sqs.msg_id", message.getMessageId());
        }
    }

    public void response(DeleteMessageResult result, SpanCustomizer customizer) {
    }

    public void response(DeleteMessageBatchResult result, SpanCustomizer customizer) {
    }

    public void error(Throwable throwable, SpanCustomizer customizer) {
        String message = throwable.getMessage();
        customizer.tag("error", message);
    }

    protected String spanName(SendMessageBatchRequest request) {
        return "send_message_batch-" + this.spanName(request.getQueueUrl());
    }

    protected String spanName(SendMessageRequest request) {
        return "send_message-" + this.spanName(request.getQueueUrl());
    }

    protected String spanName(ReceiveMessageRequest request) {
        return "receive_message-" + this.spanName(request.getQueueUrl());
    }

    protected String spanName(DeleteMessageRequest request) {
        return "delete_message-" + this.spanName(request.getQueueUrl());
    }

    protected String spanName(DeleteMessageBatchRequest request) {
        return "delete_message_batch-" + this.spanName(request.getQueueUrl());
    }

    protected String spanName(String queueUrl) {
        try {
            return this.spanName(new URL(queueUrl));
        }
        catch (MalformedURLException e) {
            return "malformed";
        }
    }

    protected String spanName(URL queueUrl) {
        return queueUrl.getPath().split("/")[2];
    }
}

