/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.mysql;

import com.github.kristofa.brave.ClientRequestAdapter;
import com.github.kristofa.brave.ClientRequestInterceptor;
import com.github.kristofa.brave.ClientResponseAdapter;
import com.github.kristofa.brave.ClientResponseInterceptor;
import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.SpanId;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StatementInterceptorV2;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import smartthings.brave.mysql.DefaultQuerySpanNameProvider;
import smartthings.brave.mysql.QuerySpanNameProvider;

public class MySQLStatementInterceptor
implements StatementInterceptorV2 {
    private static final String SERVICE_NAME_KEY = "tracingServiceName";
    private static ServerClientAndLocalSpanState state;
    private static ClientRequestInterceptor requestInterceptor;
    private static ClientResponseInterceptor responseInterceptor;
    private static QuerySpanNameProvider nameProvider;

    public static void setServerClientAndLocalSpanState(ServerClientAndLocalSpanState state) {
        MySQLStatementInterceptor.state = state;
    }

    public static void setRequestInterceptor(ClientRequestInterceptor requestInterceptor) {
        MySQLStatementInterceptor.requestInterceptor = requestInterceptor;
    }

    public static void setResponseInterceptor(ClientResponseInterceptor responseInterceptor) {
        MySQLStatementInterceptor.responseInterceptor = responseInterceptor;
    }

    public static void setNameProvider(QuerySpanNameProvider provider) {
        nameProvider = provider;
    }

    public ResultSetInternalMethods preProcess(String s, Statement statement, Connection connection) throws SQLException {
        if (requestInterceptor != null && this.isTracing()) {
            Endpoint endpoint;
            try {
                endpoint = MySQLStatementInterceptor.getEndpoint(connection, MySQLStatementInterceptor.getServiceName(connection));
            }
            catch (Exception e) {
                endpoint = null;
            }
            String sqlToLog = statement instanceof PreparedStatement ? ((PreparedStatement)statement).getPreparedSql() : s;
            MySQLRequestAdapter adapter = new MySQLRequestAdapter(nameProvider, sqlToLog, endpoint);
            requestInterceptor.handle((ClientRequestAdapter)adapter);
            Span span = state.getCurrentClientSpan();
            if (span != null) {
                span.addToBinary_annotations(BinaryAnnotation.create((String)"sql.query", (String)sqlToLog, (Endpoint)endpoint));
                span.addToBinary_annotations(BinaryAnnotation.create((String)"sql.readonly", (String)String.valueOf(connection.isReadOnly()), (Endpoint)endpoint));
            }
        }
        return null;
    }

    public ResultSetInternalMethods postProcess(String s, Statement statement, ResultSetInternalMethods resultSetInternalMethods, Connection connection, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, SQLException statementException) throws SQLException {
        if (responseInterceptor != null && this.isTracing()) {
            Endpoint endpoint;
            try {
                endpoint = MySQLStatementInterceptor.getEndpoint(connection, MySQLStatementInterceptor.getServiceName(connection));
            }
            catch (Exception e) {
                endpoint = null;
            }
            Span span = state.getCurrentClientSpan();
            if (span != null) {
                span.addToBinary_annotations(BinaryAnnotation.create((String)"index.used", (String)String.valueOf(!noIndexUsed), (Endpoint)endpoint));
                span.addToBinary_annotations(BinaryAnnotation.create((String)"index.used_good", (String)String.valueOf(!noGoodIndexUsed), (Endpoint)endpoint));
                if (warningCount > 0) {
                    span.addToAnnotations(Annotation.create((long)MySQLStatementInterceptor.currentTimeMicroseconds(), (String)"error", (Endpoint)endpoint));
                    span.addToBinary_annotations(BinaryAnnotation.create((String)"warning.count", (String)String.valueOf(warningCount), (Endpoint)endpoint));
                }
                if (statementException != null) {
                    span.addToBinary_annotations(BinaryAnnotation.create((String)"error", (String)statementException.getMessage(), (Endpoint)endpoint));
                    span.addToBinary_annotations(BinaryAnnotation.create((String)"error.code", (String)String.valueOf(statementException.getErrorCode()), (Endpoint)endpoint));
                }
            }
            MySQLResponseAdapter adapter = new MySQLResponseAdapter();
            responseInterceptor.handle((ClientResponseAdapter)adapter);
        }
        return null;
    }

    private boolean isTracing() {
        return state != null && Boolean.TRUE.equals(state.sample());
    }

    static Endpoint getEndpoint(Connection connection, String serviceName) throws Exception {
        int i;
        InetAddress address = Inet4Address.getByName(connection.getHost());
        int ipv4 = ByteBuffer.wrap(address.getAddress()).getInt();
        String urlStr = connection.getMetaData().getURL();
        URI url = URI.create(urlStr.substring(i = urlStr.indexOf("mysql:")));
        int port = url.getPort() == -1 ? 3306 : url.getPort();
        return Endpoint.create((String)serviceName, (int)ipv4, (int)port);
    }

    static String getServiceName(Connection connection) {
        Properties props = connection.getProperties();
        String serviceName = null;
        if (props != null && ((serviceName = props.getProperty(SERVICE_NAME_KEY)) == null || "".equals(serviceName))) {
            String databaseName;
            serviceName = "mysql";
            try {
                databaseName = connection.getSchema();
            }
            catch (SQLException e) {
                databaseName = null;
            }
            if (databaseName != null && !"".equals(databaseName)) {
                serviceName = serviceName + "-" + databaseName;
            }
        }
        return serviceName;
    }

    private static long currentTimeMicroseconds() {
        return System.currentTimeMillis() * 1000L;
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public void init(Connection connection, Properties properties) throws SQLException {
    }

    public void destroy() {
    }

    static {
        nameProvider = new DefaultQuerySpanNameProvider();
    }

    static class MySQLRequestAdapter
    implements ClientRequestAdapter {
        private final Endpoint endpoint;
        private final QuerySpanNameProvider nameProvider;
        private final String sql;
        private final Collection<KeyValueAnnotation> annotations;

        MySQLRequestAdapter(QuerySpanNameProvider nameProvider, String sql, Endpoint endpoint) {
            this(nameProvider, sql, Collections.emptyList(), endpoint);
        }

        MySQLRequestAdapter(QuerySpanNameProvider nameProvider, String sql, Collection<KeyValueAnnotation> annotations, Endpoint endpoint) {
            this.nameProvider = nameProvider;
            this.sql = sql;
            this.endpoint = endpoint;
            this.annotations = annotations;
        }

        public String getSpanName() {
            return this.nameProvider.getName(this.sql);
        }

        public void addSpanIdToRequest(SpanId spanId) {
        }

        public Collection<KeyValueAnnotation> requestAnnotations() {
            return this.annotations;
        }

        public Endpoint serverAddress() {
            return this.endpoint;
        }
    }

    static class MySQLResponseAdapter
    implements ClientResponseAdapter {
        private final Collection<KeyValueAnnotation> annotations;

        MySQLResponseAdapter() {
            this(Collections.emptyList());
        }

        MySQLResponseAdapter(Collection<KeyValueAnnotation> annotations) {
            this.annotations = annotations;
        }

        public Collection<KeyValueAnnotation> responseAnnotations() {
            return this.annotations;
        }
    }
}

