/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.kafka.producers;

import brave.propagation.TraceContext;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import org.apache.kafka.clients.producer.ProducerRecord;
import smartthings.brave.kafka.EnvelopeProtos;
import smartthings.brave.kafka.producers.BaseTracingProducerInterceptor;

public class DefaultTracingProducerInterceptor<K>
extends BaseTracingProducerInterceptor<K> {
    @Override
    protected ProducerRecord<K, byte[]> getTracedProducerRecord(TraceContext ctx, ProducerRecord<K, byte[]> record) {
        EnvelopeProtos.Envelope.Builder builder = EnvelopeProtos.Envelope.newBuilder().setTraceIdHigh(ctx.traceIdHigh()).setTraceId(ctx.traceId()).setSpanId(ctx.spanId()).setShared(ctx.shared()).setPayload(ByteString.copyFrom((byte[])((byte[])record.value())));
        if (ctx.parentId() != null) {
            builder.setParentId(Int64Value.newBuilder().setValue(ctx.parentId().longValue()).build());
        }
        if (ctx.sampled() != null) {
            builder.setSampled(BoolValue.newBuilder().setValue(ctx.sampled().booleanValue()).build());
        }
        EnvelopeProtos.Envelope envelope = builder.build();
        return new ProducerRecord(record.topic(), record.partition(), record.timestamp(), record.key(), (Object)envelope.toByteArray());
    }
}

