/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.kafka.producers;

import brave.Span;
import brave.Tracing;
import brave.propagation.TraceContext;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import smartthings.brave.kafka.producers.DefaultSpanNameProvider;
import smartthings.brave.kafka.producers.SpanNameProvider;
import zipkin2.Endpoint;

public abstract class BaseTracingProducerInterceptor<K>
implements ProducerInterceptor<K, byte[]> {
    private Tracing tracing;
    private SpanNameProvider<K> nameProvider;
    private Endpoint kafkaEndpoint;

    protected abstract ProducerRecord<K, byte[]> getTracedProducerRecord(TraceContext var1, ProducerRecord<K, byte[]> var2);

    public ProducerRecord<K, byte[]> onSend(ProducerRecord<K, byte[]> record) {
        Span span = this.tracing.tracer().nextSpan().kind(Span.Kind.CLIENT).name(this.nameProvider.spanName(record)).remoteEndpoint(this.kafkaEndpoint);
        if (record.partition() != null) {
            span.tag("Partition", record.partition().toString());
        }
        TraceContext ctx = span.context();
        span.start().flush();
        return this.getTracedProducerRecord(ctx, record);
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        if (configs.get("brave.tracing") == null || !(configs.get("brave.tracing") instanceof Tracing)) {
            throw new ConfigException("brave.tracing", configs.get("brave.tracing"), "Must an be instance of brave.Tracing");
        }
        this.tracing = (Tracing)configs.get("brave.tracing");
        this.nameProvider = configs.get("brave.span.name.provider") != null && configs.get("brave.span.name.provider") instanceof SpanNameProvider ? (SpanNameProvider)configs.get("brave.span.name.provider") : new DefaultSpanNameProvider();
        this.kafkaEndpoint = configs.get("brave.span.remote.endpoint") != null && configs.get("brave.span.remote.endpoint") instanceof Endpoint ? (Endpoint)configs.get("brave.span.remote.endpoint") : Endpoint.newBuilder().serviceName("Kafka").build();
    }
}

