/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.kafka.consumers;

import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import smartthings.brave.kafka.EnvelopeProtos;
import smartthings.brave.kafka.consumers.BaseTracingConsumerInterceptor;
import smartthings.brave.kafka.consumers.ExtractException;
import smartthings.brave.kafka.consumers.TracedConsumerRecord;

public class DefaultTracingConsumerInterceptor<K>
extends BaseTracingConsumerInterceptor<K> {
    @Override
    protected TracedConsumerRecord<K, byte[]> getTracedConsumerRecord(ConsumerRecord<K, byte[]> record) throws ExtractException {
        try {
            EnvelopeProtos.Envelope envelope = EnvelopeProtos.Envelope.parseFrom((byte[])record.value());
            TraceContext.Builder builder = TraceContext.newBuilder().traceIdHigh(envelope.getTraceIdHigh()).traceId(envelope.getTraceId()).spanId(envelope.getSpanId()).shared(envelope.getShared());
            if (envelope.hasSampled()) {
                builder.sampled(Boolean.valueOf(envelope.getSampled().getValue()));
            }
            if (envelope.hasParentId()) {
                builder.parentId(Long.valueOf(envelope.getParentId().getValue()));
            }
            TraceContextOrSamplingFlags traceContextOrSamplingFlags = TraceContextOrSamplingFlags.create((TraceContext.Builder)builder);
            ConsumerRecord originalRecord = new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), record.checksum(), record.serializedKeySize(), record.serializedValueSize(), record.key(), (Object)envelope.getPayload().toByteArray());
            return new TracedConsumerRecord(originalRecord, traceContextOrSamplingFlags);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ExtractException(record, (Throwable)e);
        }
    }
}

