/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.kafka.producers;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContext;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.SpanIdUtils;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import smartthings.brave.kafka.producers.DefaultSpanNameProvider;
import smartthings.brave.kafka.producers.SpanNameProvider;
import zipkin.Endpoint;

public abstract class BaseTracingProducerInterceptor<K>
implements ProducerInterceptor<K, byte[]> {
    private Tracer tracer;
    private ClientTracer clientTracer;
    private SpanNameProvider<K> nameProvider;
    private Endpoint kafkaEndpoint;

    protected abstract ProducerRecord<K, byte[]> getTracedProducerRecord(TraceContext var1, ProducerRecord<K, byte[]> var2);

    public ProducerRecord<K, byte[]> onSend(ProducerRecord<K, byte[]> record) {
        Span span = SpanIdUtils.getNextSpan(this.clientTracer, this.tracer).name(this.nameProvider.spanName(record)).annotate("cs").remoteEndpoint(this.kafkaEndpoint);
        if (record.partition() != null) {
            span.tag("Partition", record.partition().toString());
        }
        TraceContext ctx = span.context();
        span.flush();
        return this.getTracedProducerRecord(ctx, record);
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        if (configs.get("brave.tracer") == null || !(configs.get("brave.tracer") instanceof Tracer)) {
            throw new ConfigException("brave.tracer", configs.get("brave.tracer"), "Must an be instance of brave.Tracer");
        }
        this.tracer = (Tracer)configs.get("brave.tracer");
        this.nameProvider = configs.get("brave.span.name.provider") != null && configs.get("brave.span.name.provider") instanceof SpanNameProvider ? (SpanNameProvider)configs.get("brave.span.name.provider") : new DefaultSpanNameProvider();
        if (configs.get("brave.client.tracer") != null && configs.get("brave.client.tracer") instanceof ClientTracer) {
            this.clientTracer = (ClientTracer)configs.get("brave.client.tracer");
        }
        this.kafkaEndpoint = configs.get("brave.span.remote.endpoint") != null && configs.get("brave.span.remote.endpoint") instanceof Endpoint ? (Endpoint)configs.get("brave.span.remote.endpoint") : Endpoint.builder().serviceName("Kafka").build();
    }
}

