/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContext;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.SpanId;
import com.sun.istack.internal.Nullable;

public class SpanIdUtils {
    public static SpanId traceContextToSpanId(TraceContext traceContext) {
        return new SpanId.Builder().traceIdHigh(traceContext.traceIdHigh()).traceId(traceContext.traceId()).parentId(traceContext.parentId()).spanId(traceContext.spanId()).sampled(traceContext.sampled()).debug(traceContext.debug()).shared(traceContext.shared()).build();
    }

    public static TraceContext spanIdToTraceContext(SpanId spanId) {
        return TraceContext.newBuilder().traceIdHigh(spanId.traceIdHigh).traceId(spanId.traceId).parentId(spanId.nullableParentId()).sampled(spanId.sampled()).spanId(spanId.spanId).shared(spanId.shared).build();
    }

    public static Span getNextSpan(@Nullable ClientTracer clientTracer, Tracer tracer) {
        if (clientTracer != null && clientTracer.maybeParent() != null) {
            SpanId parentSpanId = clientTracer.maybeParent();
            return tracer.newChild(SpanIdUtils.spanIdToTraceContext(parentSpanId));
        }
        return tracer.newTrace();
    }
}

