/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.SpanId;
import com.google.common.base.Optional;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartthings.brave.cassandra.NamedBoundStatement;
import smartthings.brave.cassandra.NamedStatement;
import smartthings.brave.cassandra.TracedSession$$Lambda$1;
import smartthings.brave.cassandra.TracedSession$$Lambda$2;
import smartthings.brave.cassandra.TracedSession$$Lambda$3;
import smartthings.brave.cassandra.TracedSession$$Lambda$4;
import smartthings.brave.cassandra.TracedSession$1$$Lambda$1;
import smartthings.brave.cassandra.TracedSession$1$$Lambda$4;
import smartthings.brave.cassandra.TracedSession$TracedResultSetFuture$$Lambda$1;
import zipkin.internal.Util;

public class TracedSession
extends AbstractInvocationHandler
implements LatencyTracker {
    private static final Logger LOG = LoggerFactory.getLogger(TracedSession.class);
    private final Session target;
    private final Brave brave;
    private final ProtocolVersion version;
    private final String serviceName;
    private final Map<Statement, Span> cache = new ConcurrentHashMap<Statement, Span>();

    public static Session create(Session target, Brave brave, String serviceName) {
        return (Session)Reflection.newProxy(Session.class, (InvocationHandler)((Object)new TracedSession(target, brave, serviceName)));
    }

    private TracedSession(Session target, Brave brave, String serviceName) {
        this.target = (Session)Util.checkNotNull((Object)target, (String)"target");
        this.brave = (Brave)Util.checkNotNull((Object)brave, (String)"brave");
        this.version = target.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        this.serviceName = serviceName;
        target.getCluster().register((LatencyTracker)this);
    }

    public void update(Host host, Statement statement, Exception e, long nanos) {
        this.runWithSpan(statement, TracedSession$$Lambda$1.lambdaFactory$(nanos, e));
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        boolean traceable = this.isTraceable(method, args);
        if (traceable) {
            if (method.getName().equals("executeAsync")) {
                return this.trace(TracedSession$$Lambda$2.lambdaFactory$(this, args), TracedSession.as(args[0], NamedBoundStatement.class));
            }
            if (method.getName().equals("execute")) {
                return this.trace(TracedSession$$Lambda$3.lambdaFactory$(this, args), TracedSession.as(args[0], NamedBoundStatement.class));
            }
        }
        return TracedSession.invokeAndHandleException(method, this.target, args);
    }

    private <T> T trace(Supplier<T> f, NamedBoundStatement statement) {
        if (statement != null) {
            SpanId spanId = this.brave.clientTracer().startNewSpan(statement.getName());
            if (this.version.compareTo((Enum)ProtocolVersion.V4) >= 0) {
                statement.enableTracing();
                statement.setOutgoingPayload(Collections.singletonMap("zipkin", ByteBuffer.wrap(spanId.bytes())));
            }
            this.brave.clientTracer().setClientSent();
            this.brave.clientTracer().submitBinaryAnnotation("cql.query", statement.preparedStatement().getQueryString());
            this.brave.clientTracer().submitBinaryAnnotation("cql.keyspace", statement.preparedStatement().getQueryKeyspace());
            this.brave.clientTracer().submitBinaryAnnotation("cql.read_timeout", String.valueOf(statement.getReadTimeoutMillis()));
            if (statement.getConsistencyLevel() != null) {
                this.brave.clientTracer().submitBinaryAnnotation("cql.consistency_level", statement.getConsistencyLevel().name());
            }
            this.cache.put((Statement)statement, this.brave.clientSpanThreadBinder().getCurrentClientSpan());
            this.brave.clientSpanThreadBinder().setCurrentSpan(null);
        }
        return f.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runWithSpan(Statement statement, boolean finish, Function<Optional<Span>, R> f) {
        Span span = this.cache.get(statement);
        if (span != null) {
            Span previous = this.brave.clientSpanThreadBinder().getCurrentClientSpan();
            this.brave.clientSpanThreadBinder().setCurrentSpan(span);
            try {
                R r = f.apply((Optional<Span>)Optional.of((Object)span));
                return r;
            }
            finally {
                if (finish) {
                    this.cache.remove(statement);
                    this.brave.clientTracer().setClientReceived();
                }
                this.brave.clientSpanThreadBinder().setCurrentSpan(previous);
            }
        }
        return f.apply((Optional<Span>)Optional.absent());
    }

    private <R> R runWithSpan(Statement statement, Function<Optional<Span>, R> f) {
        return this.runWithSpan(statement, false, f);
    }

    private boolean isTraceable(Method method, Object[] args) {
        return args.length > 0 && args[0] instanceof NamedStatement && this.brave.serverSpanThreadBinder().getCurrentServerSpan() != null && this.brave.serverSpanThreadBinder().getCurrentServerSpan().getSpan() != null && ("executeAsync".equals(method.getName()) || "execute".equals(method.getName()));
    }

    private void addErrorAnnotation(Optional<Span> spanOpt, Throwable t) {
        if (spanOpt.isPresent()) {
            Span s = (Span)spanOpt.get();
            Endpoint local = s.getAnnotations().size() > 0 ? ((Annotation)s.getAnnotations().get((int)0)).host : null;
            String message = t.getMessage();
            message = message == null ? "unknown" : message;
            s.addToBinary_annotations(BinaryAnnotation.create((String)"error", (String)message, (Endpoint)local));
        }
    }

    private void addHostAnnotations(Optional<Span> spanOpt, ResultSet result) {
        if (spanOpt.isPresent()) {
            Span s = (Span)spanOpt.get();
            Host host = result.getExecutionInfo().getQueriedHost();
            int ipv4 = ByteBuffer.wrap(host.getAddress().getAddress()).getInt();
            int port = host.getSocketAddress().getPort();
            Endpoint endpoint = Endpoint.builder().serviceName(this.serviceName).ipv4(ipv4).port(port).build();
            String cassandraVersion = TracedSession.getOrDefault(host.getCassandraVersion().getBuildLabel());
            String cassandraDataCenter = TracedSession.getOrDefault(host.getDatacenter());
            String cassandraState = TracedSession.getOrDefault(host.getState());
            String cassandraRack = TracedSession.getOrDefault(host.getRack());
            s.addToBinary_annotations(BinaryAnnotation.create((String)"cql.cassandra_version", (String)cassandraVersion, (Endpoint)endpoint));
            s.addToBinary_annotations(BinaryAnnotation.create((String)"cql.cassandra_data_center", (String)cassandraDataCenter, (Endpoint)endpoint));
            s.addToBinary_annotations(BinaryAnnotation.create((String)"cql.cassandra_rack", (String)cassandraRack, (Endpoint)endpoint));
            s.addToBinary_annotations(BinaryAnnotation.create((String)"cql.cassandra_state", (String)cassandraState, (Endpoint)endpoint));
            StringBuilder triedHosts = new StringBuilder();
            for (Host h : result.getExecutionInfo().getTriedHosts()) {
                triedHosts.append(h.getAddress().getHostAddress()).append(",");
            }
            triedHosts.deleteCharAt(triedHosts.length() - 1);
            s.addToBinary_annotations(BinaryAnnotation.create((String)"cql.cassandra_tried_hosts", (String)triedHosts.toString(), (Endpoint)endpoint));
            s.addToBinary_annotations(BinaryAnnotation.address((String)"sa", (Endpoint)endpoint));
        }
    }

    static String getOrDefault(String value) {
        return TracedSession.getOrDefault(value, "unknown");
    }

    static String getOrDefault(String value, String def) {
        return value == null || "".equals(value) ? def : value;
    }

    static Object invokeAndHandleException(Method method, Object target, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof TracedSession) {
            TracedSession other = (TracedSession)((Object)obj);
            return this.target.equals(other.target);
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public String toString() {
        return this.target.toString();
    }

    public void onRegister(Cluster cluster) {
    }

    public void onUnregister(Cluster cluster) {
    }

    private static <T> T as(Object value, Class<T> t) {
        return (T)(t.isAssignableFrom(value.getClass()) ? value : null);
    }

    /* synthetic */ ResultSet lambda$handleInvocation$3(Object[] args) {
        Statement statement = (Statement)args[0];
        return (ResultSet)this.runWithSpan(statement, true, TracedSession$$Lambda$4.lambdaFactory$(this, statement));
    }

    /* synthetic */ ResultSet lambda$null$2(Statement statement, Optional spanOpt) {
        try {
            ResultSet result = this.target.execute(statement);
            this.addHostAnnotations((Optional<Span>)spanOpt, result);
            return result;
        }
        catch (Exception e) {
            this.addErrorAnnotation((Optional<Span>)spanOpt, e);
            throw e;
        }
    }

    /* synthetic */ ListenableFuture lambda$handleInvocation$1(Object[] args) {
        final Statement statement = (Statement)args[0];
        TracedResultSetFuture future = new TracedResultSetFuture(this.target.executeAsync(statement), this.brave.serverSpanThreadBinder(), this.brave.serverSpanThreadBinder().getCurrentServerSpan());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                TracedSession.this.runWithSpan(statement, true, TracedSession$1$$Lambda$1.lambdaFactory$(this, result));
            }

            public void onFailure(Throwable t) {
                TracedSession.this.runWithSpan(statement, true, TracedSession$1$$Lambda$4.lambdaFactory$(this, t));
            }

            /* synthetic */ Object lambda$onFailure$1(Throwable t, Optional spanOpt) {
                TracedSession.this.addErrorAnnotation((Optional<Span>)spanOpt, t);
                return null;
            }

            /* synthetic */ ResultSet lambda$onSuccess$0(ResultSet result, Optional spanOpt) {
                TracedSession.this.addHostAnnotations((Optional<Span>)spanOpt, result);
                return result;
            }
        });
        return future;
    }

    static /* synthetic */ Optional lambda$update$0(long nanos, Exception e, Optional spanOpt) {
        if (spanOpt.isPresent()) {
            Span s = (Span)spanOpt.get();
            Endpoint local = s.getAnnotations().size() > 0 ? ((Annotation)s.getAnnotations().get((int)0)).host : null;
            long timestamp = s.getTimestamp() + nanos / 1000L;
            if (e != null) {
                s.addToAnnotations(Annotation.create((long)timestamp, (String)"error", (Endpoint)local));
            } else {
                s.addToAnnotations(Annotation.create((long)timestamp, (String)"Latency Update", (Endpoint)local));
            }
        }
        return spanOpt;
    }

    private static class TracedResultSetFuture
    implements ResultSetFuture {
        private final ResultSetFuture delegate;
        private final ServerSpanThreadBinder serverSpanThreadBinder;
        private final ServerSpan currentServerSpan;

        TracedResultSetFuture(ResultSetFuture delegate, ServerSpanThreadBinder serverSpanThreadBinder, ServerSpan currentServerSpan) {
            this.delegate = delegate;
            this.serverSpanThreadBinder = serverSpanThreadBinder;
            this.currentServerSpan = currentServerSpan;
        }

        public ResultSet getUninterruptibly() {
            return this.delegate.getUninterruptibly();
        }

        public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
            return this.delegate.getUninterruptibly(timeout, unit);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public ResultSet get() throws InterruptedException, ExecutionException {
            return (ResultSet)this.delegate.get();
        }

        public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (ResultSet)this.delegate.get(timeout, unit);
        }

        public void addListener(Runnable listener, Executor executor) {
            this.delegate.addListener(TracedSession$TracedResultSetFuture$$Lambda$1.lambdaFactory$(this, listener), executor);
        }

        /* synthetic */ void lambda$addListener$0(Runnable listener) {
            this.serverSpanThreadBinder.setCurrentSpan(this.currentServerSpan);
            try {
                listener.run();
            }
            finally {
                this.serverSpanThreadBinder.setCurrentSpan(null);
            }
        }
    }

    private static interface Supplier<T> {
        public T get();
    }

    private static interface Function<T, R> {
        public R apply(T var1);
    }
}

