/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.cassandra.driver;

import com.datastax.driver.core.PreparedStatement;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import smartthings.brave.cassandra.driver.NamedBoundStatement;
import smartthings.brave.cassandra.driver.NamedStatement;

public final class NamedPreparedStatement
extends AbstractInvocationHandler
implements NamedStatement<NamedPreparedStatement> {
    private final PreparedStatement target;
    private String name;

    public static PreparedStatement from(PreparedStatement statement, String name) {
        return (PreparedStatement)Reflection.newProxy(PreparedStatement.class, (InvocationHandler)((Object)new NamedPreparedStatement(statement, name)));
    }

    private NamedPreparedStatement(PreparedStatement target, String name) {
        this.target = target;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NamedPreparedStatement withName(String name) {
        this.name = name;
        return this;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("bind")) {
            NamedBoundStatement statement = new NamedBoundStatement(this.target).withName(this.name);
            if (args.length == 1) {
                Object[] varargs = (Object[])args[0];
                return statement.bind(varargs);
            }
            return statement;
        }
        try {
            return method.invoke((Object)this.target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw e.getCause();
            }
            throw e;
        }
    }
}

