/*
 * Decompiled with CFR 0.152.
 */
package smartthings.brave.cassandra.driver;

import brave.SpanCustomizer;
import brave.cassandra.driver.CassandraClientParser;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import smartthings.brave.cassandra.driver.NamedStatement;

public class NamedCassandraClientParser
extends CassandraClientParser {
    public void request(Statement statement, SpanCustomizer customizer) {
        super.request(statement, customizer);
        if (statement.getConsistencyLevel() != null) {
            customizer.tag("cassandra.consistency_level", statement.getConsistencyLevel().name());
        }
    }

    public void response(ResultSet resultSet, SpanCustomizer customizer) {
        super.response(resultSet, customizer);
        ExecutionInfo executionInfo = resultSet.getExecutionInfo();
        Host host = executionInfo.getQueriedHost();
        customizer.tag("cassandra.version", this.getOrDefault(host.getCassandraVersion().getBuildLabel()));
        customizer.tag("cassandra.data_center", this.getOrDefault(host.getDatacenter()));
        customizer.tag("cassandra.rack", this.getOrDefault(host.getRack()));
        customizer.tag("cassandra.state", this.getOrDefault(host.getState()));
        StringBuilder triedHosts = new StringBuilder();
        for (Host h : executionInfo.getTriedHosts()) {
            triedHosts.append(h.getAddress().getHostAddress()).append(",");
        }
        triedHosts.deleteCharAt(triedHosts.length() - 1);
        customizer.tag("cassandra.tried_hosts", triedHosts.toString());
    }

    protected String spanName(Statement statement) {
        if (statement instanceof NamedStatement) {
            return ((NamedStatement)statement).getName();
        }
        return super.spanName(statement);
    }

    private String getOrDefault(String value) {
        return this.getOrDefault(value, "unknown");
    }

    private String getOrDefault(String value, String def) {
        if (value != null && !"".equals(value)) {
            return value;
        }
        return def;
    }
}

