/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.ext;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import util.Maybe;

public class SvgImage
extends SymbolType
implements Rule,
Translation {
    static final Log LOG = LogFactory.getLog(SvgImage.class);
    private Mode defaultMode = Mode.inline;

    public SvgImage() {
        super("SVG-Image");
        this.wikiMatcher(new Matcher().string("!svg"));
        this.htmlTranslation(this);
        this.wikiRule(this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol targetList = parser.parseToEnds(-1, SymbolProvider.pathRuleProvider, new SymbolType[]{SymbolType.Newline});
        return new Maybe((Object)current.add(targetList));
    }

    public String toTarget(Translator translator, Symbol symbol) {
        String symContent = symbol.getContent();
        String target = symContent + translator.translate(symbol.childAt(0));
        return this.toTarget(translator, target, symbol);
    }

    public String toTarget(Translator translator, String body, Symbol args) {
        Symbol symbol = this.getPathSymbol(args);
        if (symbol == null) {
            return this.error("Missing image path");
        }
        String line = translator.translate(symbol);
        line = line.replaceAll("\\s+", " ").trim();
        String[] parts = line.split(" ");
        String location = null;
        Mode mode = this.defaultMode;
        if (parts.length > 0) {
            location = parts[0];
        }
        if (parts.length > 1) {
            for (String part : parts) {
                if (!part.contains("mode=")) continue;
                mode = this.parseMode(part);
            }
        }
        return this.inlineSvg(mode, location);
    }

    private Mode parseMode(String s) {
        String mString = null;
        Mode mode = this.defaultMode;
        try {
            mString = s.trim();
            String[] subParts = mString.split("=");
            mode = Enum.valueOf(Mode.class, subParts[1].trim());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Mode not supported: " + mString);
        }
        return mode;
    }

    private Symbol getPathSymbol(Symbol args) {
        if (args.getChildren().size() > 0) {
            return args.childAt(0);
        }
        return null;
    }

    private String inlineSvg(Mode tag, String location) {
        if (location == null) {
            return this.error("Invalid file path: null");
        }
        if (tag.equals((Object)Mode.inline)) {
            String content = this.read(location);
            return tag.toString(content);
        }
        return tag.toString(location);
    }

    private String read(String path) {
        String loc = path.trim();
        if (loc.startsWith("/files")) {
            loc = "FitNesseRoot" + path.trim();
        }
        String content = null;
        File f = new File(loc);
        try {
            content = f.exists() ? this.readFile(f) : this.error("File not found: " + f.getAbsolutePath() + ", path=" + path);
        }
        catch (FileNotFoundException e) {
            content = this.error("File not found: " + loc + ", path=" + path + ", err=" + e.getMessage());
        }
        catch (RuntimeException e) {
            content = this.error("Unable to read: " + loc + ", path=" + path);
        }
        return content;
    }

    private String readFile(File f) throws FileNotFoundException {
        FileReader reader = new FileReader(f);
        BufferedReader r = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        LOG.debug((Object)("Reading file " + f.getAbsolutePath()));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read from stream", e);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {
                LOG.debug((Object)("Exception closing file reader for file " + f.getAbsolutePath()));
            }
        }
        return sb.toString();
    }

    private String error(String string) {
        HtmlTag tag = new HtmlTag("p");
        tag.addAttribute("style", "color:red");
        tag.add(string);
        return tag.htmlInline();
    }

    private static enum Mode {
        inline,
        embed("embed", "src", "type=\"image/svg+xml\""),
        object("object", "data", "type=\"image/svg+xml\""),
        iframe("iframe", "src"),
        img("img", "src"),
        anchor("a", "href");

        private String tag;
        private String srcAttr;
        private String otherAttr;

        public String toString(String stuff) {
            if (this.equals((Object)inline)) {
                return stuff;
            }
            String s = "";
            if (this.otherAttr != null) {
                s = this.otherAttr;
            }
            return "<" + this.tag + " " + this.srcAttr + "=\"" + stuff + "\" " + s + " />";
        }

        private Mode() {
            this(null, null, null);
        }

        private Mode(String tag, String srcAttr) {
            this(tag, srcAttr, null);
        }

        private Mode(String tag, String srcAttr, String otherAttr) {
            this.tag = tag;
            this.srcAttr = srcAttr;
            this.otherAttr = otherAttr;
        }
    }
}

