/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.ext;

import fitnesse.util.Base64;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import smartrics.rest.client.RestData;
import smartrics.rest.fitnesse.fixture.PartsFactory;
import smartrics.rest.fitnesse.fixture.RestFixture;
import smartrics.rest.fitnesse.fixture.ext.MyFixtureListener;
import smartrics.rest.fitnesse.fixture.ext.PictureGenerator;
import smartrics.rest.fitnesse.fixture.ext.SequenceModel;
import smartrics.rest.fitnesse.fixture.support.CellWrapper;
import smartrics.rest.fitnesse.fixture.support.Tools;

public class SlimRestFixtureWithSeq
extends RestFixture {
    public static final String DEFAULT_GRAPH_DIR_PROPERTY_NAME = "restfixture.graphs.dir";
    static final Log LOG = LogFactory.getLog(SlimRestFixtureWithSeq.class);
    private File graphFileDir;
    private String pictureName;
    private String pictureData;
    private Model model;
    private boolean initialised;
    private MyFixtureListener myFixtureListener;
    private Map<String, String> attributes;
    private String format;
    private CellWrapper cell;

    public SlimRestFixtureWithSeq() {
        this.initialised = false;
        LOG.info((Object)"Default ctor");
    }

    public SlimRestFixtureWithSeq(String hostName, String pictureData) {
        super(hostName);
        this.pictureData = pictureData;
        this.initialised = false;
    }

    public SlimRestFixtureWithSeq(String hostName, String configName, String pictureData) {
        super(hostName, configName);
        this.pictureData = pictureData;
        this.initialised = false;
    }

    public SlimRestFixtureWithSeq(PartsFactory partsFactory, String hostName, String configName, String pictureData) {
        super(partsFactory, hostName, configName);
        this.pictureData = pictureData;
        this.initialised = false;
    }

    public void embed() {
        this.cell = this.row.getCell(1);
        byte[] content = PictureGenerator.generate(this.model.toString(), SlimRestFixtureWithSeq.parseAttributes(this.cell.body()), "template.svg", this.format);
        this.cell.body(this.getFormatter().gray("<img src=\"data:image/" + this.format + ";base64," + new String(Base64.encode((byte[])content)) + "\" />"));
    }

    public void setModel(Model model) {
        this.model = model;
    }

    protected void initialize(RestFixture.Runner runner) {
        super.initialize(runner);
        this.initializeFields();
        this.createSequenceModel();
        this.initialised = true;
        String defaultPicsDir = System.getProperty(DEFAULT_GRAPH_DIR_PROPERTY_NAME, "FitNesseRoot/files/restfixture");
        String picsDir = this.getConfig().get(DEFAULT_GRAPH_DIR_PROPERTY_NAME, defaultPicsDir);
        this.graphFileDir = new File(picsDir);
        if (!this.graphFileDir.exists()) {
            if (!this.graphFileDir.mkdirs()) {
                throw new RuntimeException("Unable to create the diagrams destination dir '" + this.graphFileDir.getAbsolutePath() + "'");
            }
            LOG.info((Object)("Created diagrams destination directory '" + this.graphFileDir.getAbsolutePath() + "'"));
        }
        LOG.info((Object)("Generated diagrams directory: '" + this.graphFileDir.getAbsolutePath() + "'"));
        this.myFixtureListener = new MyFixtureListener(new File(this.graphFileDir, this.getPictureName()).getAbsolutePath(), this.model, this.attributes);
        this.setFixtureListener(this.myFixtureListener);
    }

    protected boolean validateState() {
        return this.getBaseUrl() != null && this.pictureData != null;
    }

    protected void notifyInvalidState(boolean state) {
        if (!state) {
            throw new RuntimeException("Both baseUrl and picture data (containing the picture name) need to be passed to the fixture");
        }
    }

    protected void createSequenceModel() {
        if (!this.initialised) {
            LOG.info((Object)"Initialising sequence model");
            this.model = new SequenceModel();
        }
    }

    public List<List<String>> doTable(List<List<String>> rows) {
        List result = super.doTable(rows);
        this.myFixtureListener.tableFinished();
        return result;
    }

    public void setBody() {
        super.setBody();
    }

    public void DELETE() {
        super.DELETE();
        String res = this.getLastRequest().getResource();
        String args = this.getLastRequest().getQuery();
        String ret = "status=" + this.getLastResponse().getStatusCode().toString();
        this.model.delete(res, args, ret);
    }

    public void comment() {
        super.comment();
        CellWrapper messageCell = this.row.getCell(1);
        String body = messageCell.body();
        String plainBody = Tools.fromHtml((String)body).trim();
        this.model.comment(plainBody);
    }

    public void GET() {
        super.GET();
        String res = this.getResource();
        String args = this.getLastRequest().getQuery();
        String ret = "status=" + this.getLastResponse().getStatusCode().toString();
        this.model.get(res, args, ret);
    }

    public void POST() {
        super.POST();
        String res = this.getResource();
        String id = this.getIdFromLocationHeader();
        String result = String.format("id=%s, status=%s", id, this.getLastResponse().getStatusCode().toString());
        String args = this.getLastRequest().getQuery();
        this.model.post(res, args, result);
    }

    public void PUT() {
        super.PUT();
        String res = this.getResource();
        String args = this.getLastRequest().getQuery();
        String ret = "status=" + this.getLastResponse().getStatusCode().toString();
        this.model.put(res, args, ret);
    }

    String getPictureName() {
        return this.pictureName;
    }

    void setFixtureListener(MyFixtureListener l) {
        this.myFixtureListener = l;
    }

    private static String getPictureFormat(String pictureName) {
        int pos = pictureName.indexOf(".");
        if (pos >= 0) {
            return pictureName.substring(pos + 1).toLowerCase();
        }
        throw new IllegalArgumentException("The picture name must terminate with an extension of .svg, .png, .jpg");
    }

    private void initializeFields() {
        if (!this.initialised) {
            String data = this.pictureData;
            LOG.info((Object)("Picture data = " + this.pictureData));
            int[] pos = SlimRestFixtureWithSeq.getPositionOfNextOfTokenOptionallyInDoubleQuotes(data);
            this.pictureName = data.substring(pos[0], pos[1]);
            LOG.info((Object)("Found picture name: " + this.pictureName));
            if (pos[1] < data.length()) {
                data = data.substring(pos[1] + 1);
                this.attributes = SlimRestFixtureWithSeq.parseAttributes(data);
            }
            this.format = SlimRestFixtureWithSeq.getPictureFormat(this.pictureName);
        }
    }

    private static Map<String, String> parseAttributes(String data) {
        int eqPos;
        HashMap<String, String> foundAttributes = new HashMap<String, String>();
        while ((eqPos = data.indexOf("=")) >= 0) {
            String aName = data.substring(0, eqPos);
            LOG.info((Object)("Found attribute name: " + aName));
            data = data.substring(eqPos + 1);
            int[] pos = SlimRestFixtureWithSeq.getPositionOfNextOfTokenOptionallyInDoubleQuotes(data);
            String aVal = data.substring(pos[0], pos[1]);
            LOG.info((Object)("Found attribute val: " + aVal + ", pos[" + pos[0] + ", " + pos[1] + "]"));
            foundAttributes.put(aName, aVal);
            if (data.length() - aVal.length() == 0) break;
            data = data.substring(pos[1] + 1);
        }
        return foundAttributes;
    }

    private static int[] getPositionOfNextOfTokenOptionallyInDoubleQuotes(String data) {
        int end;
        String del = " ";
        int start = 0;
        if (data.trim().startsWith("\"")) {
            del = "\"";
            start = 1;
        }
        if ((end = data.indexOf(del, start + 1)) == -1) {
            end = data.length();
        }
        return new int[]{start, end};
    }

    private String[] guessParts(String res) {
        String[] empty = new String[]{"?", ""};
        if (res == null) {
            return empty;
        }
        String myRes = res.trim();
        if (myRes.isEmpty()) {
            return empty;
        }
        int pos = myRes.lastIndexOf("/");
        if (pos == myRes.length() - 1) {
            pos = -1;
            myRes = myRes.substring(0, myRes.length() - 1);
        }
        String[] parts = new String[2];
        if (pos >= 0) {
            parts[0] = myRes.substring(0, pos);
            parts[1] = myRes.substring(pos + 1);
        } else {
            parts[0] = myRes;
            parts[1] = "";
        }
        return parts;
    }

    private String getIdFromLocationHeader() {
        List list = this.getLastResponse().getHeader("Location");
        String location = "";
        if (list != null && !list.isEmpty()) {
            location = ((RestData.Header)list.get(0)).getValue();
        }
        String[] parts = this.guessParts(location);
        return parts[1];
    }

    private String getResource() {
        String res = this.getLastRequest().getResource();
        if (res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public static interface Model {
        public void delete(String var1, String var2, String var3);

        public void comment(String var1);

        public void get(String var1, String var2, String var3);

        public void post(String var1, String var2, String var3);

        public void put(String var1, String var2, String var3);
    }
}

