/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.ext;

import com.patternity.graphic.behavioral.Message;
import com.patternity.graphic.behavioral.Note;
import com.patternity.graphic.dag.Node;
import com.patternity.graphic.layout.sequence.SequenceLayout;
import java.util.HashMap;
import java.util.Map;
import smartrics.rest.fitnesse.fixture.ext.Resource;
import smartrics.rest.fitnesse.fixture.ext.SlimRestFixtureWithSeq;
import smartrics.rest.fitnesse.fixture.support.Tools;

class SequenceModel
implements SlimRestFixtureWithSeq.Model {
    private Map<String, Resource> resourceToAgentMap;
    private Node root;
    private SequenceLayout layout;
    private static final int DEFAULT_FONT_SIZE = 16;
    private static final int DEFAULT_AGENT_STEP = 150;
    private static final int DEFAULT_TIME_STEP = 25;

    SequenceModel() {
        Message message = new Message(null, null);
        Node root = new Node(message);
        SequenceLayout layout = new SequenceLayout(16);
        layout.setAgentStep(150);
        layout.setTimeStep(25);
        this.root = root;
        this.layout = layout;
        this.resourceToAgentMap = new HashMap<String, Resource>();
    }

    @Override
    public void comment(String text) {
        this.root.add(new Node(new Note(Tools.fromHtml((String)text))));
    }

    @Override
    public void get(String resource, String query, String result) {
        this.message(0, resource, "GET", query, result);
    }

    @Override
    public void post(String resource, String query, String result) {
        this.message(0, resource, "POST", query, result);
    }

    @Override
    public void put(String resource, String query, String result) {
        this.message(0, resource, "PUT", query, result);
    }

    @Override
    public void delete(String resource, String query, String result) {
        this.message(3, resource, "DELETE", query, result);
    }

    public String toString() {
        return this.layout.layout(this.root);
    }

    private void message(int type, String resourceTo, String method, String args, String result) {
        Resource agentTo = this.agentFor(resourceTo);
        String methodSignature = method;
        if (args != null) {
            methodSignature = method + "(" + args + ")";
        }
        String resultString = "";
        if (result != null) {
            resultString = result;
        }
        Message message = new Message(type, agentTo, methodSignature, resultString);
        this.root.add(new Node(message));
    }

    private Resource agentFor(String resource) {
        Resource a = this.resourceToAgentMap.get(resource);
        if (a == null) {
            boolean isActivable = true;
            a = new Resource(resource, true);
            this.resourceToAgentMap.put(resource, a);
        }
        return a;
    }
}

