/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.ext;

import java.util.List;
import smartrics.rest.client.RestData;
import smartrics.rest.fitnesse.fixture.PartsFactory;
import smartrics.rest.fitnesse.fixture.RestFixture;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.HeadersTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.LetHandler;
import smartrics.rest.fitnesse.fixture.support.LetHandlerFactory;
import smartrics.rest.fitnesse.fixture.support.RestDataTypeAdapter;

public class RestScriptFixture
extends RestFixture {
    public RestScriptFixture(String hostName) {
        super(hostName);
        this.initialize();
    }

    public RestScriptFixture(String hostName, String configName) {
        super(hostName, configName);
        this.initialize();
    }

    RestScriptFixture(PartsFactory partsFactory, String hostName, RestFixture.Runner runner) {
        this(partsFactory, hostName, "default");
        this.initialize(runner);
    }

    RestScriptFixture(PartsFactory partsFactory, String hostName, String configName) {
        super(partsFactory, hostName, configName);
    }

    private void initialize() {
        this.initialize(RestFixture.Runner.SLIM);
    }

    public void get(String resourceUrl) {
        this.doMethod("Get", resourceUrl, null);
    }

    public void post(String resourceUrl) {
        this.doMethod("Post", resourceUrl, this.emptifyBody(this.requestBody));
    }

    public void put(String resourceUrl) {
        this.doMethod("Put", resourceUrl, this.emptifyBody(this.requestBody));
    }

    public void delete(String resourceUrl) {
        this.doMethod("Delete", resourceUrl, null);
    }

    public String header(String expr) {
        return this.applyExpressionToLastResponse("header", expr);
    }

    public String body(String expr) {
        return this.applyExpressionToLastResponse("body", expr);
    }

    public String js(String expr) {
        return this.applyExpressionToLastResponse("js", expr);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMultipartFileName(String multipartFileName) {
        this.multipartFileName = multipartFileName;
    }

    public void setMultipartFileParameterName(String multipartFileParameterName) {
        this.multipartFileParameterName = multipartFileParameterName;
    }

    public Integer statusCode() {
        if (this.getLastResponse() == null) {
            return -1;
        }
        return this.getLastResponse().getStatusCode();
    }

    public String responseBody() {
        if (this.getLastResponse() == null) {
            return null;
        }
        return this.getLastResponse().getBody();
    }

    public boolean hasBody(String expected) throws Exception {
        BodyTypeAdapter bodyTypeAdapter = this.createBodyTypeAdapter();
        String actual = this.responseBody();
        return this.equalsWithAdapter(expected, actual, (RestDataTypeAdapter)bodyTypeAdapter);
    }

    public boolean hasBodyUsingType(String expected, String type) throws Exception {
        ContentType ct = ContentType.typeFor((String)type);
        BodyTypeAdapter bodyTypeAdapter = this.createBodyTypeAdapter(ct);
        String actual = this.responseBody();
        return this.equalsWithAdapter(expected, actual, (RestDataTypeAdapter)bodyTypeAdapter);
    }

    public boolean hasHeaders(String expected) throws Exception {
        return this.hasHeader(expected);
    }

    public boolean hasHeader(String expected) throws Exception {
        return this.equalsWithAdapter(expected, this.getResponseHeaders(), (RestDataTypeAdapter)new HeadersTypeAdapter());
    }

    public void setBody(String text) {
        this.requestBody = this.GLOBALS.substitute(text);
    }

    public void setHeaders(String headers) {
        String substitutedHeaders = this.GLOBALS.substitute(headers);
        this.requestHeaders = this.parseHeaders(substitutedHeaders);
    }

    public void setHeader(String header) {
        this.setHeaders(header);
    }

    private boolean equalsWithAdapter(String expected, Object actual, RestDataTypeAdapter typeAdapter) throws Exception {
        typeAdapter.set(actual);
        Object parse = typeAdapter.parse(expected);
        return typeAdapter.equals(parse, actual);
    }

    private String applyExpressionToLastResponse(String type, String expr) {
        LetHandler letHandler = LetHandlerFactory.getHandlerFor((String)type);
        return this.GLOBALS.replaceNull(letHandler.handle(this.getLastResponse(), (Object)this.getNamespaceContext(), expr));
    }

    private List<RestData.Header> getResponseHeaders() {
        if (this.getLastResponse() == null) {
            return null;
        }
        return this.getLastResponse().getHeaders();
    }
}

