/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.ext;

import com.patternity.util.TemplatedWriter;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import smartrics.rest.fitnesse.fixture.ext.SlimRestFixtureWithSeq;

class PictureGenerator {
    private PictureGenerator() {
    }

    public static byte[] generate(String content, Map<String, String> attributes, String svgTemplate, String format) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TemplatedWriter writer = new TemplatedWriter(baos, svgTemplate);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            sb.append(e.getKey()).append("=\"").append(e.getValue()).append("\" ");
        }
        writer.write(content, sb.toString());
        byte[] ret = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException e) {
            SlimRestFixtureWithSeq.LOG.debug((Object)"Exception closing byte array output stream");
        }
        if (format.equals("svg")) {
            return ret;
        }
        Integer w = null;
        String widthString = attributes.get("width");
        if (widthString != null) {
            try {
                w = Integer.parseInt(widthString);
            }
            catch (NumberFormatException e) {
                SlimRestFixtureWithSeq.LOG.debug((Object)("Unable to parse width as integer: " + widthString));
            }
        }
        Integer h = null;
        String heightString = attributes.get("height");
        if (heightString != null) {
            try {
                h = Integer.parseInt(heightString);
            }
            catch (NumberFormatException e) {
                SlimRestFixtureWithSeq.LOG.debug((Object)("Unable to parse height as integer: " + heightString));
            }
        }
        return PictureGenerator.transcode(ret, format, w, h);
    }

    public static byte[] transcode(byte[] svg, String format, Integer w, Integer h) {
        JPEGTranscoder trans = null;
        if (format.equals("jpg")) {
            trans = new JPEGTranscoder();
        } else if (format.equals("png")) {
            trans = new PNGTranscoder();
        } else {
            throw new IllegalArgumentException("Unsupported raster format. Only jpg and png: " + format);
        }
        TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(svg));
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        if (w != null && h != null) {
            Rectangle aoi = new Rectangle(w, h);
            trans.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)new Float(aoi.width));
            trans.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, (Object)new Float(aoi.height));
            trans.addTranscodingHint(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.FALSE);
            trans.addTranscodingHint(JPEGTranscoder.KEY_AOI, (Object)aoi);
        }
        try {
            trans.transcode(input, output);
        }
        catch (TranscoderException e) {
            throw new IllegalStateException("Unable to transcode to format: " + format, e);
        }
        try {
            ostream.flush();
        }
        catch (IOException e) {
            SlimRestFixtureWithSeq.LOG.debug((Object)"Unable to flush output stream");
        }
        try {
            ostream.close();
        }
        catch (IOException e) {
            SlimRestFixtureWithSeq.LOG.debug((Object)"Unable to close output stream");
        }
        return ostream.toByteArray();
    }
}

